/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.attachment;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.FileAttachmentResource;
import org.exoplatform.social.attachment.model.FileAttachmentResourceList;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.exoplatform.social.attachment.model.ObjectAttachmentOperationReport;
import org.exoplatform.social.rest.api.RestUtils;

@Path(value="v1/social/attachments")
@Tag(name="v1/social/attachments", description="Managing attachments for any type of data")
public class AttachmentRest
implements ResourceContainer {
    private static final String ATTACHMENT_OBJECT_ID_REQUIRED_MESSAGE = "attachment.objectIdRequired";
    private static final String ATTACHMENT_OBJECT_TYPE_REQUIRED_MESSAGE = "attachment.objectTypeRequired";
    private static final String ATTACHMENT_UNAUTHORIZED_ACCESS_MESSAGE = "attachment.unauthorizedAccess";
    private static final String ATTACHMENT_OBJECT_NOT_FOUND_MESSAGE = "attachment.objectNotFound";
    private static final CacheControl CACHE_CONTROL = new CacheControl();
    private static final int CACHE_IN_SECONDS = 604800;
    private static final int CACHE_IN_MILLI_SECONDS = 604800000;
    private static final Log LOG = ExoLogger.getLogger(AttachmentRest.class);
    private AttachmentService attachmentService;

    public AttachmentRest(AttachmentService attachmentService) {
        this.attachmentService = attachmentService;
        CACHE_CONTROL.setMaxAge(604800);
    }

    @PUT
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Updates the list of attachements of an object", description="Updates the list of attachements of an object", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized request"), @ApiResponse(responseCode="404", description="Not found")})
    public Response saveAttachments(@RequestBody(description="Object file Attachments", required=true) FileAttachmentResourceList attachmentResource) {
        String objectType = attachmentResource.getObjectType();
        if (StringUtils.isBlank((CharSequence)objectType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_TYPE_REQUIRED_MESSAGE).type("text/plain").build();
        }
        String objectId = attachmentResource.getObjectId();
        if (StringUtils.isBlank((CharSequence)objectId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_ID_REQUIRED_MESSAGE).type("text/plain").build();
        }
        long currentUserIdentityId = RestUtils.getCurrentUserIdentityId();
        attachmentResource.setUserIdentityId(currentUserIdentityId);
        try {
            Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
            ObjectAttachmentOperationReport report = this.attachmentService.saveAttachments(attachmentResource, authenticatedUserIdentity);
            return Response.ok((Object)(report == null ? "{}" : report)).build();
        }
        catch (IllegalAccessException e) {
            LOG.debug("Unautorized access for user {} to update attachments {}", new Object[]{currentUserIdentityId, attachmentResource, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ATTACHMENT_UNAUTHORIZED_ACCESS_MESSAGE).type("text/plain").build();
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("Object not found while processing user {} operation for attachments update {}", new Object[]{currentUserIdentityId, attachmentResource, e});
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ATTACHMENT_OBJECT_NOT_FOUND_MESSAGE).type("text/plain").build();
        }
    }

    @GET
    @Path(value="{objectType}/{objectId}")
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves files of a given object identified by its id", description="Retrieves files of a given object identified by its id", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized request"), @ApiResponse(responseCode="404", description="Not found")})
    public Response getAttachments(@Parameter(description="Object type: activity, task, notes ...", required=true) @PathParam(value="objectType") String objectType, @Parameter(description="Identifier of object to which attachment will be associated", required=true) @PathParam(value="objectId") String objectId, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="limit") @DefaultValue(value="0") int limit) {
        if (StringUtils.isBlank((CharSequence)objectType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_TYPE_REQUIRED_MESSAGE).type("application/json").build();
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_ID_REQUIRED_MESSAGE).type("application/json").build();
        }
        try {
            Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
            ObjectAttachmentList attachmentList = this.attachmentService.getAttachments(objectType, objectId, authenticatedUserIdentity, offset, limit);
            return Response.ok((Object)attachmentList).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)ATTACHMENT_UNAUTHORIZED_ACCESS_MESSAGE).type("text/plain").build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ATTACHMENT_OBJECT_NOT_FOUND_MESSAGE).type("text/plain").build();
        }
    }

    @GET
    @Path(value="{objectType}/{objectId}/{fileId}")
    @Operation(summary="Retrieves file stream content attached to a given object identified by its id", description="Retrieves file stream content attached to a given object identified by its id", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized request"), @ApiResponse(responseCode="404", description="Not found")})
    public Response getAttachment(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Object type: activity, task, notes ...", required=true) @PathParam(value="objectType") String objectType, @Parameter(description="Identifier of object to which attachment will be associated", required=true) @PathParam(value="objectId") String objectId, @Parameter(description="Identifier of attached file", required=true) @PathParam(value="fileId") String fileId, @Parameter(description="The value of lastModified parameter will determine whether the query should be cached by browser or not. If not set, no 'expires HTTP Header will be sent'") @QueryParam(value="lastModified") String lastModified, @Parameter(description="Resized avatar size. Use 0x0 for original size.") @DefaultValue(value="0x0") @QueryParam(value="size") String size, @Parameter(description="Whether to add HTTP Header for download or not", required=true) @QueryParam(value="download") boolean download) {
        ObjectAttachmentDetail attachmentDetail;
        if (StringUtils.isBlank((CharSequence)objectType)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_TYPE_REQUIRED_MESSAGE).build();
        }
        if (StringUtils.isBlank((CharSequence)objectId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_ID_REQUIRED_MESSAGE).build();
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        try {
            attachmentDetail = this.attachmentService.getAttachment(objectType, objectId, fileId, authenticatedUserIdentity);
            if (attachmentDetail == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"attachment.attachmentNotFound").build();
            }
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ATTACHMENT_OBJECT_NOT_FOUND_MESSAGE).build();
        }
        try {
            Long lastUpdated = attachmentDetail.getUpdated();
            EntityTag eTag = new EntityTag(lastUpdated.hashCode() + "-" + size);
            Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
            if (builder == null) {
                builder = this.buildAttachmentResponse(objectType, objectId, fileId, size, authenticatedUserIdentity, attachmentDetail, lastUpdated, eTag);
            }
            String fileName = URLEncoder.encode(attachmentDetail.getName(), StandardCharsets.UTF_8).replace("+", "%20");
            if (download) {
                builder.header("Content-Disposition", (Object)("attachment; filename=\"" + fileName + "\"; filename*=UTF-8''" + fileName));
            } else {
                builder.header("Content-Disposition", (Object)("filename=\"" + fileName + "\"; filename*=UTF-8''" + fileName));
            }
            if (StringUtils.isNotBlank((CharSequence)lastModified)) {
                builder.expires(new Date(System.currentTimeMillis() + 604800000L));
            }
            return builder.build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ATTACHMENT_OBJECT_NOT_FOUND_MESSAGE).build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"attachment.fileReadingError").build();
        }
    }

    @POST
    @RolesAllowed(value={"users"})
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create an attachment", description="Create an attachment", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="201", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized request")})
    public Response createAttachment(@RequestBody(description="Object file Attachment", required=true) FileAttachmentResource attachmentResource) {
        if (attachmentResource == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"attachment resource object is mandatory").build();
        }
        if (attachmentResource.getFileAttachmentObject() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"attachment file object is mandatory").build();
        }
        if (attachmentResource.getObjectType() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_TYPE_REQUIRED_MESSAGE).build();
        }
        if (attachmentResource.getObjectId() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_ID_REQUIRED_MESSAGE).build();
        }
        try {
            ObjectAttachmentDetail attachmentDetail = this.attachmentService.createAttachment(attachmentResource.getObjectType(), attachmentResource.getObjectId(), attachmentResource.getFileAttachmentObject(), RestUtils.getCurrentUserAclIdentity());
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)attachmentDetail).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @DELETE
    @Path(value="{objectType}/{objectId}/{fileId}")
    @RolesAllowed(value={"administrators"})
    @Produces(value={"text/plain"})
    @Operation(summary="Delete an attachment", description="Delete an attachment", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Object not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response deleteAttachment(@Parameter(description="attachment object type") @PathParam(value="objectType") String objectType, @Parameter(description="attachment object id") @PathParam(value="objectId") String objectId, @Parameter(description="attachment file id") @PathParam(value="fileId") String fileId) {
        if (objectType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_TYPE_REQUIRED_MESSAGE).build();
        }
        if (objectId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ATTACHMENT_OBJECT_ID_REQUIRED_MESSAGE).build();
        }
        if (fileId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"attachment file id is mandatory").build();
        }
        ObjectAttachmentDetail objectAttachmentDetail = this.attachmentService.getAttachment(objectType, objectId, fileId);
        if (objectAttachmentDetail == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"attachment not found").build();
        }
        try {
            this.attachmentService.deleteAttachment(objectType, objectId, fileId);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while deleting attachment", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    private Response.ResponseBuilder buildAttachmentResponse(String objectType, String objectId, String fileId, String size, Identity authenticatedUserIdentity, ObjectAttachmentDetail attachmentDetail, Long lastUpdated, EntityTag eTag) throws IllegalAccessException, ObjectNotFoundException, IOException {
        InputStream attachmentInputStream = this.attachmentService.getAttachmentInputStream(objectType, objectId, fileId, size, authenticatedUserIdentity);
        String mimeType = attachmentDetail.getMimetype();
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            mimeType = "application/octet-stream";
        }
        Response.ResponseBuilder builder = Response.ok((Object)attachmentInputStream).type(mimeType);
        builder.cacheControl(CACHE_CONTROL);
        builder.lastModified(new Date(lastUpdated));
        builder.tag(eTag);
        return builder;
    }
}

