/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.handler;

import io.meeds.social.space.model.SpaceCreationInstance;
import io.meeds.social.util.JsonUtils;
import io.meeds.spring.web.localization.HttpRequestLocaleWrapper;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpaceCreationInstantiationHandler
extends WebRequestHandler {
    private static final Log LOG = ExoLogger.getLogger(SpaceCreationInstantiationHandler.class);
    public static final String NAME = "space-creation-instantiation";
    public static final String TOKEN_TYPE = "SPACE_CREATION_INSTANCE";
    private final SpaceService spaceService;
    private final WebAppController webAppController;
    private final PortalContainer container;
    private final ServletContext servletContext;
    private final UploadService uploadService;

    @Autowired
    public SpaceCreationInstantiationHandler(WebAppController webAppController, SpaceService spaceService, PortalContainer container, UploadService uploadService) {
        this.webAppController = webAppController;
        this.spaceService = spaceService;
        this.container = container;
        this.servletContext = container.getPortalContext();
        this.uploadService = uploadService;
    }

    @PostConstruct
    public void init() {
        this.webAppController.register((WebRequestHandler)this);
    }

    public String getHandlerName() {
        return NAME;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        HttpRequestLocaleWrapper request = new HttpRequestLocaleWrapper(controllerContext.getRequest());
        HttpServletResponse response = controllerContext.getResponse();
        String user = request.getRemoteUser();
        if (user != null) {
            CookieTokenService tokenService = (CookieTokenService)AbstractTokenService.getInstance(CookieTokenService.class);
            String token = this.getTokenCookie((HttpServletRequest)request);
            if (token != null) {
                Space space = new Space();
                String spaceData = tokenService.getToken(token, TOKEN_TYPE).getUsername();
                SpaceCreationInstance model = (SpaceCreationInstance)JsonUtils.fromJsonString((String)spaceData, SpaceCreationInstance.class);
                this.fillSpaceFromModel(space, model);
                space.setEditor(user);
                space = this.spaceService.createSpace(space, user);
                this.saveSpaceAvatar(space, model);
                this.saveSpaceBanner(model, space);
                RequestLifeCycle.restartTransaction();
                this.removeTokenCookie((HttpServletRequest)request, response);
                tokenService.deleteToken(token, TOKEN_TYPE);
                String path = this.servletContext.getContextPath() + "/s/" + space.getSpaceId();
                response.sendRedirect(path);
                return true;
            }
        }
        return false;
    }

    private void removeTokenCookie(HttpServletRequest request, HttpServletResponse response) {
        Cookie cookie = new Cookie("spaceCreationCookie", "");
        cookie.setPath("/");
        cookie.setMaxAge(0);
        cookie.setHttpOnly(true);
        cookie.setSecure(request.isSecure());
        response.addCookie(cookie);
    }

    private String getTokenCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"spaceCreationCookie".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    private void fillSpaceFromModel(Space space, SpaceCreationInstance model) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)model.getDisplayName())) {
            space.setDisplayName(model.getDisplayName());
            space.setDescription(model.getDescription());
            if (StringUtils.isBlank((CharSequence)space.getPrettyName())) {
                space.setPrettyName(model.getDisplayName());
            }
        } else if (StringUtils.isNotBlank((CharSequence)model.getPrettyName())) {
            space.setPrettyName(model.getPrettyName());
            space.setDescription(model.getDescription());
            space.setDisplayName(model.getPrettyName());
        }
        if (space.getSpaceId() == 0L && model.getTemplateId() > 0L) {
            space.setTemplateId(model.getTemplateId());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getId()) && StringUtils.isNotBlank((CharSequence)model.getBannerId())) {
            this.updateProfileField(space, "banner", model.getBannerId());
        }
        if (StringUtils.isNotBlank((CharSequence)model.getId()) && StringUtils.isNotBlank((CharSequence)model.getAvatarId())) {
            this.updateProfileField(space, "avatar", model.getAvatarId());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"hidden", (CharSequence)model.getVisibility())) {
            space.setVisibility("hidden");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"private", (CharSequence)model.getVisibility())) {
            space.setVisibility("private");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"public", (CharSequence)model.getVisibility())) {
            space.setVisibility("public");
        } else if (StringUtils.isBlank((CharSequence)model.getVisibility()) && space.getId() == null) {
            space.setVisibility("private");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"open", (CharSequence)model.getSubscription())) {
            space.setRegistration("open");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"closed", (CharSequence)model.getSubscription())) {
            space.setRegistration("closed");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"validation", (CharSequence)model.getSubscription())) {
            space.setRegistration("validation");
        } else if (StringUtils.isBlank((CharSequence)model.getSubscription()) && space.getId() == null) {
            space.setRegistration("validation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProfileField(Space space, String name, String value) throws IOException {
        if ("banner".equals(name) && StringUtils.equals((CharSequence)value, (CharSequence)"DEFAULT_BANNER")) {
            space.setBannerAttachment(null);
            this.spaceService.updateSpaceBanner(space, RestUtils.getCurrentUser());
        } else if ("avatar".equals(name) || "banner".equals(name)) {
            UploadResource uploadResource = this.uploadService.getUploadResource(value);
            if (uploadResource == null) {
                throw new IllegalStateException("No uploaded resource found with uploadId = " + value);
            }
            String storeLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(storeLocation);){
                if ("avatar".equals(name)) {
                    AvatarAttachment attachment = new AvatarAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    space.setAvatarAttachment(attachment);
                    this.spaceService.updateSpaceAvatar(space, RestUtils.getCurrentUser());
                } else {
                    BannerAttachment attachment = new BannerAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    space.setBannerAttachment(attachment);
                    this.spaceService.updateSpaceBanner(space, RestUtils.getCurrentUser());
                }
            }
            finally {
                this.uploadService.removeUploadResource(value);
            }
        }
    }

    private void saveSpaceAvatar(Space space, SpaceCreationInstance model) {
        if (StringUtils.isNotBlank((CharSequence)model.getAvatarId())) {
            try {
                this.updateProfileField(space, "avatar", model.getAvatarId());
            }
            catch (IOException e) {
                LOG.warn((Object)"Error adding Space Avatar. Avoid stopping space creation process and continue", (Throwable)e);
            }
        }
    }

    private void saveSpaceBanner(SpaceCreationInstance model, Space space) {
        if (StringUtils.isNotBlank((CharSequence)model.getBannerId())) {
            try {
                this.updateProfileField(space, "banner", model.getBannerId());
            }
            catch (IOException e) {
                LOG.warn((Object)"Error adding Space Banner. Avoid stopping space creation process and continue", (Throwable)e);
            }
        }
    }
}

