/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.services.rest.ComponentLifecycleScope;
import org.exoplatform.services.rest.ConstructorDescriptor;
import org.exoplatform.services.rest.FieldInjector;
import org.exoplatform.services.rest.ObjectModel;
import org.exoplatform.services.rest.impl.ConstructorDescriptorImpl;
import org.exoplatform.services.rest.impl.FieldInjectorImpl;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;

public abstract class BaseObjectModel
implements ObjectModel {
    protected final Class<?> clazz;
    protected final List<ConstructorDescriptor> constructors;
    protected final List<FieldInjector> fields;
    protected MultivaluedMapImpl properties;

    public BaseObjectModel(Class<?> clazz, ComponentLifecycleScope scope) {
        this.clazz = clazz;
        this.constructors = new ArrayList<ConstructorDescriptor>();
        this.fields = new ArrayList<FieldInjector>();
        if (scope == ComponentLifecycleScope.PER_REQUEST) {
            String resourcePackageName;
            Field[] jfields;
            Constructor<?>[] jConstructors;
            for (Constructor<?> constructor : jConstructors = this.clazz.getConstructors()) {
                this.constructors.add(new ConstructorDescriptorImpl(clazz, constructor));
            }
            if (this.constructors.size() == 0) {
                String msg = "Not found accepted constructors for provider class " + clazz.getName();
                throw new RuntimeException(msg);
            }
            if (this.constructors.size() > 1) {
                Collections.sort(this.constructors, ConstructorDescriptorImpl.CONSTRUCTOR_COMPARATOR);
            }
            for (Field jfield : jfields = this.clazz.getDeclaredFields()) {
                this.fields.add(new FieldInjectorImpl(clazz, jfield));
            }
            Package _package = clazz.getPackage();
            String string = resourcePackageName = _package != null ? _package.getName() : null;
            for (Class<?> sc = clazz.getSuperclass(); sc != Object.class; sc = sc.getSuperclass()) {
                for (Field jfield : sc.getDeclaredFields()) {
                    FieldInjectorImpl inj;
                    String scPackageName;
                    int modif = jfield.getModifiers();
                    Package package1 = clazz.getPackage();
                    String string2 = scPackageName = package1 != null ? package1.getName() : null;
                    if (Modifier.isPrivate(modif) || !Modifier.isPublic(modif) && !Modifier.isProtected(modif) && (Modifier.isPrivate(modif) || (resourcePackageName != null || scPackageName != null) && (resourcePackageName == null || !resourcePackageName.equals(scPackageName))) || (inj = new FieldInjectorImpl(clazz, jfield)).getAnnotation() == null) continue;
                    this.fields.add(new FieldInjectorImpl(clazz, jfield));
                }
            }
        }
    }

    @Override
    public Class<?> getObjectClass() {
        return this.clazz;
    }

    @Override
    public List<ConstructorDescriptor> getConstructorDescriptors() {
        return this.constructors;
    }

    @Override
    public List<FieldInjector> getFieldInjectors() {
        return this.fields;
    }

    @Override
    public MultivaluedMap<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new MultivaluedMapImpl();
        }
        return this.properties;
    }

    @Override
    public List<String> getProperty(String key) {
        if (this.properties != null) {
            return (List)this.properties.get(key);
        }
        return null;
    }
}

