/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.category.service;

import io.meeds.social.category.model.Category;
import io.meeds.social.category.model.CategoryObject;
import io.meeds.social.category.service.CategoryLinkService;
import io.meeds.social.category.service.CategoryPluginService;
import io.meeds.social.category.service.CategoryService;
import io.meeds.social.category.storage.CategoryStorage;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryLinkServiceImpl
implements CategoryLinkService {
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private CategoryStorage categoryStorage;
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private CategoryPluginService categoryPluginService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private ListenerService listenerService;
    private long superUserIdentityId;

    public List<Long> getLinkedIds(CategoryObject object) {
        return this.categoryStorage.getLinkedIds(this.getObject(object));
    }

    public List<Long> getLinkedIds(String objectType) {
        return this.categoryStorage.getLinkedIds(objectType);
    }

    public boolean isLinked(long categoryId, CategoryObject object) {
        return this.categoryStorage.isLinked(categoryId, this.getObject(object));
    }

    public void link(long categoryId, CategoryObject object, String username) throws ObjectNotFoundException, ObjectAlreadyExistsException, IllegalAccessException {
        CategoryObject transfomedObject = this.getObject(object);
        this.checkCanManageLink(categoryId, transfomedObject, username);
        if (this.isLinked(categoryId, transfomedObject)) {
            throw new ObjectAlreadyExistsException((Object)object);
        }
        long userIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(username).getId());
        this.link(categoryId, object, userIdentityId);
    }

    public void link(long categoryId, CategoryObject object) {
        this.link(categoryId, object, this.getSuperUserIdentityId());
    }

    public void unlink(long categoryId, CategoryObject object, String username) throws ObjectNotFoundException, IllegalAccessException {
        CategoryObject transfomedObject = this.getObject(object);
        this.checkCanManageLink(categoryId, transfomedObject, username);
        this.unlink(categoryId, object);
    }

    public void unlink(long categoryId, CategoryObject object) {
        CategoryObject transfomedObject = this.getObject(object);
        this.categoryStorage.unlink(categoryId, transfomedObject);
        this.listenerService.broadcast("category.link.removed", (Object)categoryId, (Object)transfomedObject);
        if (ObjectUtils.notEqual((Object)object, (Object)transfomedObject)) {
            this.listenerService.broadcast("category.link.removed", (Object)categoryId, (Object)object);
        }
    }

    private void checkCanManageLink(long categoryId, CategoryObject object, String username) throws ObjectNotFoundException, IllegalAccessException {
        Category category = this.categoryStorage.getCategory(categoryId);
        if (category == null) {
            throw new ObjectNotFoundException(String.format("Category with id %s doesn't exist", categoryId));
        }
        if (!this.isAdministrator(username)) {
            if (!this.categoryService.canManageLink(category, username)) {
                throw new IllegalAccessException(String.format("Category with id %s doesn't exist", categoryId));
            }
            if (!this.categoryPluginService.canEdit(object.getType(), object.getId(), username)) {
                throw new IllegalAccessException(String.format("Object with type %s and id %s isn't editable by user", object.getType(), object.getId()));
            }
        }
    }

    private void link(long categoryId, CategoryObject object, long userIdentityId) {
        CategoryObject transfomedObject = this.getObject(object);
        this.categoryStorage.link(categoryId, transfomedObject, userIdentityId);
        this.listenerService.broadcast("category.link.added", (Object)categoryId, (Object)transfomedObject);
        if (ObjectUtils.notEqual((Object)object, (Object)transfomedObject)) {
            this.listenerService.broadcast("category.link.added", (Object)categoryId, (Object)object);
        }
    }

    private long getSuperUserIdentityId() {
        if (this.superUserIdentityId == 0L) {
            this.superUserIdentityId = Long.parseLong(this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser()).getId());
        }
        return this.superUserIdentityId;
    }

    private boolean isAdministrator(String username) {
        return this.userAcl.isAdministrator(this.userAcl.getUserIdentity(username));
    }

    private CategoryObject getObject(CategoryObject object) {
        return this.categoryPluginService.getObject(object);
    }
}

