/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.space.impl;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.space.service.SpaceLayoutService;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.impl.SpaceRenamedListenerImpl$AjcClosure1;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;

public class SpaceRenamedListenerImpl
extends SpaceListenerPlugin {
    private static final Log LOG;
    private SpaceLayoutService spaceLayoutService;
    private SpaceService spaceService;
    private OrganizationService organizationService;
    private IdentityManager identityManager;
    private FileService fileService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        Space space = event.getSpace();
        this.renameGroupLabel(space);
        this.updateDefaultSpaceAvatar(space);
        this.updateSpaceUrl(space);
    }

    @ContainerTransactional
    private void renameGroupLabel(Space space) {
        Space space2 = space;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)space2);
        Object[] objectArray = new Object[]{this, space2, joinPoint};
        SpaceRenamedListenerImpl$AjcClosure1 spaceRenamedListenerImpl$AjcClosure1 = new SpaceRenamedListenerImpl$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(spaceRenamedListenerImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void updateDefaultSpaceAvatar(Space space) {
        Identity spaceIdentity = this.getIdentityManager().getOrCreateSpaceIdentity(space.getPrettyName());
        FileItem spaceAvatar = this.identityManager.getAvatarFile(spaceIdentity);
        if (spaceAvatar != null && spaceAvatar.getFileInfo().getId() != null && "DEFAULT_AVATAR".equals(spaceAvatar.getFileInfo().getName())) {
            Profile profile = spaceIdentity.getProfile();
            profile.removeProperty("avatar");
            profile.setAvatarUrl(null);
            profile.setAvatarLastUpdated(null);
            profile.setProperty("fullName", (Object)space.getDisplayName());
            space.setAvatarAttachment(null);
            space.setAvatarLastUpdated(Long.valueOf(System.currentTimeMillis()));
            this.identityManager.updateProfile(profile);
            this.getFileService().deleteFile(spaceAvatar.getFileInfo().getId().longValue());
        }
    }

    private void updateSpaceUrl(Space space) {
        String spaceUri = this.getSpaceLayoutService().getFirstSpacePageUri(space.getGroupId());
        if (!StringUtils.equals((CharSequence)spaceUri, (CharSequence)space.getUrl())) {
            space.setUrl((String)StringUtils.firstNonBlank((CharSequence[])new String[]{spaceUri, space.getUrl(), "home"}));
            this.getSpaceService().updateSpace(space);
        }
    }

    public SpaceLayoutService getSpaceLayoutService() {
        if (this.spaceLayoutService == null) {
            this.spaceLayoutService = (SpaceLayoutService)ExoContainerContext.getService(SpaceLayoutService.class);
        }
        return this.spaceLayoutService;
    }

    public SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)ExoContainerContext.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    public FileService getFileService() {
        if (this.fileService == null) {
            this.fileService = (FileService)ExoContainerContext.getService(FileService.class);
        }
        return this.fileService;
    }

    public IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            this.identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        }
        return this.identityManager;
    }

    public OrganizationService getOrganizationService() {
        if (this.organizationService == null) {
            this.organizationService = (OrganizationService)ExoContainerContext.getService(OrganizationService.class);
        }
        return this.organizationService;
    }

    static {
        SpaceRenamedListenerImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(SpaceRenamedListenerImpl.class);
    }

    static final /* synthetic */ void renameGroupLabel_aroundBody0(SpaceRenamedListenerImpl ajc$this, Space space, JoinPoint joinPoint) {
        try {
            GroupHandler groupHandler = ajc$this.getOrganizationService().getGroupHandler();
            Group group = groupHandler.findGroupById(space.getGroupId());
            group.setLabel(space.getDisplayName());
            groupHandler.saveGroup(group, true);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while renaming, space group Label, ignore minor change and keep the old Group Label", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpaceRenamedListenerImpl.java", SpaceRenamedListenerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "renameGroupLabel", "org.exoplatform.social.core.space.impl.SpaceRenamedListenerImpl", "org.exoplatform.social.core.space.model.Space", "space", "", "void"), 68);
    }
}

