/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.SequenceGenerators;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.TableGenerators;
import jakarta.persistence.Version;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.IdGeneratorType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.ValueGenerationType;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.boot.internal.GenerationStrategyInterpreter;
import org.hibernate.boot.model.IdentifierGeneratorDefinition;
import org.hibernate.boot.model.internal.BinderHelper;
import org.hibernate.boot.model.internal.HCANNHelper;
import org.hibernate.boot.model.internal.IdGeneratorResolverSecondPass;
import org.hibernate.boot.model.relational.ExportableProducer;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.boot.spi.PropertyData;
import org.hibernate.generator.AnnotationBasedGenerator;
import org.hibernate.generator.BeforeExecutionGenerator;
import org.hibernate.generator.Generator;
import org.hibernate.generator.GeneratorCreationContext;
import org.hibernate.generator.OnExecutionGenerator;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.factory.internal.IdentifierGeneratorUtil;
import org.hibernate.id.factory.spi.CustomIdGeneratorCreationContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.mapping.GeneratorCreator;
import org.hibernate.mapping.IdentifierGeneratorCreator;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.resource.beans.container.spi.BeanContainer;
import org.hibernate.resource.beans.spi.BeanInstanceProducer;
import org.jboss.logging.Logger;

public class GeneratorBinder {
    private static final Logger LOG = CoreLogging.logger(BinderHelper.class);

    public static void makeIdGenerator(SimpleValue id, XProperty property, String generatorType, String generatorName, MetadataBuildingContext buildingContext, Map<String, IdentifierGeneratorDefinition> localGenerators) {
        LOG.debugf("#makeIdGenerator(%s, %s, %s, %s, ...)", new Object[]{id, property, generatorType, generatorName});
        id.setIdentifierGeneratorStrategy(generatorType);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("target_table", id.getTable().getName());
        if (id.getColumnSpan() == 1) {
            parameters.put("target_column", id.getColumns().get(0).getName());
        }
        parameters.put("identifier_normalizer", buildingContext.getObjectNameNormalizer());
        parameters.put("GENERATOR_NAME", generatorName);
        if (!generatorName.isEmpty()) {
            boolean avoidOverriding;
            IdentifierGeneratorDefinition definition = GeneratorBinder.makeIdentifierGeneratorDefinition(generatorName, property, localGenerators, buildingContext);
            if (definition == null) {
                throw new AnnotationException("No id generator was declared with the name '" + generatorName + "' specified by '@GeneratedValue' (define a named generator using '@SequenceGenerator', '@TableGenerator', or '@GenericGenerator')");
            }
            String identifierGeneratorStrategy = definition.getStrategy();
            boolean bl = avoidOverriding = identifierGeneratorStrategy.equals("identity") || identifierGeneratorStrategy.equals("seqhilo");
            if (generatorType == null || !avoidOverriding) {
                id.setIdentifierGeneratorStrategy(identifierGeneratorStrategy);
            }
            parameters.putAll(definition.getParameters());
        }
        id.setIdentifierGeneratorParameters(parameters);
    }

    public static void makeIdGenerator(SimpleValue id, XProperty idXProperty, String generatorType, String generatorName, MetadataBuildingContext buildingContext, IdentifierGeneratorDefinition foreignKGeneratorDefinition) {
        HashMap<String, IdentifierGeneratorDefinition> localIdentifiers = null;
        if (foreignKGeneratorDefinition != null) {
            localIdentifiers = new HashMap<String, IdentifierGeneratorDefinition>();
            localIdentifiers.put(foreignKGeneratorDefinition.getName(), foreignKGeneratorDefinition);
        }
        GeneratorBinder.makeIdGenerator(id, idXProperty, generatorType, generatorName, buildingContext, localIdentifiers);
    }

    private static IdentifierGeneratorDefinition makeIdentifierGeneratorDefinition(String name, XProperty idProperty, Map<String, IdentifierGeneratorDefinition> localGenerators, MetadataBuildingContext buildingContext) {
        IdentifierGeneratorDefinition result;
        if (localGenerators != null && (result = localGenerators.get(name)) != null) {
            return result;
        }
        IdentifierGeneratorDefinition globalDefinition = buildingContext.getMetadataCollector().getIdentifierGenerator(name);
        if (globalDefinition != null) {
            return globalDefinition;
        }
        LOG.debugf("Could not resolve explicit IdentifierGeneratorDefinition - using implicit interpretation (%s)", (Object)name);
        GeneratedValue generatedValue = (GeneratedValue)idProperty.getAnnotation(GeneratedValue.class);
        if (generatedValue == null) {
            return new IdentifierGeneratorDefinition("assigned", "assigned");
        }
        return IdentifierGeneratorDefinition.createImplicit(name, buildingContext.getBootstrapContext().getReflectionManager().toClass(idProperty.getType()), generatedValue.generator(), GeneratorBinder.interpretGenerationType(generatedValue));
    }

    private static GenerationType interpretGenerationType(GeneratedValue generatedValueAnn) {
        return generatedValueAnn.strategy() == null ? GenerationType.AUTO : generatedValueAnn.strategy();
    }

    public static Map<String, IdentifierGeneratorDefinition> buildGenerators(XAnnotatedElement annotatedElement, MetadataBuildingContext context) {
        GenericGenerator genericGenerator;
        SequenceGenerator sequenceGenerator;
        TableGenerator tableGenerator;
        SequenceGenerators sequenceGenerators;
        IdentifierGeneratorDefinition idGenerator;
        InFlightMetadataCollector metadataCollector = context.getMetadataCollector();
        HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>();
        TableGenerators tableGenerators = (TableGenerators)annotatedElement.getAnnotation(TableGenerators.class);
        if (tableGenerators != null) {
            for (TableGenerator tableGenerator2 : tableGenerators.value()) {
                idGenerator = GeneratorBinder.buildIdGenerator((Annotation)tableGenerator2, context);
                generators.put(idGenerator.getName(), idGenerator);
                metadataCollector.addIdentifierGenerator(idGenerator);
            }
        }
        if ((sequenceGenerators = (SequenceGenerators)annotatedElement.getAnnotation(SequenceGenerators.class)) != null) {
            for (SequenceGenerator sequenceGenerator2 : sequenceGenerators.value()) {
                IdentifierGeneratorDefinition idGenerator2 = GeneratorBinder.buildIdGenerator((Annotation)sequenceGenerator2, context);
                generators.put(idGenerator2.getName(), idGenerator2);
                metadataCollector.addIdentifierGenerator(idGenerator2);
            }
        }
        if ((tableGenerator = (TableGenerator)annotatedElement.getAnnotation(TableGenerator.class)) != null) {
            IdentifierGeneratorDefinition idGenerator3 = GeneratorBinder.buildIdGenerator((Annotation)tableGenerator, context);
            generators.put(idGenerator3.getName(), idGenerator3);
            metadataCollector.addIdentifierGenerator(idGenerator3);
        }
        if ((sequenceGenerator = (SequenceGenerator)annotatedElement.getAnnotation(SequenceGenerator.class)) != null) {
            IdentifierGeneratorDefinition idGenerator4 = GeneratorBinder.buildIdGenerator((Annotation)sequenceGenerator, context);
            generators.put(idGenerator4.getName(), idGenerator4);
            metadataCollector.addIdentifierGenerator(idGenerator4);
        }
        if ((genericGenerator = (GenericGenerator)annotatedElement.getAnnotation(GenericGenerator.class)) != null) {
            idGenerator = GeneratorBinder.buildIdGenerator(genericGenerator, context);
            generators.put(idGenerator.getName(), idGenerator);
            metadataCollector.addIdentifierGenerator(idGenerator);
        }
        return generators;
    }

    static String generatorType(MetadataBuildingContext context, XClass entityXClass, boolean isComponent, GeneratedValue generatedValue) {
        if (isComponent) {
            return "assigned";
        }
        return generatedValue == null ? "assigned" : GeneratorBinder.generatorType(generatedValue, entityXClass, context);
    }

    static String generatorType(final GeneratedValue generatedValue, final XClass javaClass, final MetadataBuildingContext context) {
        return GenerationStrategyInterpreter.STRATEGY_INTERPRETER.determineGeneratorName(generatedValue.strategy(), new GenerationStrategyInterpreter.GeneratorNameDeterminationContext(){
            Class<?> javaType = null;

            @Override
            public Class<?> getIdType() {
                if (this.javaType == null) {
                    this.javaType = context.getBootstrapContext().getReflectionManager().toClass(javaClass);
                }
                return this.javaType;
            }

            @Override
            public String getGeneratedValueGeneratorName() {
                return generatedValue.generator();
            }
        });
    }

    static IdentifierGeneratorDefinition buildIdGenerator(Annotation generatorAnnotation, MetadataBuildingContext context) {
        if (generatorAnnotation == null) {
            return null;
        }
        IdentifierGeneratorDefinition.Builder definitionBuilder = new IdentifierGeneratorDefinition.Builder();
        if (generatorAnnotation instanceof TableGenerator) {
            GenerationStrategyInterpreter.STRATEGY_INTERPRETER.interpretTableGenerator((TableGenerator)generatorAnnotation, definitionBuilder);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add table generator with name: {0}", (Object)definitionBuilder.getName());
            }
        } else if (generatorAnnotation instanceof SequenceGenerator) {
            GenerationStrategyInterpreter.STRATEGY_INTERPRETER.interpretSequenceGenerator((SequenceGenerator)generatorAnnotation, definitionBuilder);
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add sequence generator with name: {0}", (Object)definitionBuilder.getName());
            }
        } else if (generatorAnnotation instanceof GenericGenerator) {
            GenericGenerator genericGenerator = (GenericGenerator)generatorAnnotation;
            definitionBuilder.setName(genericGenerator.name());
            String strategy = genericGenerator.type().equals(Generator.class) ? genericGenerator.strategy() : genericGenerator.type().getName();
            definitionBuilder.setStrategy(strategy);
            for (Parameter parameter : genericGenerator.parameters()) {
                definitionBuilder.addParam(parameter.name(), parameter.value());
            }
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Add generic generator with name: {0}", (Object)definitionBuilder.getName());
            }
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + String.valueOf(generatorAnnotation));
        }
        return definitionBuilder.build();
    }

    private static void checkGeneratorClass(Class<? extends Generator> generatorClass) {
        if (!BeforeExecutionGenerator.class.isAssignableFrom(generatorClass) && !OnExecutionGenerator.class.isAssignableFrom(generatorClass)) {
            throw new MappingException("Generator class '" + generatorClass.getName() + "' must implement either 'BeforeExecutionGenerator' or 'OnExecutionGenerator'");
        }
    }

    private static void checkGeneratorInterfaces(Class<? extends Generator> generatorClass) {
        if (IdentifierGenerator.class.isAssignableFrom(generatorClass)) {
            throw new AnnotationException("Generator class '" + generatorClass.getName() + "' implements 'IdentifierGenerator' and may not be used with '@ValueGenerationType'");
        }
        if (ExportableProducer.class.isAssignableFrom(generatorClass)) {
            throw new AnnotationException("Generator class '" + generatorClass.getName() + "' implements 'ExportableProducer' and may not be used with '@ValueGenerationType'");
        }
    }

    static GeneratorCreator generatorCreator(XProperty property, Annotation annotation) {
        Member member = HCANNHelper.getUnderlyingMember(property);
        Class<? extends Annotation> annotationType = annotation.annotationType();
        ValueGenerationType generatorAnnotation = annotationType.getAnnotation(ValueGenerationType.class);
        if (generatorAnnotation == null) {
            return null;
        }
        Class<? extends Generator> generatorClass = generatorAnnotation.generatedBy();
        GeneratorBinder.checkGeneratorClass(generatorClass);
        GeneratorBinder.checkGeneratorInterfaces(generatorClass);
        return creationContext -> {
            Object generator = GeneratorBinder.instantiateGenerator(annotation, member, annotationType, creationContext, GeneratorCreationContext.class, generatorClass);
            GeneratorBinder.callInitialize(annotation, member, creationContext, generator);
            GeneratorBinder.checkVersionGenerationAlways(property, generator);
            return generator;
        };
    }

    static IdentifierGeneratorCreator identifierGeneratorCreator(XProperty idProperty, Annotation annotation, BeanContainer beanContainer) {
        Member member = HCANNHelper.getUnderlyingMember(idProperty);
        Class<? extends Annotation> annotationType = annotation.annotationType();
        IdGeneratorType idGeneratorType = annotationType.getAnnotation(IdGeneratorType.class);
        assert (idGeneratorType != null);
        return creationContext -> {
            Class<? extends Generator> generatorClass = idGeneratorType.value();
            GeneratorBinder.checkGeneratorClass(generatorClass);
            Generator generator = GeneratorBinder.instantiateGenerator(annotation, beanContainer, creationContext, generatorClass, member, annotationType);
            GeneratorBinder.callInitialize(annotation, member, creationContext, generator);
            GeneratorBinder.callConfigure(creationContext, generator);
            GeneratorBinder.checkIdGeneratorTiming(annotationType, generator);
            return generator;
        };
    }

    private static Generator instantiateGenerator(Annotation annotation, BeanContainer beanContainer, CustomIdGeneratorCreationContext creationContext, Class<? extends Generator> generatorClass, Member member, Class<? extends Annotation> annotationType) {
        if (beanContainer != null) {
            return GeneratorBinder.instantiateGeneratorAsBean(annotation, beanContainer, creationContext, generatorClass, member, annotationType);
        }
        return GeneratorBinder.instantiateGenerator(annotation, member, annotationType, creationContext, CustomIdGeneratorCreationContext.class, generatorClass);
    }

    private static Generator instantiateGeneratorAsBean(final Annotation annotation, BeanContainer beanContainer, final CustomIdGeneratorCreationContext creationContext, final Class<? extends Generator> generatorClass, final Member member, final Class<? extends Annotation> annotationType) {
        return beanContainer.getBean(generatorClass, new BeanContainer.LifecycleOptions(){

            @Override
            public boolean canUseCachedReferences() {
                return false;
            }

            @Override
            public boolean useJpaCompliantCreation() {
                return true;
            }
        }, new BeanInstanceProducer(){

            @Override
            public <B> B produceBeanInstance(Class<B> beanType) {
                return (B)GeneratorBinder.instantiateGenerator(annotation, member, annotationType, creationContext, CustomIdGeneratorCreationContext.class, generatorClass);
            }

            @Override
            public <B> B produceBeanInstance(String name, Class<B> beanType) {
                return this.produceBeanInstance(beanType);
            }
        }).getBeanInstance();
    }

    private static <C, G extends Generator> G instantiateGenerator(Annotation annotation, Member member, Class<? extends Annotation> annotationType, C creationContext, Class<C> contextClass, Class<? extends G> generatorClass) {
        try {
            try {
                return (G)((Generator)generatorClass.getConstructor(annotationType, Member.class, contextClass).newInstance(annotation, member, creationContext));
            }
            catch (NoSuchMethodException ignore) {
                try {
                    return (G)((Generator)generatorClass.getConstructor(annotationType).newInstance(annotation));
                }
                catch (NoSuchMethodException i) {
                    return (G)((Generator)generatorClass.newInstance());
                }
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new HibernateException("Could not instantiate generator of type '" + generatorClass.getName() + "'", e);
        }
    }

    private static <A extends Annotation> void callInitialize(A annotation, Member member, GeneratorCreationContext creationContext, Generator generator) {
        if (generator instanceof AnnotationBasedGenerator) {
            AnnotationBasedGenerator generation = (AnnotationBasedGenerator)generator;
            generation.initialize(annotation, member, creationContext);
        }
    }

    private static void checkVersionGenerationAlways(XProperty property, Generator generator) {
        if (property.isAnnotationPresent(Version.class)) {
            if (!generator.generatesOnInsert()) {
                throw new AnnotationException("Property '" + property.getName() + "' is annotated '@Version' but has a 'Generator' which does not generate on inserts");
            }
            if (!generator.generatesOnUpdate()) {
                throw new AnnotationException("Property '" + property.getName() + "' is annotated '@Version' but has a 'Generator' which does not generate on updates");
            }
        }
    }

    private static void callConfigure(GeneratorCreationContext creationContext, Generator generator) {
        if (generator instanceof Configurable) {
            Configurable configurable = (Configurable)((Object)generator);
            Value value = creationContext.getProperty().getValue();
            configurable.create(creationContext);
            configurable.configure(value.getType(), IdentifierGeneratorUtil.collectParameters((SimpleValue)value, creationContext.getDatabase().getDialect(), creationContext.getDefaultCatalog(), creationContext.getDefaultSchema(), creationContext.getPersistentClass().getRootClass()), creationContext.getServiceRegistry());
        }
    }

    private static void checkIdGeneratorTiming(Class<? extends Annotation> annotationType, Generator generator) {
        if (!generator.generatesOnInsert()) {
            throw new MappingException("Annotation '" + String.valueOf(annotationType) + "' is annotated 'IdGeneratorType' but the given 'Generator' does not generate on inserts");
        }
        if (generator.generatesOnUpdate()) {
            throw new MappingException("Annotation '" + String.valueOf(annotationType) + "' is annotated 'IdGeneratorType' but the given 'Generator' generates on updates (it must generate only on inserts)");
        }
    }

    static void createIdGenerator(SimpleValue idValue, Map<String, IdentifierGeneratorDefinition> classGenerators, MetadataBuildingContext context, XClass entityClass, XProperty idProperty) {
        GeneratedValue generatedValue = NullnessUtil.castNonNull((GeneratedValue)idProperty.getAnnotation(GeneratedValue.class));
        String generatorType = GeneratorBinder.generatorType(context, entityClass, BinderHelper.isCompositeId(entityClass, idProperty), generatedValue);
        String generatorName = generatedValue.generator();
        if (BinderHelper.isGlobalGeneratorNameGlobal(context)) {
            GeneratorBinder.buildGenerators((XAnnotatedElement)idProperty, context);
            context.getMetadataCollector().addSecondPass(new IdGeneratorResolverSecondPass(idValue, idProperty, generatorType, generatorName, context));
        } else {
            HashMap<String, IdentifierGeneratorDefinition> generators = new HashMap<String, IdentifierGeneratorDefinition>(classGenerators);
            generators.putAll(GeneratorBinder.buildGenerators((XAnnotatedElement)idProperty, context));
            GeneratorBinder.makeIdGenerator(idValue, idProperty, generatorType, generatorName, context, generators);
        }
    }

    static IdentifierGeneratorDefinition createForeignGenerator(PropertyData mapsIdProperty) {
        IdentifierGeneratorDefinition.Builder foreignGeneratorBuilder = new IdentifierGeneratorDefinition.Builder();
        foreignGeneratorBuilder.setName("Hibernate-local--foreign generator");
        foreignGeneratorBuilder.setStrategy("foreign");
        foreignGeneratorBuilder.addParam("property", mapsIdProperty.getPropertyName());
        return foreignGeneratorBuilder.build();
    }
}

