/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.hub.rest.client;

import io.meeds.tenant.hub.rest.client.WomConnectionService;
import io.meeds.wom.api.constant.WomException;
import io.meeds.wom.api.model.Hub;
import io.meeds.wom.api.model.HubReport;
import io.meeds.wom.api.model.HubReportVerifiableData;
import io.meeds.wom.api.model.HubUpdateRequest;
import io.meeds.wom.api.model.WomConnectionRequest;
import io.meeds.wom.api.model.WomConnectionResponse;
import io.meeds.wom.api.model.WomDisconnectionRequest;
import io.meeds.wom.api.utils.JsonUtils;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.ContentType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WomClientService {
    private static final String WOM_HUBS_URI = "/hubs";
    private static final String WOM_REPORTS_URI = "/hub/reports";
    private static final String HUB_ADDRESS_PARAM = "{hubAddress}";
    private static final String HUB_FORCE_REFRESH_PARAM = "{forceRefresh}";
    private static final String MANAGER_ADDRESS_PARAM = "{address}";
    private static final String NFT_ID_PARAM = "{nftId}";
    private static final String HASH_PARAM = "{hash}";
    private static final String WOM_CONNECT_URI = "/hubs";
    private static final String WOM_DISCONNECT_URI = "/hubs";
    private static final String WOM_UPDATE_HUB_URI = "/hubs";
    private static final String HUB_TENANT_BY_ADDRESS_URI = "/hubs/{hubAddress}?forceRefresh={forceRefresh}";
    private static final String HUB_AVATAR_BY_ADDRESS_URI = "/hubs/{hubAddress}/avatar";
    private static final String HUB_BANNER_BY_ADDRESS_URI = "/hubs/{hubAddress}/banner";
    private static final String HUB_MANAGER_CHEK_URI = "/hubs/manager?nftId={nftId}&address={address}";
    private static final String TOKEN_GENERATION_URI = "/hubs/token";
    private static final String WOM_REWARD_REPORT_URI = "/hub/reports";
    private static final String WOM_REWARD_REPORT_BY_HASH_URI = "/hub/reports/{hash}";
    private static final String WOM_URL = System.getProperty("meeds.wom.url", "https://wom.meeds.io");
    @Autowired
    private WomConnectionService womConnectionService;

    public boolean isDeedManager(String address, long nftId) throws WomException {
        String responseText = this.womConnectionService.processGet(this.getIsHubManagerUri(address, nftId));
        return StringUtils.equals((CharSequence)"true", (CharSequence)responseText);
    }

    public Hub getHub(String hubAddress, boolean forceRefresh) throws WomException {
        String responseText = this.womConnectionService.processGet(this.getDeedHubTenantUri(hubAddress, forceRefresh));
        return (Hub)JsonUtils.fromJsonString((String)responseText, Hub.class);
    }

    public String generateToken() throws WomException {
        return this.womConnectionService.processGet(this.getTokenGenerationUri());
    }

    public WomConnectionResponse connectToWom(WomConnectionRequest connectionRequest) throws WomException {
        String responseText = this.womConnectionService.processPost(this.getWoMConnectionUri(), JsonUtils.toJsonString((Object)connectionRequest));
        return (WomConnectionResponse)JsonUtils.fromJsonString((String)responseText, WomConnectionResponse.class);
    }

    public String disconnectFromWom(WomDisconnectionRequest disconnectionRequest) throws WomException {
        return this.womConnectionService.processDelete(this.getWoMDisonnectionUri(), JsonUtils.toJsonString((Object)disconnectionRequest));
    }

    public HubReport saveReport(HubReportVerifiableData reportRequest) throws WomException {
        String responseText = this.womConnectionService.processPost(this.getWoMReportUri(), JsonUtils.toJsonString((Object)reportRequest));
        return (HubReport)JsonUtils.fromJsonString((String)responseText, HubReport.class);
    }

    public HubReport retrieveReport(long reportId) throws WomException {
        String responseText = this.womConnectionService.processGet(this.getWoMReportUri(reportId));
        return (HubReport)JsonUtils.fromJsonString((String)responseText, HubReport.class);
    }

    public String saveHub(Hub hub, String hubSignedMessage, String token) throws WomException {
        return this.womConnectionService.processPut(this.getWoMUpdateHubUri(), JsonUtils.toJsonString((Object)new HubUpdateRequest(hub.getAddress(), hub.getName(), hub.getDescription(), hub.getUrl(), hub.getColor(), hubSignedMessage, token)));
    }

    public void saveHubAvatar(String hubAddress, String signedMessage, String token, InputStream inputStream) throws WomException {
        this.saveHubAttachment(this.getSaveAvatarUri(hubAddress), hubAddress, signedMessage, token, token, inputStream);
    }

    public void saveHubBanner(String hubAddress, String signedMessage, String rawMessage, String token, InputStream inputStream) throws WomException {
        this.saveHubAttachment(this.getSaveBannerUri(hubAddress), hubAddress, signedMessage, rawMessage, token, inputStream);
    }

    public String getWomUrl() {
        return WOM_URL;
    }

    private void saveHubAttachment(URI attachmentUri, String hubAddress, String signedMessage, String rawMessage, String token, InputStream inputStream) throws WomException {
        HttpPost httpPost = new HttpPost(attachmentUri);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addBinaryBody("file", inputStream, ContentType.MULTIPART_FORM_DATA, "file").addTextBody("hubAddress", hubAddress).addTextBody("signedMessage", signedMessage).addTextBody("rawMessage", rawMessage).addTextBody("token", token);
        httpPost.setEntity(entityBuilder.build());
        this.womConnectionService.processRequest((HttpUriRequestBase)httpPost);
    }

    private URI getSaveAvatarUri(String hubAddress) {
        String uri = WOM_URL + HUB_AVATAR_BY_ADDRESS_URI;
        return URI.create(this.fixUri(uri).replace(HUB_ADDRESS_PARAM, hubAddress));
    }

    private URI getSaveBannerUri(String hubAddress) {
        String uri = WOM_URL + HUB_BANNER_BY_ADDRESS_URI;
        return URI.create(this.fixUri(uri).replace(HUB_ADDRESS_PARAM, hubAddress));
    }

    private URI getWoMConnectionUri() {
        String uri = WOM_URL + "/hubs";
        return URI.create(this.fixUri(uri));
    }

    private URI getWoMUpdateHubUri() {
        String uri = WOM_URL + "/hubs";
        return URI.create(this.fixUri(uri));
    }

    private URI getWoMReportUri() {
        String uri = WOM_URL + "/hub/reports";
        return URI.create(this.fixUri(uri));
    }

    private URI getWoMReportUri(long reportId) {
        String uri = WOM_URL + WOM_REWARD_REPORT_BY_HASH_URI;
        return URI.create(this.fixUri(uri).replace(HASH_PARAM, String.valueOf(reportId)));
    }

    private URI getWoMDisonnectionUri() {
        String uri = WOM_URL + "/hubs";
        return URI.create(this.fixUri(uri));
    }

    private URI getIsHubManagerUri(String address, long nftId) {
        String uri = WOM_URL + HUB_MANAGER_CHEK_URI;
        return URI.create(this.fixUri(uri).replace(NFT_ID_PARAM, String.valueOf(nftId)).replace(MANAGER_ADDRESS_PARAM, address));
    }

    private URI getDeedHubTenantUri(String hubAddress, boolean forceRefresh) {
        String uri = WOM_URL + HUB_TENANT_BY_ADDRESS_URI;
        return URI.create(this.fixUri(uri).replace(HUB_ADDRESS_PARAM, String.valueOf(hubAddress)).replace(HUB_FORCE_REFRESH_PARAM, String.valueOf(forceRefresh)));
    }

    private URI getTokenGenerationUri() {
        String uri = WOM_URL + TOKEN_GENERATION_URI;
        return URI.create(this.fixUri(uri));
    }

    private String fixUri(String uri) {
        return uri.replace("//", "/").replace(":/", "://");
    }
}

