/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.tenant.metamask.web;

import io.meeds.tenant.hub.service.HubService;
import io.meeds.tenant.metamask.service.MetamaskLoginService;
import jakarta.servlet.http.HttpSession;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.web.login.UIParamsExtension;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseMetamaskExtension
implements UIParamsExtension {
    @Autowired
    protected MetamaskLoginService metamaskLoginService;
    @Autowired
    protected HubService hubService;

    protected void addDeedTenantParameters(HttpSession httpSession, Map<String, Object> params) {
        if (this.metamaskLoginService.isDeedHub()) {
            long deedId = this.metamaskLoginService.getDeedId();
            params.put("nftId", deedId);
            params.put("isDeedTenant", true);
            if (deedId > -1L) {
                params.put("cityIndex", this.hubService.getDeedCity());
                params.put("cardTypeIndex", this.hubService.getDeedType());
                String walletAddress = (String)httpSession.getAttribute("username");
                if (StringUtils.isNotBlank((CharSequence)walletAddress) && this.metamaskLoginService.isDeedManager(walletAddress)) {
                    params.put("isTenantManager", true);
                }
            }
        }
    }
}

