/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.websocket;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.subjects.BehaviorSubject;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.protocol.ObjectMapperFactory;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.BatchRequest;
import org.web3j.protocol.core.BatchResponse;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.response.EthSubscribe;
import org.web3j.protocol.core.methods.response.EthUnsubscribe;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketRequest;
import org.web3j.protocol.websocket.WebSocketRequests;
import org.web3j.protocol.websocket.WebSocketSubscription;
import org.web3j.protocol.websocket.events.Notification;

public class WebSocketService
implements Web3jService {
    private static final Logger log = LoggerFactory.getLogger(WebSocketService.class);
    static final long REQUEST_TIMEOUT = 60L;
    static final AtomicLong nextBatchId = new AtomicLong(0L);
    private final WebSocketClient webSocketClient;
    private boolean shouldReConnect;
    private final ScheduledExecutorService executor;
    private final ObjectMapper objectMapper;
    private Map<Long, WebSocketRequest<?>> requestForId = new ConcurrentHashMap();
    private Map<Long, WebSocketSubscription<?>> subscriptionRequestForId = new ConcurrentHashMap();
    private Map<String, WebSocketSubscription<?>> subscriptionForId = new ConcurrentHashMap();

    public WebSocketService(String serverUrl, boolean includeRawResponses) {
        this(new WebSocketClient(WebSocketService.parseURI(serverUrl)), includeRawResponses);
    }

    public WebSocketService(WebSocketClient webSocketClient, boolean includeRawResponses) {
        this(webSocketClient, Executors.newScheduledThreadPool(1), includeRawResponses);
    }

    WebSocketService(WebSocketClient webSocketClient, ScheduledExecutorService executor, boolean includeRawResponses) {
        this.webSocketClient = webSocketClient;
        this.executor = executor;
        this.objectMapper = ObjectMapperFactory.getObjectMapper(includeRawResponses);
    }

    public void connect() throws ConnectException {
        this.connect(s -> {}, t -> {}, () -> {});
    }

    public void connect(Consumer<String> onMessage, Consumer<Throwable> onError, Runnable onClose) throws ConnectException {
        try {
            this.connectToWebSocket();
            this.setWebSocketListener(onMessage, onError, onClose);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Interrupted while connecting via WebSocket protocol");
        }
    }

    private void connectToWebSocket() throws InterruptedException, ConnectException {
        boolean connected = this.shouldReConnect ? this.webSocketClient.reconnectBlocking() : this.webSocketClient.connectBlocking();
        this.shouldReConnect = true;
        if (!connected) {
            throw new ConnectException("Failed to connect to WebSocket");
        }
    }

    private void setWebSocketListener(final Consumer<String> onMessage, final Consumer<Throwable> onError, final Runnable onClose) {
        this.webSocketClient.setListener(new WebSocketListener(){

            @Override
            public void onMessage(String message) throws IOException {
                WebSocketService.this.onWebSocketMessage(message);
                onMessage.accept(message);
            }

            @Override
            public void onError(Exception e) {
                log.error("Received error from a WebSocket connection", (Throwable)e);
                onError.accept(e);
            }

            @Override
            public void onClose() {
                WebSocketService.this.onWebSocketClose();
                onClose.run();
            }
        });
    }

    @Override
    public <T extends Response> T send(Request request, Class<T> responseType) throws IOException {
        try {
            return (T)((Response)this.sendAsync(request, responseType).get());
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IOException("Interrupted WebSocket request", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException("Unexpected exception", e.getCause());
        }
    }

    @Override
    public <T extends Response> CompletableFuture<T> sendAsync(Request request, Class<T> responseType) {
        CompletableFuture result = new CompletableFuture();
        long requestId = request.getId();
        this.requestForId.put(requestId, new WebSocketRequest(result, responseType));
        try {
            this.sendRequest(request, requestId);
        }
        catch (IOException e) {
            this.closeRequest(requestId, e);
        }
        return result;
    }

    @Override
    public BatchResponse sendBatch(BatchRequest requests) throws IOException {
        try {
            return this.sendBatchAsync(requests).get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new IOException("Interrupted WebSocket batch requests", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new RuntimeException("Unexpected exception", e.getCause());
        }
    }

    @Override
    public CompletableFuture<BatchResponse> sendBatchAsync(BatchRequest requests) {
        CompletableFuture<BatchResponse> result = new CompletableFuture<BatchResponse>();
        long requestId = nextBatchId.getAndIncrement();
        Request<?, Response<?>> firstRequest = requests.getRequests().get(0);
        long originId = firstRequest.getId();
        requests.getRequests().get(0).setId(requestId);
        this.requestForId.put(requestId, new WebSocketRequests(result, requests.getRequests(), originId));
        try {
            this.sendBatchRequest(requests, requestId);
        }
        catch (IOException e) {
            this.closeRequest(requestId, e);
        }
        return result;
    }

    private void sendRequest(Request request, long requestId) throws JsonProcessingException {
        String payload = this.objectMapper.writeValueAsString((Object)request);
        log.debug("Sending request: {}", (Object)payload);
        this.webSocketClient.send(payload);
        this.setRequestTimeout(requestId);
    }

    private void sendBatchRequest(BatchRequest request, long requestId) throws JsonProcessingException {
        String payload = this.objectMapper.writeValueAsString(request.getRequests());
        log.debug("Sending batch request: {}", (Object)payload);
        this.webSocketClient.send(payload);
        this.setRequestTimeout(requestId);
    }

    private void setRequestTimeout(long requestId) {
        this.executor.schedule(() -> this.closeRequest(requestId, new IOException(String.format("Request with id %d timed out", requestId))), 60L, TimeUnit.SECONDS);
    }

    void closeRequest(long requestId, Exception e) {
        CompletableFuture<?> result = this.requestForId.get(requestId).getOnReply();
        this.requestForId.remove(requestId);
        result.completeExceptionally(e);
    }

    void onWebSocketMessage(String messageStr) throws IOException {
        JsonNode replyJson = this.parseToTree(messageStr);
        if (this.isReply(replyJson)) {
            this.processRequestReply(messageStr, replyJson);
        } else if (this.isBatchReply(replyJson)) {
            this.processBatchRequestReply(messageStr, (ArrayNode)replyJson);
        } else if (this.isSubscriptionEvent(replyJson)) {
            this.processSubscriptionEvent(messageStr, replyJson);
        } else {
            throw new IOException("Unknown message type");
        }
    }

    private void processRequestReply(String replyStr, JsonNode replyJson) throws IOException {
        long replyId = this.getReplyId(replyJson);
        WebSocketRequest request = this.getAndRemoveRequest(replyId);
        try {
            Object reply = this.objectMapper.convertValue((Object)replyJson, request.getResponseType());
            if (reply instanceof EthSubscribe) {
                this.processSubscriptionResponse(replyId, (EthSubscribe)reply);
            }
            this.sendReplyToListener(request, reply);
        }
        catch (IllegalArgumentException e) {
            this.sendExceptionToListener(replyStr, request, e);
        }
    }

    private void processBatchRequestReply(String replyStr, ArrayNode replyJson) throws IOException {
        long replyId = this.getReplyId(replyJson.get(0));
        WebSocketRequests webSocketRequests = (WebSocketRequests)this.getAndRemoveRequest(replyId);
        try {
            ((ObjectNode)replyJson.get(0)).put("id", webSocketRequests.getOriginId());
            List<Request<?, Response<?>>> requests = webSocketRequests.getRequests();
            ArrayList<Response> responses = new ArrayList<Response>(replyJson.size());
            for (int i = 0; i < replyJson.size(); ++i) {
                Response response = (Response)this.objectMapper.treeToValue((TreeNode)replyJson.get(i), requests.get(i).getResponseType());
                responses.add(response);
            }
            this.sendReplyToListener(webSocketRequests, new BatchResponse(requests, responses));
        }
        catch (IllegalArgumentException e) {
            this.sendExceptionToListener(replyStr, webSocketRequests, e);
        }
    }

    private void processSubscriptionResponse(long replyId, EthSubscribe reply) throws IOException {
        WebSocketSubscription<?> subscription = this.subscriptionRequestForId.get(replyId);
        this.processSubscriptionResponse(reply, subscription.getSubject(), subscription.getResponseType());
    }

    private <T extends Notification<?>> void processSubscriptionResponse(EthSubscribe subscriptionReply, BehaviorSubject<T> subject, Class<T> responseType) {
        if (!subscriptionReply.hasError()) {
            this.establishSubscription(subject, responseType, subscriptionReply);
        } else {
            this.reportSubscriptionError(subject, subscriptionReply);
        }
    }

    private <T extends Notification<?>> void establishSubscription(BehaviorSubject<T> subject, Class<T> responseType, EthSubscribe subscriptionReply) {
        log.debug("Subscribed to RPC events with id {}", (Object)subscriptionReply.getSubscriptionId());
        this.subscriptionForId.put(subscriptionReply.getSubscriptionId(), new WebSocketSubscription<T>(subject, responseType));
    }

    private <T extends Notification<?>> String getSubscriptionId(BehaviorSubject<T> subject) {
        return this.subscriptionForId.entrySet().stream().filter(entry -> ((WebSocketSubscription)entry.getValue()).getSubject() == subject).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    private <T extends Notification<?>> void reportSubscriptionError(BehaviorSubject<T> subject, EthSubscribe subscriptionReply) {
        Response.Error error = subscriptionReply.getError();
        log.error("Subscription request returned error: {}", (Object)error.getMessage());
        subject.onError((Throwable)new IOException(String.format("Subscription request failed with error: %s", error.getMessage())));
    }

    private void sendReplyToListener(WebSocketRequest request, Object reply) {
        request.getOnReply().complete(reply);
    }

    private void sendExceptionToListener(String replyStr, WebSocketRequest request, IllegalArgumentException e) {
        request.getOnReply().completeExceptionally(new IOException(String.format("Failed to parse '%s' as type %s", replyStr, request.getResponseType()), e));
    }

    private void processSubscriptionEvent(String replyStr, JsonNode replyJson) {
        log.debug("Processing event: {}", (Object)replyStr);
        String subscriptionId = this.extractSubscriptionId(replyJson);
        WebSocketSubscription<?> subscription = this.subscriptionForId.get(subscriptionId);
        if (subscription != null) {
            this.sendEventToSubscriber(replyJson, subscription);
        } else {
            log.warn("No subscriber for WebSocket event with subscription id {}", (Object)subscriptionId);
        }
    }

    private String extractSubscriptionId(JsonNode replyJson) {
        return replyJson.get("params").get("subscription").asText();
    }

    private void sendEventToSubscriber(JsonNode replyJson, WebSocketSubscription subscription) {
        Object event = this.objectMapper.convertValue((Object)replyJson, subscription.getResponseType());
        subscription.getSubject().onNext(event);
    }

    private boolean isReply(JsonNode replyJson) {
        return replyJson.has("id");
    }

    private boolean isBatchReply(JsonNode replyJson) {
        return replyJson.isArray();
    }

    private boolean isSubscriptionEvent(JsonNode replyJson) {
        return replyJson.has("method");
    }

    private JsonNode parseToTree(String replyStr) throws IOException {
        try {
            return this.objectMapper.readTree(replyStr);
        }
        catch (IOException e) {
            throw new IOException("Failed to parse incoming WebSocket message", e);
        }
    }

    private WebSocketRequest getAndRemoveRequest(long id) throws IOException {
        if (!this.requestForId.containsKey(id)) {
            throw new IOException(String.format("Received reply for unexpected request id: %d", id));
        }
        WebSocketRequest<?> request = this.requestForId.get(id);
        this.requestForId.remove(id);
        return request;
    }

    private long getReplyId(JsonNode replyJson) throws IOException {
        JsonNode idField = replyJson.get("id");
        if (idField == null) {
            throw new IOException("'id' field is missing in the reply");
        }
        if (!idField.isIntegralNumber()) {
            if (idField.isTextual()) {
                try {
                    return Long.parseLong(idField.asText());
                }
                catch (NumberFormatException e) {
                    throw new IOException(String.format("Found Textual 'id' that cannot be casted to long. Input : '%s'", idField.asText()));
                }
            }
            throw new IOException(String.format("'id' expected to be long, but it is: '%s'", idField.asText()));
        }
        return idField.longValue();
    }

    private static URI parseURI(String serverUrl) {
        try {
            return new URI(serverUrl);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(String.format("Failed to parse URL: '%s'", serverUrl), e);
        }
    }

    @Override
    public <T extends Notification<?>> Flowable<T> subscribe(Request request, String unsubscribeMethod, Class<T> responseType) {
        BehaviorSubject subject = BehaviorSubject.create();
        this.subscribeToEventsStream(request, subject, responseType);
        return subject.doOnDispose(() -> this.closeSubscription(subject, unsubscribeMethod)).toFlowable(BackpressureStrategy.BUFFER);
    }

    private <T extends Notification<?>> void subscribeToEventsStream(Request request, BehaviorSubject<T> subject, Class<T> responseType) {
        this.subscriptionRequestForId.put(request.getId(), new WebSocketSubscription<T>(subject, responseType));
        try {
            this.send(request, EthSubscribe.class);
        }
        catch (IOException e) {
            log.error("Failed to subscribe to RPC events with request id {}", (Object)request.getId());
            subject.onError((Throwable)e);
        }
    }

    private <T extends Notification<?>> void closeSubscription(BehaviorSubject<T> subject, String unsubscribeMethod) {
        String subscriptionId = this.getSubscriptionId(subject);
        if (subscriptionId != null) {
            this.subscriptionForId.remove(subscriptionId);
            this.unsubscribeFromEventsStream(subscriptionId, unsubscribeMethod);
        } else {
            log.warn("Trying to unsubscribe from a non-existing subscription. Race condition?");
        }
    }

    private void unsubscribeFromEventsStream(String subscriptionId, String unsubscribeMethod) {
        ((CompletableFuture)this.sendAsync(this.unsubscribeRequest(subscriptionId, unsubscribeMethod), EthUnsubscribe.class).thenAccept(ethUnsubscribe -> log.debug("Successfully unsubscribed from subscription with id {}", (Object)subscriptionId))).exceptionally(throwable -> {
            log.error("Failed to unsubscribe from subscription with id {}", (Object)subscriptionId);
            return null;
        });
    }

    private Request<String, EthUnsubscribe> unsubscribeRequest(String subscriptionId, String unsubscribeMethod) {
        return new Request<String, EthUnsubscribe>(unsubscribeMethod, Collections.singletonList(subscriptionId), this, EthUnsubscribe.class);
    }

    @Override
    public void close() {
        this.webSocketClient.close();
        this.executor.shutdown();
    }

    void onWebSocketClose() {
        this.closeOutstandingRequests();
        this.closeOutstandingSubscriptions();
    }

    private void closeOutstandingRequests() {
        this.requestForId.values().forEach(request -> request.getOnReply().completeExceptionally(new IOException("Connection was closed")));
    }

    private void closeOutstandingSubscriptions() {
        this.subscriptionForId.values().forEach(subscription -> subscription.getSubject().onError((Throwable)new IOException("Connection was closed")));
    }

    boolean isWaitingForReply(long requestId) {
        return this.requestForId.containsKey(requestId);
    }
}

