/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.ext;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.locks.Lock;

public class BatchArrayQueue<T>
implements Queue<T> {
    private final Lock lock;
    private T[] elements;
    private int head;
    private int tail;
    private long[] batches;
    private long batch;

    public BatchArrayQueue(int initial, Lock lock) {
        this.lock = lock;
        Object[] array = new Object[initial];
        this.elements = array;
        this.batches = new long[initial];
        this.batch = 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(T t) {
        this.lock.lock();
        try {
            this.elements[this.tail] = Objects.requireNonNull(t);
            this.batches[this.tail] = this.batch;
            ++this.tail;
            if (this.tail == this.elements.length) {
                this.tail = 0;
            }
            if (this.tail == this.head) {
                int capacity = this.elements.length;
                int newCapacity = 2 * capacity;
                if (newCapacity < 0) {
                    throw new IllegalStateException("Could not double up capacity " + capacity);
                }
                Object[] newElements = new Object[newCapacity];
                long[] newBatches = new long[newCapacity];
                int length = capacity - this.head;
                if (length > 0) {
                    System.arraycopy(this.elements, this.head, newElements, 0, length);
                    System.arraycopy(this.batches, this.head, newBatches, 0, length);
                }
                if (this.head > 0) {
                    System.arraycopy(this.elements, 0, newElements, length, this.tail);
                    System.arraycopy(this.batches, 0, newBatches, length, this.tail);
                }
                this.elements = newElements;
                this.batches = newBatches;
                this.head = 0;
                this.tail = capacity;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    @Override
    public boolean add(T t) {
        return this.offer(t);
    }

    @Override
    public T peek() {
        this.lock.lock();
        try {
            T t = this.elements[this.head];
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T element() {
        T element = this.peek();
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public T poll() {
        this.lock.lock();
        try {
            if (this.isEmpty()) {
                T t = null;
                return t;
            }
            T result = this.elements[this.head];
            this.elements[this.head] = null;
            this.batches[this.head] = 0L;
            ++this.head;
            if (this.head == this.elements.length) {
                this.head = 0;
            }
            T t = result;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public T remove() {
        T result = this.poll();
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> items) {
        this.lock.lock();
        try {
            boolean result = false;
            for (T item : items) {
                result |= this.offer(item);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> items) {
        this.lock.lock();
        try {
            for (Object item : items) {
                if (this.contains(item)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        this.lock.lock();
        try {
            if (this.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            int cursor = this.head;
            do {
                if (o.equals(this.elements[cursor])) {
                    boolean bl = true;
                    return bl;
                }
                if (++cursor != this.elements.length) continue;
                cursor = 0;
            } while (cursor != this.tail);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        final Object[] objects = this.toArray();
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < objects.length;
            }

            @Override
            public T next() {
                return objects[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.head == this.tail;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        this.lock.lock();
        try {
            if (this.head <= this.tail) {
                int n = this.tail - this.head;
                return n;
            }
            int n = this.elements.length - this.head + this.tail;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Object[] toArray() {
        return this.toArray((E[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> E[] toArray(E[] a) {
        this.lock.lock();
        try {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            if (this.head <= this.tail) {
                System.arraycopy(this.elements, this.head, a, 0, size);
            } else {
                int l = this.elements.length - this.head;
                System.arraycopy(this.elements, this.head, a, 0, l);
                System.arraycopy(this.elements, 0, a, l, this.tail);
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            Arrays.fill(this.elements, null);
            Arrays.fill(this.batches, 0L);
            this.tail = 0;
            this.head = 0;
            this.batch = 1L;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getBatch() {
        this.lock.lock();
        try {
            long l = this.batch;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void nextBatch() {
        this.lock.lock();
        try {
            ++this.batch;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearToBatch(long batch) {
        this.lock.lock();
        try {
            do {
                if (this.batches[this.head] <= batch) continue;
                break;
            } while (this.poll() != null);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportMessagesToBatch(Queue<T> target, long batch) {
        this.lock.lock();
        try {
            int cursor = this.head;
            while (cursor != this.tail) {
                if (this.batches[cursor] > batch) {
                    break;
                }
                target.offer(this.elements[cursor]);
                if (++cursor != this.batches.length) continue;
                cursor = 0;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long batchOf(int index) {
        this.lock.lock();
        try {
            int cursor = this.head + index;
            int capacity = this.elements.length;
            if (cursor > capacity) {
                cursor -= capacity;
            }
            long l = this.batches[cursor];
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }
}

