/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.Namespaces;
import org.exoplatform.container.configuration.NoKernelNamespaceSAXFilter;
import org.exoplatform.container.configuration.ProfileDOMFilter;
import org.exoplatform.container.util.Utils;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigurationUnmarshaller {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ConfigurationUnmarshaller");
    private static final String[] KERNEL_NAMESPACES = Namespaces.getKernelNamespaces();
    private final Set<String> profiles;

    public ConfigurationUnmarshaller(Set<String> profiles) {
        this.profiles = profiles;
    }

    public ConfigurationUnmarshaller() {
        this.profiles = Collections.emptySet();
    }

    public boolean isValid(URL url) throws NullPointerException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", KERNEL_NAMESPACES);
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Reporter reporter = new Reporter(this, url);
            builder.setErrorHandler(reporter);
            builder.setEntityResolver(Namespaces.resolver);
            String content = Deserializer.resolveVariables(Utils.readStream(url.openStream()));
            InputSource is = new InputSource(new StringReader(content));
            builder.parse(is);
            return reporter.valid;
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Got a parser configuration exception when doing XSD validation");
            return false;
        }
        catch (SAXException e) {
            LOG.error((Object)"Got a sax exception when doing XSD validation");
            return false;
        }
    }

    public Configuration unmarshall(URL url) throws Exception {
        Document doc;
        DocumentBuilderFactory factory;
        block9: {
            boolean valid;
            if (PropertyManager.isDevelopping() && !(valid = this.isValid(url))) {
                LOG.info((Object)("The configuration file " + String.valueOf(url) + " was not found valid according to its XSD"));
            }
            factory = null;
            try {
                Method dbfniMethod = DocumentBuilderFactory.class.getMethod("newInstance", String.class, ClassLoader.class);
                factory = (DocumentBuilderFactory)dbfniMethod.invoke(null, "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", Thread.currentThread().getContextClassLoader());
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof FactoryConfigurationError) {
                    LOG.debug((Object)"Was not able to find document builder factory class in Java > 5, will use default", cause);
                }
                throw e;
            }
            catch (NoSuchMethodException e) {
                if (!LOG.isTraceEnabled()) break block9;
                LOG.trace((Object)("An exception occurred: " + e.getMessage()));
            }
        }
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
        }
        factory.setNamespaceAware(true);
        DocumentBuilderFactory builderFactory = factory;
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        try {
            doc = builder.parse(url.openStream());
        }
        catch (IOException | SAXException e) {
            LOG.warn("Error Parsing file {}", new Object[]{url, e});
            throw e;
        }
        ProfileDOMFilter filter = new ProfileDOMFilter(this.profiles);
        filter.process(doc.getDocumentElement());
        StringWriter buffer = new StringWriter();
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler hd = tf.newTransformerHandler();
        StreamResult result = new StreamResult(buffer);
        hd.setResult(result);
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "UTF8");
        serializer.setOutputProperty("indent", "yes");
        SAXResult saxResult = new SAXResult(new NoKernelNamespaceSAXFilter(hd));
        serializer.transform(new DOMSource(doc), saxResult);
        String document = buffer.toString();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("About to parse configuration file " + document));
        }
        IBindingFactory bfact = BindingDirectory.getFactory(Configuration.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return (Configuration)uctx.unmarshalDocument((Reader)new StringReader(document), null);
    }

    private class Reporter
    implements ErrorHandler {
        private final URL url;
        private boolean valid;

        private Reporter(ConfigurationUnmarshaller configurationUnmarshaller, URL url) {
            this.url = url;
            this.valid = true;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOG.warn((Object)exception.getMessage(), (Throwable)exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            if (exception.getMessage().equals("cvc-elt.1: Cannot find the declaration of element 'configuration'.")) {
                LOG.info((Object)("The document " + String.valueOf(this.url) + " does not contain a schema declaration, it should have an XML declaration similar to\n<configuration\n   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n   xsi:schemaLocation=\"http://www.exoplatform.org/xml/ns/kernel_1_1.xsd http://www.exoplatform.org/xml/ns/kernel_1_1.xsd\"\n   xmlns=\"http://www.exoplatform.org/xml/ns/kernel_1_1.xsd\">"));
            } else {
                LOG.error((Object)("In document " + String.valueOf(this.url) + "  at (" + exception.getLineNumber() + "," + exception.getColumnNumber() + ") :" + exception.getMessage()));
            }
            this.valid = false;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOG.fatal((Object)("In document " + String.valueOf(this.url) + "  at (" + exception.getLineNumber() + "," + exception.getColumnNumber() + ") :" + exception.getMessage()));
            this.valid = false;
        }
    }
}

