/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.reflection.java.generics;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Type[] substTypeArgs;
    private final Type rawType;
    private final Type ownerType;

    public ParameterizedTypeImpl(Type rawType, Type[] substTypeArgs, Type ownerType) {
        this.substTypeArgs = substTypeArgs;
        this.rawType = rawType;
        this.ownerType = ownerType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.substTypeArgs;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)obj;
        return Objects.equals(this.getOwnerType(), other.getOwnerType()) && Objects.equals(this.getRawType(), other.getRawType()) && Arrays.equals(this.getActualTypeArguments(), other.getActualTypeArguments());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getActualTypeArguments()) ^ Objects.hashCode(this.getOwnerType()) ^ Objects.hashCode(this.getRawType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.ownerType != null) {
            sb.append(this.ownerType.getTypeName());
            sb.append("$");
            if (this.ownerType instanceof ParameterizedType) {
                sb.append(this.rawType.getTypeName().replace(((ParameterizedType)this.ownerType).getRawType().getTypeName() + "$", ""));
            } else if (this.rawType instanceof Class) {
                sb.append(((Class)this.rawType).getSimpleName());
            } else {
                sb.append(this.rawType.getTypeName());
            }
        } else {
            sb.append(this.rawType.getTypeName());
        }
        if (this.substTypeArgs != null) {
            StringJoiner sj = new StringJoiner(", ", "<", ">");
            sj.setEmptyValue("");
            for (Type t : this.substTypeArgs) {
                sj.add(t.getTypeName());
            }
            sb.append(sj);
        }
        return sb.toString();
    }
}

