/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io.buffer;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Iterator;
import java.util.function.IntPredicate;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferInputStream;
import org.springframework.core.io.buffer.DataBufferOutputStream;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.util.Assert;

public interface DataBuffer {
    public DataBufferFactory factory();

    public int indexOf(IntPredicate var1, int var2);

    public int lastIndexOf(IntPredicate var1, int var2);

    public int readableByteCount();

    public int writableByteCount();

    public int capacity();

    @Deprecated(since="6.0")
    public DataBuffer capacity(int var1);

    @Deprecated(since="6.0")
    default public DataBuffer ensureCapacity(int capacity) {
        return this.ensureWritable(capacity);
    }

    public DataBuffer ensureWritable(int var1);

    public int readPosition();

    public DataBuffer readPosition(int var1);

    public int writePosition();

    public DataBuffer writePosition(int var1);

    public byte getByte(int var1);

    default public int forEachByte(int index, int length, ByteProcessor processor) {
        Assert.isTrue(length >= 0, "Length must be >= 0");
        for (int position = index; position < index + length; ++position) {
            byte b = this.getByte(position);
            if (processor.process(b)) continue;
            return position;
        }
        return -1;
    }

    public byte read();

    public DataBuffer read(byte[] var1);

    public DataBuffer read(byte[] var1, int var2, int var3);

    public DataBuffer write(byte var1);

    public DataBuffer write(byte[] var1);

    public DataBuffer write(byte[] var1, int var2, int var3);

    public DataBuffer write(DataBuffer ... var1);

    public DataBuffer write(ByteBuffer ... var1);

    default public DataBuffer write(CharSequence charSequence, Charset charset) {
        Assert.notNull((Object)charSequence, "CharSequence must not be null");
        Assert.notNull((Object)charset, "Charset must not be null");
        if (!charSequence.isEmpty()) {
            CharsetEncoder encoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            CharBuffer src = CharBuffer.wrap(charSequence);
            int averageSize = (int)Math.ceil((float)src.remaining() * encoder.averageBytesPerChar());
            this.ensureWritable(averageSize);
            while (true) {
                CoderResult cr;
                if (src.hasRemaining()) {
                    try (ByteBufferIterator iterator = this.writableByteBuffers();){
                        Assert.state(iterator.hasNext(), "No ByteBuffer available");
                        ByteBuffer dest = (ByteBuffer)iterator.next();
                        cr = encoder.encode(src, dest, true);
                        if (cr.isUnderflow()) {
                            cr = encoder.flush(dest);
                        }
                        this.writePosition(this.writePosition() + dest.position());
                    }
                } else {
                    cr = CoderResult.UNDERFLOW;
                }
                if (cr.isUnderflow()) break;
                if (!cr.isOverflow()) continue;
                int maxSize = (int)Math.ceil((float)src.remaining() * encoder.maxBytesPerChar());
                this.ensureWritable(maxSize);
            }
        }
        return this;
    }

    @Deprecated(since="6.0")
    public DataBuffer slice(int var1, int var2);

    @Deprecated(since="6.0")
    default public DataBuffer retainedSlice(int index, int length) {
        return DataBufferUtils.retain(this.slice(index, length));
    }

    public DataBuffer split(int var1);

    @Deprecated(since="6.0")
    public ByteBuffer asByteBuffer();

    @Deprecated(since="6.0")
    public ByteBuffer asByteBuffer(int var1, int var2);

    @Deprecated(since="6.0.5")
    default public ByteBuffer toByteBuffer() {
        return this.toByteBuffer(this.readPosition(), this.readableByteCount());
    }

    @Deprecated(since="6.0.5")
    public ByteBuffer toByteBuffer(int var1, int var2);

    default public void toByteBuffer(ByteBuffer dest) {
        this.toByteBuffer(this.readPosition(), dest, dest.position(), this.readableByteCount());
    }

    public void toByteBuffer(int var1, ByteBuffer var2, int var3, int var4);

    public ByteBufferIterator readableByteBuffers();

    public ByteBufferIterator writableByteBuffers();

    default public InputStream asInputStream() {
        return new DataBufferInputStream(this, false);
    }

    default public InputStream asInputStream(boolean releaseOnClose) {
        return new DataBufferInputStream(this, releaseOnClose);
    }

    default public OutputStream asOutputStream() {
        return new DataBufferOutputStream(this);
    }

    default public String toString(Charset charset) {
        Assert.notNull((Object)charset, "Charset must not be null");
        return this.toString(this.readPosition(), this.readableByteCount(), charset);
    }

    public String toString(int var1, int var2, Charset var3);

    @FunctionalInterface
    public static interface ByteProcessor {
        public boolean process(byte var1);
    }

    public static interface ByteBufferIterator
    extends Iterator<ByteBuffer>,
    Closeable {
        @Override
        public void close();
    }
}

