/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.util.TypeInformation;

public class ElasticsearchParameters
extends Parameters<ElasticsearchParameters, ElasticsearchParameter> {
    private final List<ElasticsearchParameter> scriptedFields = new ArrayList<ElasticsearchParameter>();
    private final List<ElasticsearchParameter> runtimeFields = new ArrayList<ElasticsearchParameter>();

    public ElasticsearchParameters(ParametersSource parametersSource) {
        super(parametersSource, parameter -> new ElasticsearchParameter((MethodParameter)parameter, (TypeInformation<?>)parametersSource.getDomainTypeInformation()));
        TypeInformation domainType = parametersSource.getDomainTypeInformation();
        Method method = parametersSource.getMethod();
        int parameterCount = method.getParameterCount();
        for (int i = 0; i < parameterCount; ++i) {
            MethodParameter methodParameter = new MethodParameter(method, i);
            ElasticsearchParameter parameter2 = this.parameterFactory(methodParameter, domainType);
            if (parameter2.isScriptedFieldParameter().booleanValue()) {
                this.scriptedFields.add(parameter2);
            }
            if (!parameter2.isRuntimeFieldParameter().booleanValue()) continue;
            this.runtimeFields.add(parameter2);
        }
    }

    private ElasticsearchParameter parameterFactory(MethodParameter methodParameter, TypeInformation<?> domainType) {
        return new ElasticsearchParameter(methodParameter, domainType);
    }

    private ElasticsearchParameters(List<ElasticsearchParameter> parameters) {
        super(parameters);
    }

    protected ElasticsearchParameters createFrom(List<ElasticsearchParameter> parameters) {
        return new ElasticsearchParameters(parameters);
    }

    List<ElasticsearchParameter> getScriptedFields() {
        return this.scriptedFields;
    }

    List<ElasticsearchParameter> getRuntimeFields() {
        return this.runtimeFields;
    }
}

