/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.server.ui;

import java.nio.charset.Charset;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.web.server.csrf.CsrfToken;
import org.springframework.security.web.server.ui.HtmlTemplates;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatchers;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class LogoutPageGeneratingWebFilter
implements WebFilter {
    private ServerWebExchangeMatcher matcher = ServerWebExchangeMatchers.pathMatchers(HttpMethod.GET, "/logout");
    private static final String LOGOUT_PAGE_TEMPLATE = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"\">\n    <title>Confirm Log Out?</title>\n    <link href=\"{{contextPath}}/default-ui.css\" rel=\"stylesheet\" />\n  </head>\n  <body>\n    <div class=\"content\">\n      <form class=\"logout-form\" method=\"post\" action=\"{{contextPath}}/logout\">\n        <h2>Are you sure you want to log out?</h2>\n{{csrf}}\n        <button class=\"primary\" type=\"submit\">Log Out</button>\n      </form>\n    </div>\n  </body>\n</html>";
    private static final String CSRF_INPUT_TEMPLATE = "<input name=\"{{name}}\" type=\"hidden\" value=\"{{value}}\" />\n";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        return this.matcher.matches(exchange).filter(ServerWebExchangeMatcher.MatchResult::isMatch).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).flatMap(matchResult -> this.render(exchange));
    }

    private Mono<Void> render(ServerWebExchange exchange) {
        ServerHttpResponse result = exchange.getResponse();
        result.setStatusCode((HttpStatusCode)HttpStatus.OK);
        result.getHeaders().setContentType(MediaType.TEXT_HTML);
        return result.writeWith(this.createBuffer(exchange));
    }

    private Mono<DataBuffer> createBuffer(ServerWebExchange exchange) {
        Mono token = (Mono)exchange.getAttributeOrDefault(CsrfToken.class.getName(), (Object)Mono.empty());
        String contextPath = exchange.getRequest().getPath().contextPath().value();
        return token.map(LogoutPageGeneratingWebFilter::csrfToken).defaultIfEmpty((Object)"").map(csrfTokenHtmlInput -> {
            byte[] bytes = LogoutPageGeneratingWebFilter.createPage(csrfTokenHtmlInput, contextPath);
            DataBufferFactory bufferFactory = exchange.getResponse().bufferFactory();
            return bufferFactory.wrap(bytes);
        });
    }

    private static byte[] createPage(String csrfTokenHtmlInput, String contextPath) {
        return HtmlTemplates.fromTemplate(LOGOUT_PAGE_TEMPLATE).withValue("contextPath", contextPath).withRawHtml("csrf", csrfTokenHtmlInput.indent(8)).render().getBytes(Charset.defaultCharset());
    }

    private static String csrfToken(CsrfToken token) {
        return HtmlTemplates.fromTemplate(CSRF_INPUT_TEMPLATE).withValue("name", token.getParameterName()).withValue("value", token.getToken()).render();
    }
}

