/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.wallet.model;

import io.meeds.wallet.model.RewardPeriod;
import io.meeds.wallet.model.TransactionDetail;
import io.meeds.wallet.model.Wallet;
import java.io.Serializable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class WalletReward
implements Serializable {
    private static final long serialVersionUID = -4328398843364453949L;
    private long id;
    private Wallet wallet;
    private TransactionDetail transaction;
    private long identityId;
    private double points;
    private double amount;
    private RewardPeriod period;
    private int rank;

    public long getIdentityId() {
        return this.wallet == null ? 0L : this.wallet.getTechnicalId();
    }

    public boolean isEnabled() {
        if (this.wallet == null) {
            throw new IllegalStateException("wallet isn't loaded");
        }
        return this.wallet.isEnabled() && !this.wallet.isDeletedUser() && !this.wallet.isDisabledUser() && StringUtils.isNotBlank((CharSequence)this.wallet.getAddress());
    }

    public String getStatus() {
        if (this.transaction == null) {
            return null;
        }
        if (this.transaction.isPending()) {
            return "pending";
        }
        if (this.transaction.isSucceeded()) {
            return "success";
        }
        return "error";
    }

    public double getTokensSent() {
        if (this.transaction == null) {
            return 0.0;
        }
        return this.transaction.getContractAmount();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public Wallet getWallet() {
        return this.wallet;
    }

    @Generated
    public TransactionDetail getTransaction() {
        return this.transaction;
    }

    @Generated
    public double getPoints() {
        return this.points;
    }

    @Generated
    public double getAmount() {
        return this.amount;
    }

    @Generated
    public RewardPeriod getPeriod() {
        return this.period;
    }

    @Generated
    public int getRank() {
        return this.rank;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setWallet(Wallet wallet) {
        this.wallet = wallet;
    }

    @Generated
    public void setTransaction(TransactionDetail transaction) {
        this.transaction = transaction;
    }

    @Generated
    public void setIdentityId(long identityId) {
        this.identityId = identityId;
    }

    @Generated
    public void setPoints(double points) {
        this.points = points;
    }

    @Generated
    public void setAmount(double amount) {
        this.amount = amount;
    }

    @Generated
    public void setPeriod(RewardPeriod period) {
        this.period = period;
    }

    @Generated
    public void setRank(int rank) {
        this.rank = rank;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletReward)) {
            return false;
        }
        WalletReward other = (WalletReward)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getIdentityId() != other.getIdentityId()) {
            return false;
        }
        Wallet this$wallet = this.getWallet();
        Wallet other$wallet = other.getWallet();
        return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WalletReward;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $identityId = this.getIdentityId();
        result = result * 59 + (int)($identityId >>> 32 ^ $identityId);
        Wallet $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WalletReward(id=" + this.getId() + ", wallet=" + String.valueOf(this.getWallet()) + ", transaction=" + String.valueOf(this.getTransaction()) + ", identityId=" + this.getIdentityId() + ", points=" + this.getPoints() + ", amount=" + this.getAmount() + ", period=" + String.valueOf(this.getPeriod()) + ", rank=" + this.getRank() + ")";
    }

    @Generated
    public WalletReward(long id, Wallet wallet, TransactionDetail transaction, long identityId, double points, double amount, RewardPeriod period, int rank) {
        this.id = id;
        this.wallet = wallet;
        this.transaction = transaction;
        this.identityId = identityId;
        this.points = points;
        this.amount = amount;
        this.period = period;
        this.rank = rank;
    }

    @Generated
    public WalletReward() {
    }
}

