/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.hierarchicalroles;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.hierarchicalroles.CycleInRoleHierarchyException;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.Assert;

public class RoleHierarchyImpl
implements RoleHierarchy {
    private static final Log logger = LogFactory.getLog(RoleHierarchyImpl.class);
    private Map<String, Set<GrantedAuthority>> rolesReachableInOneOrMoreStepsMap = null;

    @Deprecated
    public RoleHierarchyImpl() {
    }

    private RoleHierarchyImpl(Map<String, Set<GrantedAuthority>> hierarchy) {
        this.rolesReachableInOneOrMoreStepsMap = RoleHierarchyImpl.buildRolesReachableInOneOrMoreStepsMap(hierarchy);
    }

    public static RoleHierarchyImpl fromHierarchy(String hierarchy) {
        return new RoleHierarchyImpl(RoleHierarchyImpl.buildRolesReachableInOneStepMap(hierarchy));
    }

    public static Builder withDefaultRolePrefix() {
        return RoleHierarchyImpl.withRolePrefix("ROLE_");
    }

    public static Builder withRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix must not be null");
        return new Builder(rolePrefix);
    }

    @Deprecated
    public void setHierarchy(String roleHierarchyStringRepresentation) {
        logger.debug((Object)LogMessage.format((String)"setHierarchy() - The following role hierarchy was set: %s", (Object)roleHierarchyStringRepresentation));
        Map<String, Set<GrantedAuthority>> hierarchy = RoleHierarchyImpl.buildRolesReachableInOneStepMap(roleHierarchyStringRepresentation);
        this.rolesReachableInOneOrMoreStepsMap = RoleHierarchyImpl.buildRolesReachableInOneOrMoreStepsMap(hierarchy);
    }

    public Collection<GrantedAuthority> getReachableGrantedAuthorities(Collection<? extends GrantedAuthority> authorities) {
        if (authorities == null || authorities.isEmpty()) {
            return AuthorityUtils.NO_AUTHORITIES;
        }
        HashSet<GrantedAuthority> reachableRoles = new HashSet<GrantedAuthority>();
        HashSet<String> processedNames = new HashSet<String>();
        for (GrantedAuthority grantedAuthority : authorities) {
            if (grantedAuthority.getAuthority() == null) {
                reachableRoles.add(grantedAuthority);
                continue;
            }
            if (!processedNames.add(grantedAuthority.getAuthority())) continue;
            reachableRoles.add(grantedAuthority);
            Set<GrantedAuthority> lowerRoles = this.rolesReachableInOneOrMoreStepsMap.get(grantedAuthority.getAuthority());
            if (lowerRoles == null) continue;
            for (GrantedAuthority role : lowerRoles) {
                if (!processedNames.add(role.getAuthority())) continue;
                reachableRoles.add(role);
            }
        }
        logger.debug((Object)LogMessage.format((String)"getReachableGrantedAuthorities() - From the roles %s one can reach %s in zero or more steps.", authorities, reachableRoles));
        return new ArrayList<GrantedAuthority>(reachableRoles);
    }

    private static Map<String, Set<GrantedAuthority>> buildRolesReachableInOneStepMap(String hierarchy) {
        HashMap<String, Set<GrantedAuthority>> rolesReachableInOneStepMap = new HashMap<String, Set<GrantedAuthority>>();
        for (String line : hierarchy.split("\n")) {
            String[] roles = line.trim().split("\\s+>\\s+");
            for (int i = 1; i < roles.length; ++i) {
                Set<SimpleGrantedAuthority> rolesReachableInOneStepSet;
                String higherRole = roles[i - 1];
                SimpleGrantedAuthority lowerRole = new SimpleGrantedAuthority(roles[i]);
                if (!rolesReachableInOneStepMap.containsKey(higherRole)) {
                    rolesReachableInOneStepSet = new HashSet();
                    rolesReachableInOneStepMap.put(higherRole, rolesReachableInOneStepSet);
                } else {
                    rolesReachableInOneStepSet = (Set)rolesReachableInOneStepMap.get(higherRole);
                }
                rolesReachableInOneStepSet.add(lowerRole);
                logger.debug((Object)LogMessage.format((String)"buildRolesReachableInOneStepMap() - From role %s one can reach role %s in one step.", (Object)higherRole, (Object)lowerRole));
            }
        }
        return rolesReachableInOneStepMap;
    }

    private static Map<String, Set<GrantedAuthority>> buildRolesReachableInOneOrMoreStepsMap(Map<String, Set<GrantedAuthority>> hierarchy) {
        HashMap<String, Set<GrantedAuthority>> rolesReachableInOneOrMoreStepsMap = new HashMap<String, Set<GrantedAuthority>>();
        for (String roleName : hierarchy.keySet()) {
            HashSet rolesToVisitSet = new HashSet(hierarchy.get(roleName));
            HashSet<GrantedAuthority> visitedRolesSet = new HashSet<GrantedAuthority>();
            while (!rolesToVisitSet.isEmpty()) {
                GrantedAuthority lowerRole = (GrantedAuthority)rolesToVisitSet.iterator().next();
                rolesToVisitSet.remove(lowerRole);
                if (!visitedRolesSet.add(lowerRole) || !hierarchy.containsKey(lowerRole.getAuthority())) continue;
                if (roleName.equals(lowerRole.getAuthority())) {
                    throw new CycleInRoleHierarchyException();
                }
                rolesToVisitSet.addAll(hierarchy.get(lowerRole.getAuthority()));
            }
            rolesReachableInOneOrMoreStepsMap.put(roleName, visitedRolesSet);
            logger.debug((Object)LogMessage.format((String)"buildRolesReachableInOneOrMoreStepsMap() - From role %s one can reach %s in one or more steps.", (Object)roleName, visitedRolesSet));
        }
        return rolesReachableInOneOrMoreStepsMap;
    }

    public static final class Builder {
        private final String rolePrefix;
        private final Map<String, Set<GrantedAuthority>> hierarchy;

        private Builder(String rolePrefix) {
            this.rolePrefix = rolePrefix;
            this.hierarchy = new LinkedHashMap<String, Set<GrantedAuthority>>();
        }

        public ImpliedRoles role(String role) {
            Assert.hasText((String)role, (String)"role must not be empty");
            return new ImpliedRoles(role);
        }

        public RoleHierarchyImpl build() {
            return new RoleHierarchyImpl(this.hierarchy);
        }

        private Builder addHierarchy(String role, String ... impliedRoles) {
            Set withPrefix = this.hierarchy.computeIfAbsent(this.rolePrefix.concat(role), r -> new HashSet());
            for (String impliedRole : impliedRoles) {
                withPrefix.add(new SimpleGrantedAuthority(this.rolePrefix.concat(impliedRole)));
            }
            return this;
        }

        public final class ImpliedRoles {
            private final String role;

            private ImpliedRoles(String role) {
                this.role = role;
            }

            public Builder implies(String ... impliedRoles) {
                Assert.notEmpty((Object[])impliedRoles, (String)"at least one implied role must be provided");
                Assert.noNullElements((Object[])impliedRoles, (String)"implied role name(s) cannot be empty");
                return Builder.this.addHierarchy(this.role, impliedRoles);
            }
        }
    }
}

