/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.plugin;

import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.attachment.AttachmentPlugin;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SiteAttachmentPlugin
extends AttachmentPlugin {
    public static final String OBJECT_TYPE = "site";
    private static final String SITE_WITH_ID_NOT_FOUND = "Site with id '%s' not found";
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private AttachmentService attachmentService;

    @PostConstruct
    public void init() {
        this.attachmentService.addPlugin((AttachmentPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean hasAccessPermission(org.exoplatform.services.security.Identity userIdentity, String siteId) throws ObjectNotFoundException {
        return this.userAcl.hasAccessPermission(OBJECT_TYPE, siteId, userIdentity);
    }

    public boolean hasEditPermission(org.exoplatform.services.security.Identity userIdentity, String siteId) throws ObjectNotFoundException {
        return this.userAcl.hasEditPermission(OBJECT_TYPE, siteId, userIdentity);
    }

    public long getAudienceId(String siteId) throws ObjectNotFoundException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(Long.parseLong(siteId));
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format(SITE_WITH_ID_NOT_FOUND, siteId));
        }
        if (this.isSpaceSite(portalConfig)) {
            Space space = this.spaceService.getSpaceByGroupId(portalConfig.getName());
            return this.getSpaceIdentityId(space);
        }
        if (this.isUserSite(portalConfig)) {
            return this.getUserIdentityId(portalConfig);
        }
        return 0L;
    }

    public long getSpaceId(String siteId) throws ObjectNotFoundException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(Long.parseLong(siteId));
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format(SITE_WITH_ID_NOT_FOUND, siteId));
        }
        if (this.isSpaceSite(portalConfig)) {
            Space space = this.spaceService.getSpaceByGroupId(portalConfig.getName());
            return space == null ? 0L : space.getSpaceId();
        }
        return 0L;
    }

    private long getSpaceIdentityId(Space space) {
        if (space != null) {
            return this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName()).getIdentityId();
        }
        return 0L;
    }

    private long getUserIdentityId(PortalConfig portalConfig) {
        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(portalConfig.getName());
        if (userIdentity != null) {
            return userIdentity.getIdentityId();
        }
        return 0L;
    }

    private boolean isSpaceSite(PortalConfig portalConfig) {
        return StringUtils.equalsIgnoreCase((CharSequence)portalConfig.getType(), (CharSequence)PortalConfig.GROUP_TYPE) && StringUtils.startsWith((CharSequence)portalConfig.getName(), (CharSequence)"/spaces");
    }

    private boolean isUserSite(PortalConfig portalConfig) {
        return StringUtils.equalsIgnoreCase((CharSequence)portalConfig.getType(), (CharSequence)PortalConfig.USER_TYPE);
    }
}

