/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.sql.ast.spi.AbstractSqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.FunctionTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.ValuesTableReference;

public class AliasCollector
extends AbstractSqlAstWalker {
    private final Map<String, TableReference> tableReferenceMap = new HashMap<String, TableReference>();

    public static Map<String, TableReference> getTableReferences(SqlAstNode node) {
        AliasCollector aliasCollector = new AliasCollector();
        node.accept(aliasCollector);
        return aliasCollector.tableReferenceMap;
    }

    @Override
    public void visitNamedTableReference(NamedTableReference tableReference) {
        this.tableReferenceMap.put(tableReference.getIdentificationVariable(), tableReference);
    }

    @Override
    public void visitValuesTableReference(ValuesTableReference tableReference) {
        this.tableReferenceMap.put(tableReference.getIdentificationVariable(), tableReference);
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.tableReferenceMap.put(tableReference.getIdentificationVariable(), tableReference);
    }

    @Override
    public void visitFunctionTableReference(FunctionTableReference tableReference) {
        this.tableReferenceMap.put(tableReference.getIdentificationVariable(), tableReference);
    }
}

