/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api;

import java.util.Locale;
import org.gatein.api.Portal;
import org.gatein.api.common.URIResolver;
import org.gatein.api.navigation.Navigation;
import org.gatein.api.navigation.Node;
import org.gatein.api.navigation.NodePath;
import org.gatein.api.page.Page;
import org.gatein.api.page.PageId;
import org.gatein.api.security.User;
import org.gatein.api.site.Site;
import org.gatein.api.site.SiteId;

public abstract class PortalRequest {
    private Site site;
    private Navigation navigation;
    private Page page;
    private boolean pageLoaded;
    private static ThreadLocal<PortalRequest> instance = new ThreadLocal<PortalRequest>(){

        @Override
        protected PortalRequest initialValue() {
            return null;
        }
    };

    public abstract User getUser();

    public abstract SiteId getSiteId();

    public abstract NodePath getNodePath();

    public abstract Locale getLocale();

    public Site getSite() {
        if (this.site == null) {
            this.site = this.getPortal().getSite(this.getSiteId());
        }
        return this.site;
    }

    public Page getPage() {
        if (!this.pageLoaded) {
            Node node = this.getNavigation().getNode(this.getNodePath());
            PageId pageId = node != null ? node.getPageId() : null;
            this.page = pageId == null ? null : this.getPortal().getPage(pageId);
            this.pageLoaded = true;
        }
        return this.page;
    }

    public Navigation getNavigation() {
        if (this.navigation == null) {
            this.navigation = this.getPortal().getNavigation(this.getSiteId());
        }
        return this.navigation;
    }

    public abstract Portal getPortal();

    public abstract URIResolver getURIResolver();

    public static PortalRequest getInstance() {
        return instance.get();
    }

    protected static void setInstance(PortalRequest request) {
        if (request == null) {
            instance.remove();
        } else {
            instance.set(request);
        }
    }
}

