/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.stat;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.exoplatform.commons.api.notification.stat.EntityStatistics;
import org.exoplatform.commons.api.notification.stat.PluginStatistics;
import org.exoplatform.commons.api.notification.stat.QueryStatistics;
import org.exoplatform.commons.api.notification.stat.QueueStatistics;
import org.exoplatform.commons.api.notification.stat.Statistics;
import org.exoplatform.commons.api.notification.stat.StatisticsCollector;
import org.exoplatform.commons.notification.impl.PluginStatisticService;
import org.exoplatform.commons.notification.stat.ThreadLocalEntityStatisticsImpl;
import org.exoplatform.commons.notification.stat.ThreadLocalPluginStatisticsImpl;
import org.exoplatform.commons.notification.stat.ThreadLocalQueryStatisticsImpl;
import org.exoplatform.commons.notification.stat.ThreadLocalQueueStatisticsImpl;
import org.hibernate.internal.util.collections.ArrayHelper;

public class ThreadLocalStatisticsImpl
implements Statistics,
StatisticsCollector {
    private volatile boolean isStatisticsEnabled;
    private volatile long startTime;
    private AtomicLong entityLoadCount = new AtomicLong();
    private AtomicLong entityUpdateCount = new AtomicLong();
    private AtomicLong entityInsertCount = new AtomicLong();
    private AtomicLong entityDeleteCount = new AtomicLong();
    private AtomicLong queuePutCount = new AtomicLong();
    private AtomicLong queuePollCount = new AtomicLong();
    private AtomicLong messageCreatedCount = new AtomicLong();
    private AtomicLong notificationCreatedCount = new AtomicLong();
    private AtomicLong digestCreatedCount = new AtomicLong();
    private AtomicLong queryExecutionCount = new AtomicLong();
    private AtomicLong queryExecutionMaxTime = new AtomicLong();
    private volatile String queryExecutionMaxTimeQueryString;
    private final PluginStatisticService pluginStatistic;
    private final ConcurrentMap<String, PluginStatistics> pluginStatistics = new ConcurrentHashMap<String, PluginStatistics>();
    private final ConcurrentMap<String, QueueStatistics> queueStatistics = new ConcurrentHashMap<String, QueueStatistics>();
    private final ConcurrentMap<String, EntityStatistics> entityStatistics = new ConcurrentHashMap<String, EntityStatistics>();
    private final ConcurrentMap<String, QueryStatistics> queryStatistics = new ConcurrentHashMap<String, QueryStatistics>();

    public ThreadLocalStatisticsImpl(PluginStatisticService pluginStatistic) {
        this.clear();
        this.pluginStatistic = pluginStatistic;
    }

    public void clear() {
        this.entityLoadCount.set(0L);
        this.entityUpdateCount.set(0L);
        this.entityInsertCount.set(0L);
        this.entityDeleteCount.set(0L);
        this.queryExecutionCount.set(0L);
        this.queryExecutionMaxTime.set(0L);
        this.entityStatistics.clear();
        this.queryStatistics.clear();
        this.queuePutCount.set(0L);
        this.queuePollCount.set(0L);
        this.startTime = System.currentTimeMillis();
    }

    public void createMessageInfoCount(String pluginId) {
        this.messageCreatedCount.incrementAndGet();
        this.pluginStatistic.increaseCreatedMessageCount(pluginId);
        this.getPluginStatistics(pluginId).incrementCreateMessageCount();
    }

    public void createNotificationInfoCount(String pluginId) {
        this.notificationCreatedCount.incrementAndGet();
        this.pluginStatistic.increaseCreatedNotifCount(pluginId);
        this.getPluginStatistics(pluginId).incrementCreateNotificationCount();
    }

    public void createDigestCount(String pluginId) {
        this.digestCreatedCount.incrementAndGet();
        this.pluginStatistic.increaseCreatedDigestCount(pluginId);
        this.getPluginStatistics(pluginId).incrementCreateDigestCount();
    }

    public void deleteEntity(String nodeType) {
        this.entityDeleteCount.incrementAndGet();
        this.getEntityStatistics(nodeType).incrementDeleteCount();
    }

    public void insertEntity(String nodeType) {
        this.entityInsertCount.incrementAndGet();
        this.getEntityStatistics(nodeType).incrementInsertCount();
    }

    public void updateEntity(String nodeType) {
        this.entityUpdateCount.incrementAndGet();
        this.getEntityStatistics(nodeType).incrementUpdateCount();
    }

    public void loadEntity(String nodeType) {
        this.entityLoadCount.incrementAndGet();
        this.getEntityStatistics(nodeType).incrementLoadCount();
    }

    public void queryExecuted(String statement, long rows, long time) {
        this.queryExecutionCount.getAndIncrement();
        boolean isLongestQuery = false;
        long old = this.queryExecutionMaxTime.get();
        while ((isLongestQuery = time > old) && !this.queryExecutionMaxTime.compareAndSet(old, time)) {
            old = this.queryExecutionMaxTime.get();
        }
        if (isLongestQuery) {
            this.queryExecutionMaxTimeQueryString = statement;
        }
        if (statement != null) {
            this.getQueryStatistics(statement).executed(rows, time);
        }
    }

    public void pollQueue(String pluginId) {
        this.queuePollCount.incrementAndGet();
        this.getQueueStatistics(pluginId).incrementPollCount();
    }

    public void putQueue(String pluginId) {
        this.queuePutCount.incrementAndGet();
        this.getQueueStatistics(pluginId).incrementPutCount();
    }

    public PluginStatistics getPluginStatistics(String pluginId) {
        PluginStatistics previous;
        PluginStatistics ps = (PluginStatistics)this.pluginStatistics.get(pluginId);
        if (ps == null && (previous = this.pluginStatistics.putIfAbsent(pluginId, ps = new ThreadLocalPluginStatisticsImpl())) != null) {
            ps = previous;
        }
        return ps;
    }

    public EntityStatistics getEntityStatistics(String nodeType) {
        EntityStatistics previous;
        EntityStatistics es = (EntityStatistics)this.entityStatistics.get(nodeType);
        if (es == null && (previous = this.entityStatistics.putIfAbsent(nodeType, es = new ThreadLocalEntityStatisticsImpl())) != null) {
            es = previous;
        }
        return es;
    }

    public QueueStatistics getQueueStatistics(String pluginId) {
        QueueStatistics previous;
        QueueStatistics qs = (QueueStatistics)this.queueStatistics.get(pluginId);
        if (qs == null && (previous = this.queueStatistics.putIfAbsent(pluginId, qs = new ThreadLocalQueueStatisticsImpl())) != null) {
            qs = previous;
        }
        return qs;
    }

    public QueryStatistics getQueryStatistics(String queryString) {
        QueryStatistics previous;
        QueryStatistics qs = (QueryStatistics)this.queryStatistics.get(queryString);
        if (qs == null && (previous = this.queryStatistics.putIfAbsent(queryString, qs = new ThreadLocalQueryStatisticsImpl())) != null) {
            qs = previous;
        }
        return qs;
    }

    public long getEntityDeleteCount() {
        return this.entityDeleteCount.get();
    }

    public long getEntityLoadCount() {
        return this.entityLoadCount.get();
    }

    public long getEntityInsertCount() {
        return this.entityInsertCount.get();
    }

    public long getQueryExecutionCount() {
        return this.queryExecutionCount.get();
    }

    public long getQueryExecutionMaxTime() {
        return this.queryExecutionMaxTime.get();
    }

    public String getQueryExecutionMaxTimeQueryString() {
        return this.queryExecutionMaxTimeQueryString;
    }

    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    public String[] getQueries() {
        return ArrayHelper.toStringArray(this.queryStatistics.keySet());
    }

    public String[] getPluginNames() {
        return ArrayHelper.toStringArray(this.pluginStatistics.keySet());
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String toString() {
        return "Statistics[" + "start time=" + this.startTime + ",message created=" + this.messageCreatedCount + ",notification created=" + this.notificationCreatedCount + ",digest created=" + this.digestCreatedCount + ",queue put=" + this.queuePutCount + ",queue poll=" + this.queuePollCount + ",entities loaded=" + this.entityLoadCount + ",entities updated=" + this.entityUpdateCount + ",entities inserted=" + this.entityInsertCount + ",entities deleted=" + this.entityDeleteCount + ",queries executed to database=" + this.queryExecutionCount + ",max query time=" + this.queryExecutionMaxTime + ']';
    }

    public long getQueuePutCount() {
        return this.queuePutCount.get();
    }

    public long getQueuePollCount() {
        return this.queuePollCount.get();
    }

    public long getMessageCreatedCount() {
        return this.messageCreatedCount.get();
    }

    public long getNotificationCreatedCount() {
        return this.notificationCreatedCount.get();
    }

    public long getDigestCreatedCount() {
        return this.digestCreatedCount.get();
    }

    public void setStatisticsEnabled(boolean enable) {
        this.isStatisticsEnabled = enable;
    }
}

