/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

public class PropertySourcesPlaceholderConfigurer
extends PlaceholderConfigurerSupport
implements EnvironmentAware {
    public static final String LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME = "localProperties";
    public static final String ENVIRONMENT_PROPERTIES_PROPERTY_SOURCE_NAME = "environmentProperties";
    @Nullable
    private MutablePropertySources propertySources;
    @Nullable
    private PropertySources appliedPropertySources;
    @Nullable
    private Environment environment;

    public void setPropertySources(PropertySources propertySources) {
        this.propertySources = new MutablePropertySources(propertySources);
    }

    @Override
    public void setEnvironment(Environment environment2) {
        this.environment = environment2;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.propertySources == null) {
            this.propertySources = new MutablePropertySources();
            if (this.environment != null) {
                PropertySource propertySource;
                Environment environment2 = this.environment;
                if (environment2 instanceof ConfigurableEnvironment) {
                    ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)environment2;
                    propertySource = new ConfigurableEnvironmentPropertySource(configurableEnvironment);
                } else {
                    propertySource = new FallbackEnvironmentPropertySource(this.environment);
                }
                PropertySource environmentPropertySource = propertySource;
                this.propertySources.addLast(environmentPropertySource);
            }
            try {
                PropertiesPropertySource localPropertySource = new PropertiesPropertySource(LOCAL_PROPERTIES_PROPERTY_SOURCE_NAME, this.mergeProperties());
                if (this.localOverride) {
                    this.propertySources.addFirst((PropertySource)localPropertySource);
                } else {
                    this.propertySources.addLast((PropertySource)localPropertySource);
                }
            }
            catch (IOException ex) {
                throw new BeanInitializationException("Could not load properties", (Throwable)ex);
            }
        }
        this.processProperties(beanFactory, this.createPropertyResolver(this.propertySources));
        this.appliedPropertySources = this.propertySources;
    }

    protected ConfigurablePropertyResolver createPropertyResolver(MutablePropertySources propertySources) {
        return new PropertySourcesPropertyResolver((PropertySources)propertySources);
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, ConfigurablePropertyResolver propertyResolver) throws BeansException {
        propertyResolver.setPlaceholderPrefix(this.placeholderPrefix);
        propertyResolver.setPlaceholderSuffix(this.placeholderSuffix);
        propertyResolver.setValueSeparator(this.valueSeparator);
        propertyResolver.setEscapeCharacter(this.escapeCharacter);
        StringValueResolver valueResolver = strVal -> {
            String resolved;
            String string = resolved = this.ignoreUnresolvablePlaceholders ? propertyResolver.resolvePlaceholders(strVal) : propertyResolver.resolveRequiredPlaceholders(strVal);
            if (this.trimValues) {
                resolved = resolved.trim();
            }
            return resolved.equals(this.nullValue) ? null : resolved;
        };
        this.doProcessProperties(beanFactoryToProcess, valueResolver);
    }

    @Deprecated
    protected void processProperties(ConfigurableListableBeanFactory beanFactory, Properties props) {
        throw new UnsupportedOperationException("Call processProperties(ConfigurableListableBeanFactory, ConfigurablePropertyResolver) instead");
    }

    public PropertySources getAppliedPropertySources() throws IllegalStateException {
        Assert.state((this.appliedPropertySources != null ? 1 : 0) != 0, (String)"PropertySources have not yet been applied");
        return this.appliedPropertySources;
    }

    private static class ConfigurableEnvironmentPropertySource
    extends PropertySource<ConfigurableEnvironment> {
        ConfigurableEnvironmentPropertySource(ConfigurableEnvironment environment2) {
            super(PropertySourcesPlaceholderConfigurer.ENVIRONMENT_PROPERTIES_PROPERTY_SOURCE_NAME, (Object)environment2);
        }

        public boolean containsProperty(String name) {
            for (PropertySource propertySource : ((ConfigurableEnvironment)this.source).getPropertySources()) {
                if (!propertySource.containsProperty(name)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public String getProperty(String name) {
            for (PropertySource propertySource : ((ConfigurableEnvironment)this.source).getPropertySources()) {
                Object candidate = propertySource.getProperty(name);
                if (candidate == null) continue;
                return this.convertToString(candidate);
            }
            return null;
        }

        @Nullable
        private String convertToString(Object value) {
            if (value instanceof String) {
                String string = (String)value;
                return string;
            }
            return (String)((ConfigurableEnvironment)this.source).getConversionService().convert(value, String.class);
        }

        public String toString() {
            return "ConfigurableEnvironmentPropertySource {propertySources=" + String.valueOf(((ConfigurableEnvironment)this.source).getPropertySources()) + "}";
        }
    }

    private static class FallbackEnvironmentPropertySource
    extends PropertySource<Environment> {
        FallbackEnvironmentPropertySource(Environment environment2) {
            super(PropertySourcesPlaceholderConfigurer.ENVIRONMENT_PROPERTIES_PROPERTY_SOURCE_NAME, (Object)environment2);
        }

        public boolean containsProperty(String name) {
            return ((Environment)this.source).containsProperty(name);
        }

        @Nullable
        public String getProperty(String name) {
            return ((Environment)this.source).getProperty(name);
        }

        public String toString() {
            return "FallbackEnvironmentPropertySource {environment=" + String.valueOf(this.source) + "}";
        }
    }
}

