/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch._types.NestedSortValue;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.ScriptSortType;
import co.elastic.clients.elasticsearch._types.SortMode;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOptionsVariant;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ScriptSort
implements SortOptionsVariant,
JsonpSerializable {
    @Nullable
    private final SortOrder order;
    private final Script script;
    @Nullable
    private final ScriptSortType type;
    @Nullable
    private final SortMode mode;
    @Nullable
    private final NestedSortValue nested;
    public static final JsonpDeserializer<ScriptSort> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptSort::setupScriptSortDeserializer);

    private ScriptSort(Builder builder) {
        this.order = builder.order;
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
        this.type = builder.type;
        this.mode = builder.mode;
        this.nested = builder.nested;
    }

    public static ScriptSort of(Function<Builder, ObjectBuilder<ScriptSort>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SortOptions.Kind _sortOptionsKind() {
        return SortOptions.Kind.Script;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    public final Script script() {
        return this.script;
    }

    @Nullable
    public final ScriptSortType type() {
        return this.type;
    }

    @Nullable
    public final SortMode mode() {
        return this.mode;
    }

    @Nullable
    public final NestedSortValue nested() {
        return this.nested;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
        if (this.type != null) {
            generator.writeKey("type");
            this.type.serialize(generator, mapper);
        }
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (this.nested != null) {
            generator.writeKey("nested");
            this.nested.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupScriptSortDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::order, SortOrder._DESERIALIZER, "order");
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::type, ScriptSortType._DESERIALIZER, "type");
        op.add(Builder::mode, SortMode._DESERIALIZER, "mode");
        op.add(Builder::nested, NestedSortValue._DESERIALIZER, "nested");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ScriptSort> {
        @Nullable
        private SortOrder order;
        private Script script;
        @Nullable
        private ScriptSortType type;
        @Nullable
        private SortMode mode;
        @Nullable
        private NestedSortValue nested;

        public final Builder order(@Nullable SortOrder value) {
            this.order = value;
            return this;
        }

        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder type(@Nullable ScriptSortType value) {
            this.type = value;
            return this;
        }

        public final Builder mode(@Nullable SortMode value) {
            this.mode = value;
            return this;
        }

        public final Builder nested(@Nullable NestedSortValue value) {
            this.nested = value;
            return this;
        }

        public final Builder nested(Function<NestedSortValue.Builder, ObjectBuilder<NestedSortValue>> fn) {
            return this.nested(fn.apply(new NestedSortValue.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptSort build() {
            this._checkSingleUse();
            return new ScriptSort(this);
        }
    }
}

