/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.rest.model.MediaInfo;
import io.meeds.chat.service.MatrixService;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
public class MatrixInfectedFileCleanupListener
extends Listener<String, Object> {
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private MatrixService matrixService;
    private static final String INFECTED_ITEM_PATH = "infectedItemPath";
    public static final String INFECTED_ITEM_NAME = "infectedItemName";
    public static final String INFECTED_ITEM_LAST_MODIFIER = "infectedItemLastModifier";
    public static final String INFECTED_ITEM_ID = "infectedItemId";
    public static final String INFECTED_ITEM_MODIFICATION_DATE = "infectedItemModificationDate";
    private static final String EXTERNAL_FILE_SYSTEM = "externalFileSystem";
    private static final String SYNAPSE = "synapse";
    private static final String LOCAL_CONTENT_FOLDER = "/local_content/";
    private static final String CLEAN_FILE_INFECTED = "clean-file-infected";
    private final String[] eventTypes = new String[]{"clean-file-infected"};

    @PostConstruct
    public void init() {
        for (String eventType : this.eventTypes) {
            this.listenerService.addListener(eventType, (ListenerBase)this);
        }
    }

    public void onEvent(Event<String, Object> event) throws Exception {
        MediaInfo mediaInfo;
        String mediaId;
        String path;
        String type = (String)event.getSource();
        Map infectedItem = (Map)event.getData();
        if (type.equals(EXTERNAL_FILE_SYSTEM) && infectedItem.containsKey(INFECTED_ITEM_PATH) && (path = (String)infectedItem.get(INFECTED_ITEM_PATH)).contains(File.separator + SYNAPSE + File.separator) && (mediaId = this.extractMediaId(path)) != null && (mediaInfo = (MediaInfo)this.matrixService.getMediaInfo(mediaId).orElse(null)) != null) {
            this.matrixService.deleteMedia(mediaId);
            this.listenerService.broadcast("infected-file-cleaned", null, this.buildFileInfo(mediaInfo));
        }
    }

    private Map<String, String> buildFileInfo(MediaInfo mediaInfo) {
        HashMap<String, String> infectedItem = new HashMap<String, String>();
        infectedItem.put(INFECTED_ITEM_NAME, mediaInfo.getFilename());
        infectedItem.put(INFECTED_ITEM_ID, mediaInfo.getMediaId());
        infectedItem.put(INFECTED_ITEM_LAST_MODIFIER, this.matrixService.findUserByMatrixId(mediaInfo.getOwner()));
        infectedItem.put(INFECTED_ITEM_MODIFICATION_DATE, String.valueOf(mediaInfo.getCreatedTs()));
        return infectedItem;
    }

    private String extractMediaId(String path) {
        if (path == null) {
            return null;
        }
        String normalizedPath = path.replace(File.separatorChar, '/');
        int localContentIndex = normalizedPath.indexOf(LOCAL_CONTENT_FOLDER);
        if (localContentIndex < 0) {
            return null;
        }
        String relativePath = normalizedPath.substring(localContentIndex + LOCAL_CONTENT_FOLDER.length());
        String[] parts = relativePath.split("/");
        if (parts.length < 2) {
            return null;
        }
        return parts[0] + parts[1] + parts[2];
    }
}

