/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service.utils;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class HTTPHelper {
    protected static HttpResponse<String> sendHttpGetRequest(String url, String token) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Authorization", "Bearer " + token).GET().build();
        return client.send(request, HttpResponse.BodyHandlers.ofString());
    }

    protected static HttpResponse<String> sendHttpPostRequest(String url, String token, String contentAsJson) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = StringUtils.isNotBlank((CharSequence)token) ? HttpRequest.newBuilder().uri(URI.create(url)).header("Authorization", "Bearer " + token).POST(HttpRequest.BodyPublishers.ofString(contentAsJson)).build() : HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(contentAsJson)).build();
        return client.send(request, HttpResponse.BodyHandlers.ofString());
    }

    protected static HttpResponse<String> sendHttpPostRequest(String url, String token, String mimeType, byte[] fileContent) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Authorization", "Bearer " + token).header("Content-type", mimeType).POST(HttpRequest.BodyPublishers.ofByteArray(fileContent)).build();
        return client.send(request, HttpResponse.BodyHandlers.ofString());
    }

    protected static HttpResponse<String> sendHttpPutRequest(String url, String token, String contentAsJson) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Authorization", "Bearer " + token).PUT(HttpRequest.BodyPublishers.ofString(contentAsJson)).build();
        return client.send(request, HttpResponse.BodyHandlers.ofString());
    }

    protected static HttpResponse<String> sendHttpDeleteRequest(String url, String token, String contentAsJson) throws IOException, InterruptedException {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Authorization", "Bearer " + token).method("DELETE", HttpRequest.BodyPublishers.ofString(contentAsJson)).build();
        return client.send(request, HttpResponse.BodyHandlers.ofString());
    }

    public static void sendInvitationToMembers(ArrayList<String> strings, String matrixRoomId) {
    }
}

