/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.core.identity.service;

import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.core.identity.model.UserImportResult;
import io.meeds.social.core.identity.service.UserImportService$AjcClosure1;
import io.meeds.social.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.rest.UserFieldValidator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.core.model.BannerAttachment;
import org.exoplatform.social.core.profileproperty.ProfilePropertyService;
import org.exoplatform.social.core.profileproperty.model.ProfilePropertySetting;
import org.exoplatform.social.core.storage.IdentityStorageException;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.login.recovery.PasswordRecoveryService;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserImportService {
    private static final String ONBOARD_USER_FIELD = "onboardUser";
    private static final String EXTERNALS_GROUP = "/platform/externals";
    private static final String GUEST = "Guest";
    private static final List<String> SYSTEM_PARENT_MULTIVALUED_FIELDS;
    private static final String TYPE_FIELD = "type";
    private static final String ENABLED_FIELD = "enabled";
    private static final String TIME_ZONE_FIELD = "timeZone";
    private static final String ABOUT_ME_FIELD = "aboutMe";
    private static final String GROUPS_FIELD = "groups";
    private static final Log LOG;
    private static final String PASSWORD_FIELD = "password";
    private static final String FIRST_NAME_FIELD = "firstName";
    private static final String LAST_NAME_FIELD = "lastName";
    private static final String EMAIL_FIELD = "email";
    private static final String USER_NAME_FIELD = "userName";
    private static final List<String> STANDARD_FIELDS;
    private static final List<String> NOT_PROPERTY_FIELDS;
    private static final UserFieldValidator USERNAME_VALIDATOR;
    private static final UserFieldValidator EMAIL_VALIDATOR;
    private static final UserFieldValidator LASTNAME_VALIDATOR;
    private static final UserFieldValidator FIRSTNAME_VALIDATOR;
    private static final UserFieldValidator PASSWORD_VALIDATOR;
    private static final List<UserFieldValidator> USER_FIELD_VALIDATORS;
    private static final List<UserFieldValidator> USER_FIELD_NO_PASSWORD_VALIDATORS;
    protected Map<String, UserImportResult> importUsersProcessing = new ConcurrentHashMap<String, UserImportResult>();
    protected ExecutorService importExecutorService = null;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private ProfilePropertyService profilePropertyService;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private PasswordRecoveryService passwordRecoveryService;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private UserACL userAcl;
    private Group externalsGroup = null;
    private MembershipType memberMembershipType = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        this.importExecutorService = Executors.newSingleThreadExecutor();
    }

    @PreDestroy
    public void stop() {
        this.importExecutorService.shutdownNow();
    }

    public UserImportResult getUsersImportResult(String uploadId) {
        return this.importUsersProcessing.get(uploadId);
    }

    public void cleanUsersImportResult(String uploadId) {
        this.importUsersProcessing.remove(uploadId);
        this.uploadService.removeUploadResource(uploadId);
    }

    public void importUsers(String uploadId, String modifierUsername, Locale locale, String url, boolean sync) {
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            throw new IllegalArgumentException("UPLOAD_ID:NOT_FOUND");
        }
        UserImportResult userImportResult = new UserImportResult();
        this.importUsersProcessing.put(uploadId, userImportResult);
        try (BufferedReader reader = new BufferedReader(new FileReader(uploadResource.getStoreLocation()));){
            userImportResult.setCount(reader.lines().count() - 1L);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("UPLOAD_ID_FILE:NOT_FOUND");
        }
        catch (IOException e) {
            throw new IllegalStateException("ERROR_READING_FILE");
        }
        if (userImportResult.getCount() < 1L) {
            throw new IllegalArgumentException("BAD_FORMAT:FILE_EMPTY");
        }
        if (sync) {
            this.importUsers(uploadResource.getStoreLocation(), userImportResult, modifierUsername, locale, url);
        } else {
            this.importUsersAsync(uploadResource.getStoreLocation(), userImportResult, modifierUsername, locale, url);
        }
    }

    protected void importUsersAsync(String fileLocation, UserImportResult userImportResult, String modifierUsername, Locale locale, String url) {
        this.importExecutorService.execute(() -> this.importUsersTransactional(fileLocation, userImportResult, modifierUsername, locale, url));
    }

    @ContainerTransactional
    protected void importUsersTransactional(String fileLocation, UserImportResult userImportResult, String modifierUsername, Locale locale, String url) {
        String string = fileLocation;
        UserImportResult userImportResult2 = userImportResult;
        String string2 = modifierUsername;
        Locale locale2 = locale;
        String string3 = url;
        Object[] objectArray = new Object[]{string, userImportResult2, string2, locale2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, userImportResult2, string2, locale2, string3, joinPoint};
        UserImportService$AjcClosure1 userImportService$AjcClosure1 = new UserImportService$AjcClosure1(objectArray2);
        ContainerTransactionalAspect.aspectOf().around(userImportService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importUsers(String fileLocation, UserImportResult userImportResult, String modifierUsername, Locale locale, String url) {
        try (BufferedReader reader = new BufferedReader(new FileReader(fileLocation));){
            String headerLine = null;
            headerLine = reader.readLine();
            if (StringUtils.isBlank((CharSequence)headerLine)) {
                return;
            }
            ArrayList<String> fields = new ArrayList<String>(Arrays.stream(headerLine.split(",")).map(String::trim).toList());
            List<String> unauthorizedFields = this.computeFields(userImportResult, fields);
            String userCSVLine = reader.readLine();
            while (userCSVLine != null) {
                userImportResult.incrementProcessed();
                if (StringUtils.isNotBlank((CharSequence)userCSVLine)) {
                    try {
                        this.importUser(userImportResult, modifierUsername, locale, url, fields, unauthorizedFields, userCSVLine);
                    }
                    catch (Throwable e) {
                        LOG.warn("Error importing user data at line '{}'. Continue processing other lines", new Object[]{userImportResult.getProcessedCount() + 1L, e});
                    }
                    finally {
                        RequestLifeCycle.restartTransaction();
                    }
                }
                userCSVLine = reader.readLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String importUser(UserImportResult userImportResult, String modifierUsername, Locale locale, String url, List<String> fields, List<String> fieldsToRemove, String userCSVLine) throws Exception {
        List<String> userProperties = Arrays.asList(userCSVLine.split(","));
        JSONObject userObject = new JSONObject();
        for (int i = 0; i < fields.size(); ++i) {
            if (i >= userProperties.size()) continue;
            userObject.put(fields.get(i), (Object)userProperties.get(i));
        }
        UserImpl user = (UserImpl)JsonUtils.fromJsonString((String)userObject.toString(), UserImpl.class);
        String userName = user.getUserName();
        if (StringUtils.isBlank((CharSequence)userName)) {
            userImportResult.addErrorMessage(userName, "BAD_LINE_FORMAT:MISSING_USERNAME");
            return userName;
        }
        if (userProperties.size() < fields.size()) {
            userImportResult.addErrorMessage(userName, "BAD_LINE_FORMAT");
            return userName;
        }
        Object errorMessage = null;
        try {
            errorMessage = this.validateUser(userObject, locale, fields);
        }
        catch (Exception e) {
            errorMessage = "USER_VALIDATION_ERROR:" + e.getMessage();
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            userImportResult.addErrorMessage(userName, (String)errorMessage);
            return userName;
        }
        boolean onboardUser = userObject.has(ONBOARD_USER_FIELD) && userObject.getString(ONBOARD_USER_FIELD).equals("true");
        boolean userStatus = userObject.has(ENABLED_FIELD) && ("true".equalsIgnoreCase(userObject.getString(ENABLED_FIELD)) || "false".equalsIgnoreCase(userObject.getString(ENABLED_FIELD)));
        UserHandler userHandler = this.organizationService.getUserHandler();
        User existingUser = userHandler.findUserByName(userName, UserStatus.ANY);
        if (existingUser != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping password update for: {}", new Object[]{userName});
            }
            user.setPassword(null);
            try {
                user.setEnabled(Boolean.valueOf(true));
                userHandler.saveUser((User)user, true);
                if (userStatus) {
                    boolean enabled = Boolean.parseBoolean(userObject.getString(ENABLED_FIELD));
                    userHandler.setEnabled(userName, enabled, true);
                    user.setEnabled(Boolean.valueOf(enabled));
                }
            }
            catch (Exception e) {
                LOG.warn("Error updating user {}", new Object[]{userName, e});
                userImportResult.addErrorMessage(userName, "UPDATE_USER_ERROR:" + e.getMessage());
                String string = userName;
                return string;
            }
            finally {
                RequestLifeCycle.restartTransaction();
            }
            onboardUser = onboardUser && existingUser.isEnabled() && existingUser.getLastLoginTime().getTime() == existingUser.getCreatedDate().getTime();
        } else {
            if (this.isEmailAlreadyExists(user.getUserName(), user.getEmail())) {
                userImportResult.addErrorMessage(userName, "EMAIL:ALREADY_EXISTS");
                return userName;
            }
            try {
                userHandler.createUser((User)user, true);
                if (userStatus) {
                    boolean enabled = Boolean.parseBoolean(userObject.getString(ENABLED_FIELD));
                    userHandler.setEnabled(userName, enabled, true);
                    user.setEnabled(Boolean.valueOf(enabled));
                }
            }
            catch (Exception e) {
                LOG.warn("Error importing user {}", new Object[]{userName, e});
                userImportResult.addErrorMessage(userName, "CREATE_USER_ERROR:" + e.getMessage());
                String string = userName;
                return string;
            }
            finally {
                RequestLifeCycle.restartTransaction();
            }
        }
        this.updateUserProfileProperties(userImportResult, modifierUsername, fieldsToRemove, userObject, userName);
        this.addUserMemberships(user, userObject, userImportResult);
        if (onboardUser) {
            this.sendOnBoardingEmail(user, modifierUsername, url);
        }
        return userName;
    }

    protected void updateUserProfileProperties(UserImportResult userImportResult, String modifierUsername, List<String> fieldsToRemove, JSONObject userObject, String userName) {
        try {
            Map<String, Object> userProfileProperties = this.computeUserProfileProperties(fieldsToRemove, userObject);
            this.saveProfile(userName, userProfileProperties, modifierUsername);
        }
        catch (ObjectNotFoundException e) {
            LOG.info("User Identity profile {} wasn't found, ignore processing profile properties. This may happen when user is disabled", new Object[]{userName});
        }
        catch (IdentityStorageException e) {
            LOG.warn("Error saving user profile {}", new Object[]{userName, e});
            userImportResult.addWarnMessage(userName, e.getMessageKey());
        }
        catch (Exception e) {
            LOG.warn("Error saving user profile {}", new Object[]{userName, e});
            userImportResult.addWarnMessage(userName, "CREATE_USER_PROFILE_ERROR:" + e.getMessage());
        }
    }

    protected Map<String, Object> computeUserProfileProperties(List<String> fieldsToRemove, JSONObject userObject) {
        JSONObject userObjectCopy = new JSONObject();
        Iterator keys = userObject.keys();
        while (keys.hasNext()) {
            String k2 = (String)keys.next();
            if (fieldsToRemove.contains(k2) || NOT_PROPERTY_FIELDS.contains(k2)) continue;
            userObjectCopy.put(k2, (Object)userObject.getString(k2));
        }
        HashMap<String, Object> userProfileProperties = new HashMap<String, Object>();
        Iterator properties = userObjectCopy.keys();
        while (properties.hasNext()) {
            ArrayList values;
            String propertyName = (String)properties.next();
            String propertyValue = userObjectCopy.getString(propertyName);
            ProfilePropertySetting parentPropertySetting = null;
            ProfilePropertySetting propertySetting = this.profilePropertyService.getProfileSettingByName(propertyName);
            if (propertySetting == null && propertyName.contains(".")) {
                String[] propertyNames = propertyName.split("\\.");
                propertySetting = this.profilePropertyService.getProfileSettingByName(propertyNames[1]);
            }
            if (propertySetting != null && propertySetting.getParentId() != null) {
                parentPropertySetting = this.profilePropertyService.getProfileSettingById(propertySetting.getParentId());
            }
            HashMap<String, String> childPropertyMap = new HashMap<String, String>();
            childPropertyMap.put("value", propertyValue);
            if (propertySetting != null && propertySetting.isMultiValued()) {
                userProfileProperties.computeIfAbsent(propertySetting.getPropertyName(), k -> new ArrayList());
                values = (ArrayList)userProfileProperties.get(propertySetting.getPropertyName());
                for (String val : propertyValue.split(";")) {
                    HashMap<String, String> childProperty = new HashMap<String, String>();
                    childProperty.put("value", val);
                    values.add(childProperty);
                }
                userProfileProperties.put(propertySetting.getPropertyName(), values);
                continue;
            }
            if (parentPropertySetting != null) {
                childPropertyMap.put("key", propertySetting.getPropertyName());
                userProfileProperties.computeIfAbsent(parentPropertySetting.getPropertyName(), k -> new ArrayList());
                values = (ArrayList)userProfileProperties.get(parentPropertySetting.getPropertyName());
                values.add(childPropertyMap);
                userProfileProperties.put(parentPropertySetting.getPropertyName(), values);
                continue;
            }
            userProfileProperties.put(propertyName, propertyValue);
        }
        return userProfileProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUserMemberships(UserImpl user, JSONObject userObject, UserImportResult userImportResult) {
        try {
            String memberships;
            if (userObject.has(TYPE_FIELD) && GUEST.equalsIgnoreCase(userObject.getString(TYPE_FIELD))) {
                RequestLifeCycle.restartTransaction();
                try {
                    this.linkMembership(user, this.getExternalsGroup(), this.getMemberMembershipType(), userImportResult);
                    this.organizationService.getMembershipHandler().removeMembership(String.format("member:%s:/platform/users", user.getUserName()), true);
                }
                finally {
                    RequestLifeCycle.restartTransaction();
                }
            }
            String string = memberships = userObject.has(GROUPS_FIELD) ? userObject.getString(GROUPS_FIELD) : null;
            if (StringUtils.isNotBlank((CharSequence)memberships)) {
                String[] membershipsList;
                for (String membershipExpression : membershipsList = memberships.split(";")) {
                    String membershipType = membershipExpression.contains(":") ? StringUtils.trim((String)membershipExpression.split(":")[0]) : "member";
                    String groupId = membershipExpression.contains(":") ? StringUtils.trim((String)membershipExpression.split(":")[1]) : membershipExpression;
                    Group groupObject = this.organizationService.getGroupHandler().findGroupById(groupId);
                    if (groupObject == null) {
                        userImportResult.addWarnMessage(user.getUserName(), "GROUP_NOT_EXISTS:" + groupId);
                        continue;
                    }
                    MembershipType mType = this.organizationService.getMembershipTypeHandler().findMembershipType(membershipType);
                    if (mType == null) {
                        userImportResult.addWarnMessage(user.getUserName(), "MEMBERSHIP_TYPE_NOT_EXISTS:" + membershipType);
                        continue;
                    }
                    this.linkMembership(user, groupObject, mType, userImportResult);
                }
            }
        }
        catch (Exception e) {
            userImportResult.addWarnMessage(user.getUserName(), "IMPORT_MEMBERSHIP_ERROR:" + e.getMessage());
        }
    }

    protected void linkMembership(UserImpl user, Group groupObject, MembershipType mType, UserImportResult userImportResult) {
        try {
            this.organizationService.getMembershipHandler().linkMembership((User)user, groupObject, mType, true);
        }
        catch (Exception e) {
            userImportResult.addWarnMessage(user.getUserName(), "IMPORT_MEMBERSHIP_ERROR:" + e.getMessage());
        }
    }

    protected List<String> computeFields(UserImportResult userImportResult, List<String> fields) {
        ArrayList<String> unauthorizedFields = new ArrayList<String>();
        for (String field : fields) {
            if (STANDARD_FIELDS.contains(field)) continue;
            if (!field.contains(".")) {
                ProfilePropertySetting propertySetting = this.profilePropertyService.getProfileSettingByName(field);
                if (propertySetting == null) {
                    userImportResult.addWarnMessage("ALL", "PROFILE_PROPERTY_DOES_NOT_EXIST:" + field);
                    unauthorizedFields.add(field);
                    continue;
                }
                if (propertySetting.isHasChildProperties()) {
                    userImportResult.addWarnMessage("ALL", "PARENT_PROPERTY_SHOULD_NOT_HAVE_VALUES:" + field);
                    unauthorizedFields.add(field);
                    continue;
                }
                if (!propertySetting.isMultiValued() || SYSTEM_PARENT_MULTIVALUED_FIELDS.contains(field)) continue;
                userImportResult.addWarnMessage("ALL", "CUSTOM_FIELD_MULTIVALUED:" + field);
                unauthorizedFields.add(field);
                continue;
            }
            String[] fieldNames = field.split("\\.");
            ProfilePropertySetting parentProperty = this.profilePropertyService.getProfileSettingByName(fieldNames[0]);
            if (fieldNames.length > 2) {
                userImportResult.addWarnMessage("ALL", "PROPERTY_HAS_MORE_THAN_ONE_PARENT:" + field);
                unauthorizedFields.add(field);
                continue;
            }
            if (parentProperty == null) {
                userImportResult.addWarnMessage("ALL", "PROPERTY_HAS_MISSING_PARENT_PROPERTY:" + field);
                unauthorizedFields.add(field);
                continue;
            }
            if (!parentProperty.isMultiValued() || SYSTEM_PARENT_MULTIVALUED_FIELDS.contains(parentProperty.getPropertyName())) continue;
            userImportResult.addWarnMessage("ALL", "CUSTOM_PARENT_FIELD:" + field);
            unauthorizedFields.add(field);
        }
        return unauthorizedFields;
    }

    protected void saveProfile(String username, Map<String, Object> profileProperties, String modifierUsername) throws ObjectNotFoundException, IllegalAccessException, IOException {
        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(username);
        if (userIdentity == null) {
            throw new ObjectNotFoundException("User identity of " + username + " wasn't found. It can be due to a disabled user.");
        }
        Profile profile = userIdentity.getProfile();
        Set<Map.Entry<String, Object>> profileEntries = profileProperties.entrySet();
        for (Map.Entry<String, Object> entry : profileEntries) {
            String name = entry.getKey();
            Object value = entry.getValue();
            String fieldName = UserImportResult.getFieldName((String)name);
            this.updateProfileField(profile, fieldName, value, false, modifierUsername);
        }
        this.identityManager.updateProfile(profile, modifierUsername, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateProfileField(Profile profile, String name, Object value, boolean save, String modifierUsername) throws IllegalAccessException, IOException {
        ProfilePropertySetting propertySetting = this.profilePropertyService.getProfileSettingByName(name);
        if (propertySetting != null && !propertySetting.isEditable() && !this.userAcl.getUserIdentity(modifierUsername).isMemberOf(this.userAcl.getAdminGroups())) {
            throw new IllegalAccessException(String.format("Not allowed to update non modifiable field '%s'", name));
        }
        if ("external".equals(name)) {
            throw new IllegalAccessException("Not allowed to update EXTERNAL field");
        }
        if ("username".equals(name)) {
            throw new IllegalAccessException("Not allowed to update USERNAME field");
        }
        if ("avatar".equals(name) || "banner".equals(name)) {
            UploadResource uploadResource = this.uploadService.getUploadResource(value.toString());
            if (uploadResource == null) {
                throw new IllegalStateException("No uploaded resource found with uploadId = " + String.valueOf(value));
            }
            String storeLocation = uploadResource.getStoreLocation();
            try (FileInputStream inputStream = new FileInputStream(storeLocation);){
                AvatarAttachment attachment = null;
                if ("avatar".equals(name)) {
                    attachment = new AvatarAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.AVATAR));
                } else {
                    attachment = new BannerAttachment(null, uploadResource.getFileName(), uploadResource.getMimeType(), (InputStream)inputStream, System.currentTimeMillis());
                    profile.setListUpdateTypes(Arrays.asList(Profile.UpdateType.BANNER));
                }
                profile.setProperty(name, (Object)attachment);
                if (!save) return;
                this.identityManager.updateProfile(profile, modifierUsername, true);
                return;
            }
            finally {
                this.uploadService.removeUploadResource(value.toString());
            }
        } else {
            profile.setProperty(name, value);
            if (!save) return;
            this.identityManager.updateProfile(profile, modifierUsername, true);
        }
    }

    protected String validateUser(JSONObject userObject, Locale locale, List<String> fields) {
        Iterator<UserFieldValidator> iterator;
        String errorMessage = null;
        Iterator<UserFieldValidator> iterator2 = iterator = fields.contains(PASSWORD_FIELD) ? USER_FIELD_VALIDATORS.iterator() : USER_FIELD_NO_PASSWORD_VALIDATORS.iterator();
        while (iterator.hasNext() && errorMessage == null) {
            UserFieldValidator userFieldValidator = iterator.next();
            String fieldName = userFieldValidator.getField();
            String fieldValue = userObject.has(fieldName) ? userObject.getString(fieldName) : null;
            errorMessage = userFieldValidator.validate(locale, fieldValue);
        }
        return errorMessage;
    }

    protected void sendOnBoardingEmail(UserImpl user, String modifierUsername, String url) throws IllegalAccessException, IOException {
        Locale locale = this.localeConfigService.getDefaultLocaleConfig().getLocale();
        boolean onBoardingEmailSent = this.passwordRecoveryService.sendOnboardingEmail((User)user, locale, new StringBuilder(url));
        if (onBoardingEmailSent) {
            Identity userIdentity = this.identityManager.getOrCreateUserIdentity(user.getUserName());
            Profile profile = userIdentity.getProfile();
            this.updateProfileField(profile, "enrollmentDate", String.valueOf(Calendar.getInstance().getTimeInMillis()), true, modifierUsername);
        }
    }

    protected boolean isEmailAlreadyExists(String username, String email) throws Exception {
        Query query = new Query();
        query.setEmail(email);
        ListAccess users = this.organizationService.getUserHandler().findUsersByQuery(query, UserStatus.ANY);
        int usersLength = users.getSize();
        return usersLength > 1 || usersLength == 1 && !StringUtils.equals((CharSequence)((User[])users.load(0, 1))[0].getUserName(), (CharSequence)username);
    }

    private Group getExternalsGroup() throws Exception {
        if (this.externalsGroup == null) {
            this.externalsGroup = this.organizationService.getGroupHandler().findGroupById(EXTERNALS_GROUP);
        }
        return this.externalsGroup;
    }

    private MembershipType getMemberMembershipType() throws Exception {
        if (this.memberMembershipType == null) {
            this.memberMembershipType = this.organizationService.getMembershipTypeHandler().findMembershipType("member");
        }
        return this.memberMembershipType;
    }

    @Generated
    public void setIdentityManager(IdentityManager identityManager) {
        this.identityManager = identityManager;
    }

    @Generated
    public void setOrganizationService(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    @Generated
    public void setProfilePropertyService(ProfilePropertyService profilePropertyService) {
        this.profilePropertyService = profilePropertyService;
    }

    @Generated
    public void setLocaleConfigService(LocaleConfigService localeConfigService) {
        this.localeConfigService = localeConfigService;
    }

    @Generated
    public void setPasswordRecoveryService(PasswordRecoveryService passwordRecoveryService) {
        this.passwordRecoveryService = passwordRecoveryService;
    }

    @Generated
    public void setUploadService(UploadService uploadService) {
        this.uploadService = uploadService;
    }

    static {
        UserImportService.ajc$preClinit();
        SYSTEM_PARENT_MULTIVALUED_FIELDS = Arrays.asList("user", "phones", "ims", "urls", "manager");
        LOG = ExoLogger.getLogger(UserImportService.class);
        STANDARD_FIELDS = List.of(USER_NAME_FIELD, PASSWORD_FIELD, TYPE_FIELD, GROUPS_FIELD, ABOUT_ME_FIELD, TIME_ZONE_FIELD, ENABLED_FIELD);
        NOT_PROPERTY_FIELDS = List.of(USER_NAME_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, PASSWORD_FIELD, EMAIL_FIELD, GROUPS_FIELD, ENABLED_FIELD, TYPE_FIELD);
        USERNAME_VALIDATOR = new UserFieldValidator(USER_NAME_FIELD, true, false);
        EMAIL_VALIDATOR = new UserFieldValidator(EMAIL_FIELD, false, false);
        LASTNAME_VALIDATOR = new UserFieldValidator(LAST_NAME_FIELD, false, true);
        FIRSTNAME_VALIDATOR = new UserFieldValidator(FIRST_NAME_FIELD, false, true);
        PASSWORD_VALIDATOR = new UserFieldValidator(PASSWORD_FIELD, false, false, 8, 255);
        USER_FIELD_VALIDATORS = Arrays.asList(USERNAME_VALIDATOR, EMAIL_VALIDATOR, LASTNAME_VALIDATOR, FIRSTNAME_VALIDATOR, PASSWORD_VALIDATOR);
        USER_FIELD_NO_PASSWORD_VALIDATORS = Arrays.asList(USERNAME_VALIDATOR, EMAIL_VALIDATOR, LASTNAME_VALIDATOR, FIRSTNAME_VALIDATOR);
    }

    static final /* synthetic */ void importUsersTransactional_aroundBody0(UserImportService ajc$this, String fileLocation, UserImportResult userImportResult, String modifierUsername, Locale locale, String url, JoinPoint joinPoint) {
        ajc$this.importUsers(fileLocation, userImportResult, modifierUsername, locale, url);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserImportService.java", UserImportService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "importUsersTransactional", "io.meeds.social.core.identity.service.UserImportService", "java.lang.String:io.meeds.social.core.identity.model.UserImportResult:java.lang.String:java.util.Locale:java.lang.String", "fileLocation:userImportResult:modifierUsername:locale:url", "", "void"), 275);
    }
}

