/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.storage.dao.jpa.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.MapJoin;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.SetJoin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.search.ExtendProfileFilter;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity;
import org.exoplatform.social.core.jpa.storage.entity.IdentityEntity_;
import org.exoplatform.social.core.jpa.storage.entity.ProfileExperienceEntity_;

public class ProfileQueryBuilder {
    ExtendProfileFilter filter;

    private ProfileQueryBuilder() {
    }

    public static ProfileQueryBuilder builder() {
        return new ProfileQueryBuilder();
    }

    public ProfileQueryBuilder withFilter(ExtendProfileFilter filter) {
        this.filter = filter;
        return this;
    }

    public TypedQuery[] build(EntityManager em) {
        TypedQuery<IdentityEntity> select = this.buildListQuery(em);
        TypedQuery<Long> count = this.buildCountquery(em);
        return new TypedQuery[]{select, count};
    }

    private TypedQuery<Long> buildCountquery(EntityManager em) {
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root identityCountQuery = countQuery.from(IdentityEntity.class);
        countQuery.select((Selection)criteriaBuilder.countDistinct((Expression)identityCountQuery)).where(this.buildPredicates(criteriaBuilder, (Root<IdentityEntity>)identityCountQuery));
        return em.createQuery(countQuery);
    }

    private TypedQuery<IdentityEntity> buildListQuery(EntityManager em) {
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery listQuery = criteriaBuilder.createQuery(IdentityEntity.class);
        Root identityListQuery = listQuery.from(IdentityEntity.class);
        listQuery.select((Selection)identityListQuery).distinct(true).where(this.buildPredicates(criteriaBuilder, (Root<IdentityEntity>)identityListQuery));
        return em.createQuery(listQuery);
    }

    private Predicate[] buildPredicates(CriteriaBuilder cb, Root<IdentityEntity> identityListQuery) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (this.filter != null) {
            String all;
            if (this.filter.isExcludeDeleted()) {
                predicates.add(cb.isFalse((Expression)identityListQuery.get(IdentityEntity_.deleted)));
            }
            if (this.filter.isExcludeDisabled()) {
                predicates.add(cb.isTrue((Expression)identityListQuery.get(IdentityEntity_.enabled)));
            }
            if (CollectionUtils.isNotEmpty(this.filter.getIdentityIds())) {
                predicates.add(identityListQuery.get(IdentityEntity_.id).in(this.filter.getIdentityIds()));
            }
            if (CollectionUtils.isNotEmpty((Collection)this.filter.getRemoteIds())) {
                predicates.add(identityListQuery.get(IdentityEntity_.remoteId).in((Collection)this.filter.getRemoteIds()));
            }
            if (this.filter.getProviderId() != null && !this.filter.getProviderId().isEmpty()) {
                predicates.add(cb.equal((Expression)identityListQuery.get(IdentityEntity_.providerId), (Object)this.filter.getProviderId()));
            }
            SetJoin experience = null;
            List<Identity> excludes = this.filter.getExcludedIdentityList();
            if (CollectionUtils.isNotEmpty(excludes)) {
                ArrayList<Long> ids = new ArrayList<Long>(excludes.size());
                for (Identity id : excludes) {
                    ids.add(Long.parseLong(id.getId()));
                }
                predicates.add(cb.not((Expression)identityListQuery.get(IdentityEntity_.id).in(ids)));
            }
            if ((all = this.filter.getAll()) == null || all.trim().isEmpty()) {
                String val;
                name = this.filter.getName();
                if (name != null && !name.isEmpty()) {
                    name = this.processLikeString(name);
                    MapJoin properties = identityListQuery.join(IdentityEntity_.properties, JoinType.LEFT);
                    predicates.add(cb.and((Expression)cb.like(cb.lower((Expression)properties.value()), name), (Expression)properties.key().in(Arrays.asList("firstName", "lastName", "fullName"))));
                }
                if ((val = this.filter.getPosition()) != null && !val.isEmpty()) {
                    val = this.processLikeString(val);
                    Predicate[] p = new Predicate[2];
                    MapJoin properties = identityListQuery.join(IdentityEntity_.properties, JoinType.LEFT);
                    p[1] = cb.and((Expression)cb.like(cb.lower((Expression)properties.value()), val), (Expression)cb.equal((Expression)properties.key(), (Object)"position"));
                    if (experience == null) {
                        experience = identityListQuery.join(IdentityEntity_.experiences, JoinType.LEFT);
                    }
                    p[0] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.position)), val);
                    predicates.add(cb.or(p));
                }
                if ((val = this.filter.getSkills()) != null && !val.isEmpty()) {
                    val = this.processLikeString(val);
                    if (experience == null) {
                        experience = identityListQuery.join(IdentityEntity_.experiences, JoinType.LEFT);
                    }
                    predicates.add(cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.skills)), val));
                }
                if ((val = this.filter.getCompany()) != null && !val.isEmpty()) {
                    val = this.processLikeString(val);
                    if (experience == null) {
                        experience = identityListQuery.join(IdentityEntity_.experiences, JoinType.LEFT);
                    }
                    predicates.add(cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.company)), val));
                }
            } else {
                name = this.filter.getName();
                all = this.processLikeString(all).toLowerCase();
                Predicate[] p = new Predicate[5];
                MapJoin properties = identityListQuery.join(IdentityEntity_.properties, JoinType.LEFT);
                p[0] = cb.and((Expression)cb.like(cb.lower((Expression)properties.value()), name), (Expression)properties.key().in(Arrays.asList("firstName", "lastName", "fullName")));
                if (experience == null) {
                    experience = identityListQuery.join(IdentityEntity_.experiences, JoinType.LEFT);
                }
                p[1] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.position)), all);
                p[2] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.skills)), all);
                p[3] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.company)), all);
                p[4] = cb.like(cb.lower((Expression)experience.get(ProfileExperienceEntity_.description)), all);
                predicates.add(cb.or(p));
            }
        }
        Predicate[] pds = predicates.toArray(new Predicate[predicates.size()]);
        return pds;
    }

    private String processLikeString(String s) {
        return "%" + s.toLowerCase() + "%";
    }
}

