/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.listeners;

import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.MatrixUserPermission;
import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MatrixSpaceListener
extends SpaceListenerPlugin {
    private static final Log LOG = ExoLogger.getLogger(MatrixSpaceListener.class);
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    IdentityManager identityManager;

    @PostConstruct
    public void init() {
        this.spaceService.registerSpaceListenerPlugin((SpaceListenerPlugin)this);
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        try {
            String matrixRoomId = this.matrixService.createRoom(space);
            String adminOfMatrix = PropertyManager.getProperty((String)"meeds.matrix.user.name");
            if (StringUtils.isNotBlank((CharSequence)matrixRoomId)) {
                ArrayList<String> members = new ArrayList<String>(Arrays.asList(space.getMembers()));
                for (String manager : space.getManagers()) {
                    String matrixIdOfUser = this.matrixService.getMatrixIdForUser(manager);
                    if (!StringUtils.isNotBlank((CharSequence)matrixIdOfUser) || matrixIdOfUser.equals(adminOfMatrix) || !StringUtils.isNotBlank((CharSequence)matrixRoomId)) continue;
                    this.matrixService.joinUserToRoom(matrixRoomId, matrixIdOfUser);
                    this.updateMemberRoleInSpace(space, matrixIdOfUser, "50");
                    members.remove(manager);
                }
                for (String member : members) {
                    String matrixIdOfUser = this.matrixService.getMatrixIdForUser(member);
                    if (!StringUtils.isNotBlank((CharSequence)matrixIdOfUser) || matrixIdOfUser.equals(adminOfMatrix) || !StringUtils.isNotBlank((CharSequence)matrixRoomId)) continue;
                    this.matrixService.joinUserToRoom(matrixRoomId, matrixIdOfUser);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOG.error("Matrix integration: Could not create a room for space {}", new Object[]{space.getDisplayName(), e});
        }
    }

    public void spaceRenamed(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String spaceDisplayName = space.getDisplayName();
        Room room = this.matrixService.getRoomBySpace(space);
        if (room != null && StringUtils.isNotBlank((CharSequence)room.getRoomId())) {
            try {
                this.matrixService.renameRoom(room.getRoomId(), spaceDisplayName);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.error("Could not rename the room linked to the space {}", new Object[]{space.getDisplayName(), e});
            }
        }
    }

    public void joined(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String userId = event.getTarget();
        String[] restrictedGroupOfUsers = this.matrixService.getRestrictedGroups();
        String matrixUserAdmin = PropertyManager.getProperty((String)"meeds.matrix.user.name");
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(userId);
        try {
            Room room;
            if (StringUtils.isBlank((CharSequence)matrixIdOfUser) && (restrictedGroupOfUsers == null || restrictedGroupOfUsers.length == 0 || this.matrixService.isUserMemberOfGroups(userId, restrictedGroupOfUsers)) && !userId.equals(matrixUserAdmin)) {
                Identity user = this.identityManager.getOrCreateUserIdentity(userId);
                matrixIdOfUser = this.matrixService.saveUserAccount(user, true);
            }
            if ((room = this.matrixService.getRoomBySpace(space)) != null && StringUtils.isNotBlank((CharSequence)room.getRoomId()) && StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) {
                this.matrixService.joinUserToRoom(room.getRoomId(), matrixIdOfUser);
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOG.error("Could not join the user {} to the room of the space {} on Matrix", new Object[]{userId, space.getDisplayName(), e});
        }
    }

    public void left(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String userId = event.getTarget();
        Room room = this.matrixService.getRoomBySpace(space);
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(userId);
        if (room != null && StringUtils.isNotBlank((CharSequence)room.getRoomId()) && StringUtils.isNotBlank((CharSequence)matrixIdOfUser)) {
            try {
                this.matrixService.kickUserFromRoom(room.getRoomId(), matrixIdOfUser, "The user is no more member of the space %s, thus he was kicked out of this room!".formatted(space.getDisplayName()));
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.error("Could not kick the user {] from the room of the space {}", new Object[]{userId, space.getDisplayName(), e});
            }
        }
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(event.getTarget());
        String adminOfMatrix = PropertyManager.getProperty((String)"meeds.matrix.user.name");
        if (!adminOfMatrix.equals(matrixIdOfUser)) {
            this.updateMemberRoleInSpace(space, matrixIdOfUser, "50");
        }
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
        String adminOfMatrix;
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        String matrixIdOfUser = this.matrixService.getMatrixIdForUser(event.getTarget());
        if (!matrixIdOfUser.equals(adminOfMatrix = PropertyManager.getProperty((String)"meeds.matrix.user.name"))) {
            this.updateMemberRoleInSpace(space, matrixIdOfUser, "0");
        }
    }

    private boolean updateMemberRoleInSpace(Space space, String matrixIdOfUser, String userRole) {
        Room room = this.matrixService.getRoomBySpace(space);
        if (room != null && StringUtils.isNotBlank((CharSequence)room.getRoomId())) {
            try {
                MatrixRoomPermissions matrixRoomPermissions = this.matrixService.getRoomSettings(room.getRoomId());
                if (matrixRoomPermissions != null) {
                    if ("0".equals(userRole)) {
                        for (MatrixUserPermission userPermission : matrixRoomPermissions.getUsers()) {
                            String fullMatrixUserId = "@%s:%s".formatted(matrixIdOfUser, PropertyManager.getProperty((String)"meeds.matrix.server.name"));
                            if (!fullMatrixUserId.equals(userPermission.getUserName())) continue;
                            userPermission.setUserRole(userRole);
                        }
                    } else {
                        MatrixUserPermission matrixUserPermission = new MatrixUserPermission("@%s:%s".formatted(matrixIdOfUser, PropertyManager.getProperty((String)"meeds.matrix.server.name")), userRole);
                        matrixRoomPermissions.getUsers().add(matrixUserPermission);
                    }
                }
                return this.matrixService.updateRoomSettings(room.getRoomId(), matrixRoomPermissions);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.error("Could not update member roles in the space {}", new Object[]{space.getDisplayName(), e});
            }
        }
        return false;
    }

    public void spaceAvatarEdited(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        try {
            Room room = this.matrixService.getRoomBySpace(space);
            if (room != null) {
                String roomId = room.getRoomId();
                this.matrixService.updateRoomAvatar(space, roomId);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not update the room avatar on Matrix", (Throwable)e);
        }
    }

    public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        Room room = this.matrixService.getRoomBySpace(space);
        try {
            if (room != null && StringUtils.isNotBlank((CharSequence)room.getRoomId())) {
                this.matrixService.updateRoomDescription(room.getRoomId(), space.getDescription());
            }
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOG.error("Could not save the description of space {} ", new Object[]{space.getDisplayName(), e});
        }
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
        if (!this.matrixService.isServiceAvailable()) {
            return;
        }
        Space space = event.getSpace();
        Room room = this.matrixService.getRoomBySpace(space);
        if (room != null && StringUtils.isNotBlank((CharSequence)room.getRoomId())) {
            try {
                this.matrixService.deleteRoom(room.getRoomId());
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                LOG.error("Could not delete the room {} linked to the space {}", new Object[]{room.getRoomId(), space.getDisplayName()});
            }
        }
    }
}

