/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.model.SectionTemplateDetail;
import io.meeds.layout.service.SectionTemplateService;
import io.meeds.layout.service.injection.SectionTemplateImportService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.mop.page.PageKey;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/sections"})
@Tag(name="/layout/rest/sections", description="Managing section templates")
public class SectionTemplateRest {
    @Autowired
    private SectionTemplateService sectionTemplateService;
    @Autowired
    private SectionTemplateImportService sectionTemplateImportService;

    @GetMapping
    @Secured(value={"users"})
    @Operation(summary="Retrieve section templates", method="GET", description="This retrieves section templates")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled")})
    public List<SectionTemplateDetail> getSectionTemplates(HttpServletRequest request) {
        return this.sectionTemplateService.getSectionTemplates(request.getLocale());
    }

    @GetMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Retrieve a section template designated by its id", method="GET", description="This will retrieve a section template designated by its id")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not found")})
    public SectionTemplateDetail getSectionTemplate(HttpServletRequest request, @Parameter(description="Section template identifier") @PathVariable(value="id") long id) {
        try {
            return this.sectionTemplateService.getSectionTemplate(id, request.getLocale());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
    }

    @PostMapping
    @Secured(value={"users"})
    @Operation(summary="Create a section template", method="POST", description="This creates a new section template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden")})
    public SectionTemplate createSectionTemplate(HttpServletRequest request, @RequestBody SectionTemplate sectionTemplate) {
        try {
            return this.sectionTemplateService.createSectionTemplate(sectionTemplate, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PostMapping(value={"container/{storageId}"}, consumes={"application/x-www-form-urlencoded"})
    @Secured(value={"users"})
    @Operation(summary="Create a section template based on an existing container", method="POST", description="This creates a new section template based on an existing section identified by its container storage identifier")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Not Found"), @ApiResponse(responseCode="403", description="Forbidden")})
    public SectionTemplate saveAsSectionTemplate(HttpServletRequest request, @Parameter(description="Container Storage identifier") @PathVariable(value="storageId") long containerId, @Parameter(description="Page reference") @RequestParam(value="pageRef") String pageRef) {
        try {
            return this.sectionTemplateService.saveAsSectionTemplate(PageKey.parse((String)pageRef), containerId, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PutMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Update a section template", method="PUT", description="This updates an existing section template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void updateSectionTemplate(HttpServletRequest request, @Parameter(description="Section template identifier") @PathVariable(value="id") long id, @RequestBody SectionTemplate sectionTemplate) {
        try {
            sectionTemplate.setId(id);
            this.sectionTemplateService.updateSectionTemplate(sectionTemplate, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PutMapping(value={"{id}/restore"})
    @Secured(value={"users"})
    @Operation(summary="Restores a system Section template", method="PUT", description="This restores a system Section template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Bad request"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void restoreSectionTemplate(HttpServletRequest request, @Parameter(description="Section template identifier") @PathVariable(value="id") long id) {
        try {
            this.sectionTemplateImportService.restoreSectionTemplate(id, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    @GetMapping(value={"{id}/nodeId"})
    @Secured(value={"users"})
    @Operation(summary="Retrieves the Navigation Node identifier in order to edit the section template", method="GET", description="Retrieves the Navigation Node identifier in order to edit the section template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public long generateSectionTemplateNodeId(HttpServletRequest request, @Parameter(description="Section template identifier") @PathVariable(value="id") long id) {
        try {
            return this.sectionTemplateService.generateSectionTemplateNodeId(id, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @GetMapping(value={"{id}/content"})
    @Secured(value={"users"})
    @Operation(summary="Retrieves the Edited Section Template Page Content", method="GET", description="Retrieves the container content of Section template switch page edited using layout editor")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public String generateSectionTemplateContent(HttpServletRequest request, @Parameter(description="Section template identifier") @PathVariable(value="id") long id) {
        try {
            return this.sectionTemplateService.generateSectionTemplateContent(id, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @DeleteMapping(value={"{id}"})
    @Secured(value={"users"})
    @Operation(summary="Deletes a section template", method="DELETE", description="This deletes an existing section template")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not found")})
    public void deleteSectionTemplate(HttpServletRequest request, @Parameter(description="Section template identifier") @PathVariable(value="id") long id) {
        try {
            this.sectionTemplateService.deleteSectionTemplate(id, request.getRemoteUser());
        }
        catch (ObjectNotFoundException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }
}

