/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage.cache;

import java.io.Serializable;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.dao.NavigationDAO;
import org.exoplatform.portal.mop.dao.NodeDAO;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.navigation.NavigationData;
import org.exoplatform.portal.mop.navigation.NavigationState;
import org.exoplatform.portal.mop.navigation.NodeData;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.mop.storage.DescriptionStorage;
import org.exoplatform.portal.mop.storage.NavigationStorageImpl;
import org.exoplatform.portal.mop.storage.cache.model.NavigationCacheSelector;
import org.exoplatform.portal.mop.storage.cache.model.NavigationDataCacheSelector;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CacheNavigationStorage
extends NavigationStorageImpl {
    private static final Log LOG = ExoLogger.getExoLogger(CacheNavigationStorage.class);
    public static final String NAVIGATION_CACHE_NAME = "portal.NavigationService";
    public static final String NODE_CACHE_NAME = "portal.NavigationNode";
    private final FutureExoCache<SiteKey, NavigationData, Object> navigationFutureCache;
    private final ExoCache<SiteKey, NavigationData> navigationCache;
    private final FutureExoCache<Long, NodeData, Object> nodeFutureCache;
    private final ExoCache<Long, NodeData> nodeCache;

    public CacheNavigationStorage(CacheService cacheService, DescriptionStorage descriptionStorage, NavigationDAO navigationDAO, SiteDAO siteDAO, NodeDAO nodeDAO, PageDAO pageDAO) {
        super(descriptionStorage, navigationDAO, siteDAO, nodeDAO, pageDAO);
        this.navigationCache = cacheService.getCacheInstance(NAVIGATION_CACHE_NAME);
        this.navigationFutureCache = new FutureExoCache((Loader)new Loader<SiteKey, NavigationData, Object>(){

            public NavigationData retrieve(Object context, SiteKey siteKey) throws Exception {
                NavigationData navigationData = CacheNavigationStorage.super.loadNavigationData(siteKey);
                return navigationData == null ? NavigationData.NULL_OBJECT : navigationData;
            }
        }, this.navigationCache);
        this.nodeCache = cacheService.getCacheInstance(NODE_CACHE_NAME);
        this.nodeFutureCache = new FutureExoCache((Loader)new Loader<Long, NodeData, Object>(){

            public NodeData retrieve(Object context, Long nodeId) throws Exception {
                return CacheNavigationStorage.super.loadNode(nodeId);
            }
        }, this.nodeCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData[] createNode(Long parentId, Long previousId, String name, NodeState state, Integer index) {
        try {
            NodeData[] nodeDataArray = super.createNode(parentId, previousId, name, state, index);
            return nodeDataArray;
        }
        finally {
            this.nodeFutureCache.remove((Serializable)parentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData destroyNode(Long targetId) {
        NodeData nodeData = this.loadNode(targetId);
        try {
            NodeData nodeData2 = super.destroyNode(targetId);
            return nodeData2;
        }
        finally {
            this.clearNodeCache(nodeData);
        }
    }

    @Override
    public NodeData loadNode(Long nodeId) {
        return (NodeData)this.nodeFutureCache.get(null, (Object)nodeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData[] moveNode(Long targetId, Long fromId, Long toId, Long previousId) {
        NodeData nodeData = this.loadNode(targetId);
        NodeData fromNodeData = this.loadNode(fromId);
        NodeData toNodeData = this.loadNode(toId);
        try {
            NodeData[] nodeDataArray = super.moveNode(targetId, fromId, toId, previousId);
            return nodeDataArray;
        }
        finally {
            this.clearNodeCache(nodeData);
            this.clearNodeCache(fromNodeData);
            this.clearNodeCache(toNodeData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData[] renameNode(Long targetId, Long parentId, String name) {
        NodeData nodeData = this.loadNode(targetId);
        NodeData parentNodeData = this.loadNode(parentId);
        try {
            NodeData[] nodeDataArray = super.renameNode(targetId, parentId, name);
            return nodeDataArray;
        }
        finally {
            this.clearNodeCache(nodeData);
            this.clearNodeCache(parentNodeData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeData updateNode(Long targetId, NodeState state) {
        NodeData nodeData = this.loadNode(targetId);
        try {
            NodeData nodeData2 = super.updateNode(targetId, state);
            return nodeData2;
        }
        finally {
            this.clearNodeCache(nodeData);
        }
    }

    @Override
    public NavigationData loadNavigationData(SiteKey siteKey) {
        NavigationData navigationData = (NavigationData)this.navigationFutureCache.get(null, (Object)siteKey);
        return navigationData == null || navigationData.isNull() ? null : navigationData;
    }

    @Override
    public void saveNavigation(SiteKey key, NavigationState state) {
        try {
            super.saveNavigation(key, state);
        }
        finally {
            this.clearNavigationByKey(key);
            this.clearNodeCache(key);
        }
    }

    @Override
    public boolean destroyNavigation(SiteKey siteKey) {
        try {
            boolean bl = super.destroyNavigation(siteKey);
            return bl;
        }
        finally {
            this.clearNavigationByKey(siteKey);
            this.clearNodeCache(siteKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean destroyNavigation(NavigationData data) {
        try {
            boolean bl = super.destroyNavigation(data);
            return bl;
        }
        finally {
            if (data != null && data.getSiteKey() != null) {
                SiteKey siteKey = data.getSiteKey();
                this.clearNavigationByKey(siteKey);
                this.clearNodeCache(siteKey);
                if (data.getRootId() != null) {
                    this.clearNodeCache(Long.parseLong(data.getRootId()));
                }
            }
        }
    }

    public void clearNavigationByKey(SiteKey siteKey) {
        if (siteKey != null) {
            try {
                this.navigationCache.select((CachedObjectSelector)new NavigationCacheSelector(siteKey));
                this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(siteKey, null));
            }
            catch (Exception e) {
                LOG.error("Error clearing cache of navigation having site key {}", new Object[]{siteKey, e});
            }
        }
    }

    public void clearNodeCache(SiteKey siteKey) {
        try {
            this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(siteKey, null));
            this.navigationCache.select((CachedObjectSelector)new NavigationCacheSelector(siteKey));
        }
        catch (Exception e) {
            LOG.error("Error clearing cache of nodes of site {}", new Object[]{siteKey, e});
        }
    }

    public void clearNodeCache(Long nodeId) {
        try {
            this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(null, nodeId));
        }
        catch (Exception e) {
            LOG.error("Error clearing cache of node data with id", new Object[]{nodeId, e});
        }
    }

    public void clearNodeCache(NodeData nodeData) {
        if (nodeData != null) {
            try {
                SiteKey siteKey = nodeData.getState().getSiteKey();
                this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(siteKey, Long.parseLong(nodeData.getId())));
                if (nodeData.getParentId() != null) {
                    this.nodeCache.select((CachedObjectSelector)new NavigationDataCacheSelector(null, Long.parseLong(nodeData.getParentId())));
                }
                this.navigationCache.select((CachedObjectSelector)new NavigationCacheSelector(siteKey));
            }
            catch (Exception e) {
                LOG.error("Error clearing cache of node data with id {} of page {}", new Object[]{nodeData.getId(), nodeData.getName(), e});
            }
        }
    }
}

