/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.array;

import java.util.List;
import org.hibernate.dialect.function.array.ArrayConstructorFunction;
import org.hibernate.dialect.function.array.DdlTypeHelper;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;

public class PostgreSQLArrayConstructorFunction
extends ArrayConstructorFunction {
    public PostgreSQLArrayConstructorFunction(boolean list) {
        super(list, true);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        BasicPluralType pluralType;
        DomainType type;
        String arrayTypeName = null;
        if (returnType != null && (type = returnType.getSqmType()) instanceof BasicPluralType && PostgreSQLArrayConstructorFunction.needsArrayCasting((pluralType = (BasicPluralType)type).getElementType())) {
            arrayTypeName = DdlTypeHelper.getCastTypeName(returnType, walker.getSessionFactory().getTypeConfiguration());
            sqlAppender.append("cast(");
        }
        super.render(sqlAppender, sqlAstArguments, returnType, walker);
        if (arrayTypeName != null) {
            sqlAppender.appendSql(" as ");
            sqlAppender.appendSql(arrayTypeName);
            sqlAppender.appendSql(')');
        }
    }

    private static boolean needsArrayCasting(BasicType<?> elementType) {
        return elementType.getJdbcType().isString();
    }
}

