/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.twitter.gamification.plugin;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.AccessTokenRequestParams;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.github.scribejava.core.pkce.PKCE;
import com.github.scribejava.core.pkce.PKCECodeChallengeMethod;
import io.meeds.gamification.model.RemoteConnectorSettings;
import io.meeds.gamification.plugin.ConnectorPlugin;
import io.meeds.gamification.service.ConnectorService;
import io.meeds.gamification.service.ConnectorSettingService;
import io.meeds.oauth.exception.OAuthException;
import io.meeds.oauth.exception.OAuthExceptionCode;
import io.meeds.oauth.utils.HttpResponseContext;
import io.meeds.oauth.utils.OAuthUtils;
import io.meeds.twitter.gamification.model.TwitterAccessTokenContext;
import io.meeds.twitter.gamification.model.TwitterOAuth20Api;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TwitterConnectorPlugin
extends ConnectorPlugin {
    private static final Log LOG = ExoLogger.getLogger(TwitterConnectorPlugin.class);
    private static final String NAME = "twitter";
    private long remoteConnectorId;
    private OAuth20Service oAuthService;
    @Autowired
    private ConnectorSettingService connectorSettingService;
    @Autowired
    private ConnectorService connectorService;

    @PostConstruct
    public void initData() {
        this.connectorService.addPlugin((ConnectorPlugin)this);
    }

    public String validateToken(String accessToken) {
        RemoteConnectorSettings remoteConnectorSettings = this.connectorSettingService.getConnectorSettings(NAME);
        remoteConnectorSettings.setSecretKey(this.connectorSettingService.getConnectorSecretKey(NAME));
        if (StringUtils.isBlank((CharSequence)remoteConnectorSettings.getApiKey()) || StringUtils.isBlank((CharSequence)remoteConnectorSettings.getSecretKey())) {
            LOG.warn("Missing '{}' connector settings", new Object[]{NAME});
            return null;
        }
        try {
            PKCE pkce = new PKCE();
            pkce.setCodeChallenge("challenge");
            pkce.setCodeChallengeMethod(PKCECodeChallengeMethod.PLAIN);
            pkce.setCodeVerifier("challenge");
            AccessTokenRequestParams params = AccessTokenRequestParams.create((String)accessToken);
            params = params.pkceCodeVerifier(pkce.getCodeVerifier());
            OAuth2AccessToken oAuth2AccessToken = this.getOAuthService(remoteConnectorSettings).getAccessToken(params);
            TwitterAccessTokenContext twitterAccessTokenContext = new TwitterAccessTokenContext(oAuth2AccessToken);
            String twitterIdentifier = TwitterConnectorPlugin.fetchUsernameFromAccessToken(twitterAccessTokenContext);
            if (StringUtils.isBlank((CharSequence)twitterIdentifier)) {
                throw new OAuthException(OAuthExceptionCode.INVALID_STATE, "User Twitter identifier is empty");
            }
            return twitterIdentifier;
        }
        catch (IOException | InterruptedException e) {
            throw new OAuthException(OAuthExceptionCode.IO_ERROR, (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OAuthException(OAuthExceptionCode.UNKNOWN_ERROR, (Throwable)e);
        }
    }

    public String getConnectorName() {
        return NAME;
    }

    public String getName() {
        return NAME;
    }

    private OAuth20Service getOAuthService(RemoteConnectorSettings remoteConnectorSettings) {
        if (this.oAuthService == null || (long)remoteConnectorSettings.hashCode() != this.remoteConnectorId) {
            this.remoteConnectorId = remoteConnectorSettings.hashCode();
            this.oAuthService = new ServiceBuilder(remoteConnectorSettings.getApiKey()).apiSecret(remoteConnectorSettings.getSecretKey()).callback(remoteConnectorSettings.getRedirectUrl()).defaultScope("users.read tweet.read").build((DefaultApi20)TwitterOAuth20Api.instance());
        }
        return this.oAuthService;
    }

    private static String fetchUsernameFromAccessToken(TwitterAccessTokenContext accessToken) throws IOException {
        URL url = new URL("https://api.twitter.com/2/users/me");
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Authorization", "Bearer " + accessToken.getAccessToken());
        HttpResponseContext httpResponse = OAuthUtils.readUrlContent((URLConnection)connection);
        if (httpResponse.getResponseCode() == 200) {
            JSONObject jsonResponse = new JSONObject(httpResponse.getResponse());
            return jsonResponse.getJSONObject("data").getString("username");
        }
        throw new IOException("Error retrieving user information from Twitter." + httpResponse.getResponse());
    }
}

