/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.Internal;

public class SqlTypes {
    public static final int BIT = -7;
    public static final int TINYINT = -6;
    public static final int SMALLINT = 5;
    public static final int INTEGER = 4;
    public static final int BIGINT = -5;
    public static final int FLOAT = 6;
    public static final int REAL = 7;
    public static final int DOUBLE = 8;
    public static final int NUMERIC = 2;
    public static final int DECIMAL = 3;
    public static final int CHAR = 1;
    public static final int VARCHAR = 12;
    public static final int LONGVARCHAR = -1;
    public static final int LONG32VARCHAR = 4001;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int BINARY = -2;
    public static final int VARBINARY = -3;
    public static final int LONGVARBINARY = -4;
    public static final int LONG32VARBINARY = 4003;
    public static final int NULL = 0;
    public static final int OTHER = 1111;
    public static final int JAVA_OBJECT = 2000;
    public static final int DISTINCT = 2001;
    public static final int STRUCT = 2002;
    public static final int ARRAY = 2003;
    public static final int TABLE = 4000;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int REF = 2006;
    public static final int DATALINK = 70;
    public static final int BOOLEAN = 16;
    public static final int ROWID = -8;
    public static final int NCHAR = -15;
    public static final int NVARCHAR = -9;
    public static final int LONGNVARCHAR = -16;
    public static final int LONG32NVARCHAR = 4002;
    public static final int NCLOB = 2011;
    public static final int SQLXML = 2009;
    public static final int REF_CURSOR = 2012;
    public static final int TIME_WITH_TIMEZONE = 2013;
    public static final int TIMESTAMP_WITH_TIMEZONE = 2014;
    public static final int UUID = 3000;
    public static final int JSON = 3001;
    public static final int INET = 3002;
    public static final int TIMESTAMP_UTC = 3003;
    @Internal
    public static final int MATERIALIZED_BLOB = 3004;
    @Internal
    public static final int MATERIALIZED_CLOB = 3005;
    @Internal
    public static final int MATERIALIZED_NCLOB = 3006;
    public static final int TIME_UTC = 3007;
    public static final int INSTANT = 3008;
    public static final int LOCAL_DATE_TIME = 3009;
    public static final int LOCAL_DATE = 3010;
    public static final int LOCAL_TIME = 3011;
    public static final int OFFSET_DATE_TIME = 3012;
    public static final int OFFSET_TIME = 3013;
    public static final int ZONED_DATE_TIME = 3014;
    public static final int DURATION = 3015;
    public static final int STRUCT_ARRAY = 3016;
    public static final int STRUCT_TABLE = 3017;
    public static final int JSON_ARRAY = 3018;
    public static final int XML_ARRAY = 3019;
    public static final int INTERVAL_SECOND = 3100;
    public static final int GEOMETRY = 3200;
    public static final int POINT = 3201;
    public static final int GEOGRAPHY = 3250;
    public static final int ENUM = 6000;
    public static final int NAMED_ENUM = 6001;
    public static final int ORDINAL_ENUM = 6002;
    public static final int NAMED_ORDINAL_ENUM = 6003;
    public static final int VECTOR = 10000;
    public static final int VECTOR_INT8 = 10001;
    public static final int VECTOR_FLOAT32 = 10002;
    public static final int VECTOR_FLOAT64 = 10003;

    private SqlTypes() {
    }

    public static boolean isNumericType(int typeCode) {
        switch (typeCode) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringType(int typeCode) {
        switch (typeCode) {
            case -16: 
            case -15: 
            case -9: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCharacterOrClobType(int typeCode) {
        switch (typeCode) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCharacterType(int typeCode) {
        switch (typeCode) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isVarcharType(int typeCode) {
        switch (typeCode) {
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isVarbinaryType(int typeCode) {
        switch (typeCode) {
            case -4: 
            case -3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinaryType(int typeCode) {
        switch (typeCode) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return true;
            }
        }
        return false;
    }

    public static boolean isNumericOrDecimal(int typeCode) {
        switch (typeCode) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static boolean isFloatOrRealOrDouble(int typeCode) {
        switch (typeCode) {
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntegral(int typeCode) {
        switch (typeCode) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Internal
    public static boolean isSmallOrTinyInt(int typeCode) {
        switch (typeCode) {
            case -6: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTemporalType(int typeCode) {
        switch (typeCode) {
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: 
            case 3003: 
            case 3007: 
            case 3008: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIntervalType(int typeCode) {
        return typeCode == 3100;
    }

    public static boolean isDurationType(int typeCode) {
        return typeCode == 3015;
    }

    public static boolean hasDatePart(int typeCode) {
        switch (typeCode) {
            case 91: 
            case 93: 
            case 2014: 
            case 3003: {
                return true;
            }
        }
        return false;
    }

    public static boolean hasTimePart(int typeCode) {
        switch (typeCode) {
            case 92: 
            case 93: 
            case 2013: 
            case 2014: 
            case 3003: 
            case 3007: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSpatialType(int typeCode) {
        switch (typeCode) {
            case 3200: 
            case 3201: 
            case 3250: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEnumType(int typeCode) {
        switch (typeCode) {
            case 6000: 
            case 6001: {
                return true;
            }
        }
        return false;
    }
}

