/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration;

import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.social.attachment.model.ObjectAttachmentId;
import org.exoplatform.task.service.TaskService;

public class TaskAttachmentLoggingListener
extends Listener<String, ObjectAttachmentId> {
    public static final String ATTACHMENT_TASK_OBJECT_TYPE = "task";
    public static final String ATTACHMENT_CREATED_EVENT = "attachment.created";
    public static final String ATTACHMENT_DELETED_EVENT = "attachment.deleted";
    private final TaskService taskService;

    public TaskAttachmentLoggingListener(TaskService taskService) {
        this.taskService = taskService;
    }

    public void onEvent(Event<String, ObjectAttachmentId> event) throws Exception {
        String username = (String)event.getSource();
        ObjectAttachmentId objectAttachment = (ObjectAttachmentId)event.getData();
        if (objectAttachment != null && ATTACHMENT_TASK_OBJECT_TYPE.equals(objectAttachment.getObjectType())) {
            switch (event.getEventName()) {
                case "attachment.created": {
                    this.taskService.addTaskLog(Long.parseLong(objectAttachment.getObjectId()), username, "attach_image", "");
                    break;
                }
                case "attachment.deleted": {
                    this.taskService.addTaskLog(Long.parseLong(objectAttachment.getObjectId()), username, "delete_image", "");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected listener event name: " + event.getEventName());
                }
            }
        }
    }
}

