/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.impl;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class StorageUtils {
    public static final String ASTERISK_STR = "*";
    public static final String EMPTY_STR = "";
    public static final DateTimeFormatter RFC_3339_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SSS][XXX]").withResolverStyle(ResolverStyle.LENIENT);

    public static <T> List<T> subList(List<T> list, int startIndex, int toIndex) {
        int totalSize = list.size();
        if (startIndex >= totalSize) {
            return Collections.emptyList();
        }
        if (toIndex >= totalSize) {
            toIndex = totalSize;
        }
        return list.subList(startIndex, toIndex);
    }

    public static String toRFC3339Date(Date dateTime) {
        if (dateTime == null) {
            return null;
        }
        ZonedDateTime zonedDateTime = dateTime.toInstant().atZone(ZoneOffset.UTC);
        return zonedDateTime.format(RFC_3339_FORMATTER);
    }

    public static Date parseRFC3339Date(String dateString) {
        if (StringUtils.isBlank((CharSequence)dateString)) {
            return null;
        }
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateString, RFC_3339_FORMATTER);
        return Date.from(zonedDateTime.toInstant());
    }
}

