/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.mop.plugin;

import io.meeds.portal.plugin.AclPlugin;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.security.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SiteAclPlugin
implements AclPlugin {
    public static final String OBJECT_TYPE = "site";
    @Autowired
    private PortalContainer container;
    private LayoutService layoutService;
    private UserACL userAcl;

    @PostConstruct
    public void init() {
        this.layoutService = (LayoutService)this.container.getComponentInstanceOfType(LayoutService.class);
        this.userAcl = (UserACL)this.container.getComponentInstanceOfType(UserACL.class);
        this.userAcl.addAclPlugin(this);
    }

    @Override
    public String getObjectType() {
        return OBJECT_TYPE;
    }

    @Override
    public boolean hasPermission(String siteId, String permissionType, Identity identity) {
        if (!StringUtils.isNumeric((CharSequence)siteId)) {
            throw new IllegalArgumentException(String.format("SiteId '%s' isn't numeric", siteId));
        }
        PortalConfig portalConfig = this.layoutService.getPortalConfig(Long.parseLong(siteId));
        if (portalConfig == null) {
            return this.userAcl.isAdministrator(identity);
        }
        if (StringUtils.equals((CharSequence)permissionType, (CharSequence)"VIEW")) {
            return this.hasAccessPermission(portalConfig, identity) || this.hasEditPermission(portalConfig, identity);
        }
        if (StringUtils.equalsAny((CharSequence)permissionType, (CharSequence[])new CharSequence[]{"EDIT", "DELETE"})) {
            return this.hasEditPermission(portalConfig, identity);
        }
        return false;
    }

    private boolean hasEditPermission(PortalConfig portalConfig, Identity identity) {
        return this.userAcl.hasEditPermission(identity, portalConfig.getType(), portalConfig.getName(), portalConfig.getEditPermission());
    }

    private boolean hasAccessPermission(PortalConfig portalConfig, Identity identity) {
        return this.userAcl.hasAccessPermission(identity, portalConfig.getType(), portalConfig.getName(), portalConfig.getAccessPermissions());
    }
}

