/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.task.domain.UserSetting;
import org.exoplatform.task.dto.StatusDto;

public class ProjectDto
implements Serializable {
    private static final Log LOG = ExoLogger.getLogger(ProjectDto.class);
    private long id;
    private String name;
    private String description;
    private String color;
    private Set<StatusDto> status;
    private Set<String> manager;
    private Set<String> participator;
    private Date dueDate;
    private Long lastModifiedDate;
    private ProjectDto parent;
    private List<ProjectDto> children;
    private Set<UserSetting> hiddenOn;
    private String spaceName;

    public ProjectDto(String name, String description, HashSet<StatusDto> statuses, Set<String> managers, Set<String> participators) {
        this.name = name;
        this.description = description;
        this.status = statuses;
        this.manager = managers;
        this.participator = participators;
    }

    public ProjectDto clone(boolean cloneTask) {
        ProjectDto project = new ProjectDto();
        project.setId(this.getId());
        project.setName(this.getName());
        project.setDescription(this.getDescription());
        project.setColor(this.getColor());
        project.setDueDate(this.getDueDate());
        if (this.getParent() != null) {
            project.setParent(this.getParent().clone(false));
        }
        project.status = new HashSet<StatusDto>();
        project.children = new LinkedList<ProjectDto>();
        return project;
    }

    public boolean canView(Identity user) {
        HashSet<String> permissions = new HashSet<String>();
        Set<String> Participants = this.getParticipator();
        Set<String> managers = this.getManager();
        if (Participants != null) {
            permissions.addAll(Participants);
        }
        if (managers != null) {
            permissions.addAll(managers);
        }
        return this.hasPermission(user, permissions);
    }

    public boolean canEdit(Identity user) {
        return this.hasPermission(user, this.getManager());
    }

    private boolean hasPermission(Identity user, Set<String> permissions) {
        if (permissions.contains(user.getUserId())) {
            return true;
        }
        HashSet<MembershipEntry> memberships = new HashSet<MembershipEntry>();
        for (String per : permissions) {
            MembershipEntry entry = MembershipEntry.parse((String)per);
            if (entry == null) continue;
            memberships.add(entry);
        }
        for (MembershipEntry entry : user.getMemberships()) {
            if (!memberships.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProjectDto)) {
            return false;
        }
        ProjectDto other = (ProjectDto)obj;
        return this.getId() == other.getId();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getColor() {
        return this.color;
    }

    @Generated
    public Set<StatusDto> getStatus() {
        return this.status;
    }

    @Generated
    public Set<String> getManager() {
        return this.manager;
    }

    @Generated
    public Set<String> getParticipator() {
        return this.participator;
    }

    @Generated
    public Date getDueDate() {
        return this.dueDate;
    }

    @Generated
    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    @Generated
    public ProjectDto getParent() {
        return this.parent;
    }

    @Generated
    public List<ProjectDto> getChildren() {
        return this.children;
    }

    @Generated
    public Set<UserSetting> getHiddenOn() {
        return this.hiddenOn;
    }

    @Generated
    public String getSpaceName() {
        return this.spaceName;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setColor(String color) {
        this.color = color;
    }

    @Generated
    public void setStatus(Set<StatusDto> status) {
        this.status = status;
    }

    @Generated
    public void setManager(Set<String> manager) {
        this.manager = manager;
    }

    @Generated
    public void setParticipator(Set<String> participator) {
        this.participator = participator;
    }

    @Generated
    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    @Generated
    public void setLastModifiedDate(Long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    @Generated
    public void setParent(ProjectDto parent) {
        this.parent = parent;
    }

    @Generated
    public void setChildren(List<ProjectDto> children) {
        this.children = children;
    }

    @Generated
    public void setHiddenOn(Set<UserSetting> hiddenOn) {
        this.hiddenOn = hiddenOn;
    }

    @Generated
    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    @Generated
    public String toString() {
        return "ProjectDto(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", color=" + this.getColor() + ", status=" + String.valueOf(this.getStatus()) + ", manager=" + String.valueOf(this.getManager()) + ", participator=" + String.valueOf(this.getParticipator()) + ", dueDate=" + String.valueOf(this.getDueDate()) + ", lastModifiedDate=" + this.getLastModifiedDate() + ", parent=" + String.valueOf(this.getParent()) + ", children=" + String.valueOf(this.getChildren()) + ", hiddenOn=" + String.valueOf(this.getHiddenOn()) + ", spaceName=" + this.getSpaceName() + ")";
    }

    @Generated
    public ProjectDto() {
    }
}

