/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.service.impl;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.task.dao.DAOHandler;
import org.exoplatform.task.dto.ProjectDto;
import org.exoplatform.task.dto.StatusDto;
import org.exoplatform.task.exception.EntityNotFoundException;
import org.exoplatform.task.exception.NotAllowedOperationOnEntityException;
import org.exoplatform.task.service.StatusService;
import org.exoplatform.task.service.impl.StatusServiceImpl$AjcClosure1;
import org.exoplatform.task.service.impl.StatusServiceImpl$AjcClosure11;
import org.exoplatform.task.service.impl.StatusServiceImpl$AjcClosure3;
import org.exoplatform.task.service.impl.StatusServiceImpl$AjcClosure5;
import org.exoplatform.task.service.impl.StatusServiceImpl$AjcClosure7;
import org.exoplatform.task.service.impl.StatusServiceImpl$AjcClosure9;
import org.exoplatform.task.storage.ProjectStorage;
import org.exoplatform.task.storage.StatusStorage;

@Singleton
public class StatusServiceImpl
implements StatusService {
    @Inject
    private DAOHandler daoHandler;
    @Inject
    private StatusStorage statusStorage;
    @Inject
    private ProjectStorage projectStorage;
    private ListenerService listenerService;
    private String[] DEFAULT_STATUS = new String[]{"ToDo", "InProgress", "WaitingOn", "Done"};
    private static Log LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public StatusServiceImpl(DAOHandler daoHandler, StatusStorage statusStorage, ProjectStorage projectStorage, ListenerService listenerService) {
        this.daoHandler = daoHandler;
        this.statusStorage = statusStorage;
        this.projectStorage = projectStorage;
        this.listenerService = listenerService;
    }

    public StatusServiceImpl(DAOHandler daoHandler) {
        String status = PropertyManager.getProperty((String)"exo.tasks.default.workflow");
        if (status != null) {
            LinkedList<String> stList = new LinkedList<String>();
            for (String s : status.split(",")) {
                if ((s = s.trim()).isEmpty()) continue;
                stList.add(s);
            }
            if (!stList.isEmpty()) {
                this.DEFAULT_STATUS = stList.toArray(new String[stList.size()]);
            }
        }
        this.daoHandler = daoHandler;
    }

    private List<String> getDefaultStatus() {
        return Arrays.asList(this.DEFAULT_STATUS);
    }

    @Override
    @ExoTransactional
    public void createInitialStatuses(ProjectDto proj) {
        ProjectDto projectDto = proj;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)projectDto);
        Object[] objectArray = new Object[]{this, projectDto, joinPoint};
        StatusServiceImpl$AjcClosure1 statusServiceImpl$AjcClosure1 = new StatusServiceImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(statusServiceImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    public StatusDto getStatus(long statusId) {
        return this.statusStorage.getStatus(statusId);
    }

    @Override
    public StatusDto getDefaultStatus(long projectId) {
        return this.statusStorage.getDefaultStatus(projectId);
    }

    @Override
    public List<StatusDto> getStatuses(long projectId) {
        return this.statusStorage.getStatuses(projectId);
    }

    @Override
    @ExoTransactional
    public StatusDto createStatus(ProjectDto project, String name) {
        ProjectDto projectDto = project;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)projectDto, (Object)string);
        Object[] objectArray = new Object[]{this, projectDto, string, joinPoint};
        StatusServiceImpl$AjcClosure3 statusServiceImpl$AjcClosure3 = new StatusServiceImpl$AjcClosure3(objectArray);
        return (StatusDto)ExoTransactionalAspect.aspectOf().around(statusServiceImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public StatusDto createStatus(ProjectDto project, String name, int rank) throws NotAllowedOperationOnEntityException {
        ProjectDto projectDto = project;
        String string = name;
        int n = rank;
        Object[] objectArray = new Object[]{projectDto, string, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, projectDto, string, Conversions.intObject((int)n), joinPoint};
        StatusServiceImpl$AjcClosure5 statusServiceImpl$AjcClosure5 = new StatusServiceImpl$AjcClosure5(objectArray2);
        return (StatusDto)ExoTransactionalAspect.aspectOf().around(statusServiceImpl$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public void removeStatus(long statusID) throws Exception {
        long l = statusID;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        StatusServiceImpl$AjcClosure7 statusServiceImpl$AjcClosure7 = new StatusServiceImpl$AjcClosure7(objectArray);
        ExoTransactionalAspect.aspectOf().around(statusServiceImpl$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public StatusDto updateStatus(long id, String name) throws EntityNotFoundException, NotAllowedOperationOnEntityException {
        long l = id;
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l), (Object)string);
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), string, joinPoint};
        StatusServiceImpl$AjcClosure9 statusServiceImpl$AjcClosure9 = new StatusServiceImpl$AjcClosure9(objectArray);
        return (StatusDto)ExoTransactionalAspect.aspectOf().around(statusServiceImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @Override
    @ExoTransactional
    public StatusDto updateStatus(StatusDto statusDto) throws EntityNotFoundException, NotAllowedOperationOnEntityException {
        StatusDto statusDto2 = statusDto;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)statusDto2);
        Object[] objectArray = new Object[]{this, statusDto2, joinPoint};
        StatusServiceImpl$AjcClosure11 statusServiceImpl$AjcClosure11 = new StatusServiceImpl$AjcClosure11(objectArray);
        return (StatusDto)ExoTransactionalAspect.aspectOf().around(statusServiceImpl$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    static {
        StatusServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(StatusServiceImpl.class);
    }

    static final /* synthetic */ void createInitialStatuses_aroundBody0(StatusServiceImpl ajc$this, ProjectDto proj, JoinPoint joinPoint) {
        for (String s : ajc$this.getDefaultStatus()) {
            ajc$this.createStatus(proj, s);
        }
    }

    static final /* synthetic */ StatusDto createStatus_aroundBody2(StatusServiceImpl ajc$this, ProjectDto project, String name, JoinPoint joinPoint) {
        if (name == null || (name = name.trim()).isEmpty() || project == null) {
            throw new IllegalArgumentException("project must be not null and status must not be null or empty");
        }
        StatusDto status = ajc$this.statusStorage.createStatus(project, name);
        try {
            ajc$this.listenerService.broadcast("exo.project.projectModified", null, (Object)project);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting status creation event", (Throwable)e);
        }
        return status;
    }

    static final /* synthetic */ StatusDto createStatus_aroundBody4(StatusServiceImpl ajc$this, ProjectDto project, String name, int rank, JoinPoint joinPoint) {
        if (name == null || (name = name.trim()).isEmpty() || project == null) {
            throw new IllegalArgumentException("project must be not null and status must not be null or empty");
        }
        try {
            ajc$this.listenerService.broadcast("exo.project.projectModified", null, (Object)project);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting status creation event", (Throwable)e);
        }
        return ajc$this.statusStorage.createStatus(project, name, rank);
    }

    static final /* synthetic */ void removeStatus_aroundBody6(StatusServiceImpl ajc$this, long statusID, JoinPoint joinPoint) {
        ajc$this.statusStorage.removeStatus(statusID, false);
    }

    static final /* synthetic */ StatusDto updateStatus_aroundBody8(StatusServiceImpl ajc$this, long id, String name, JoinPoint joinPoint) {
        if (name == null || (name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("status name can't be null or empty");
        }
        StatusDto statusDto = ajc$this.statusStorage.updateStatus(id, name);
        try {
            ajc$this.listenerService.broadcast("exo.project.projectModified", null, (Object)statusDto.getProject());
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting status update event", (Throwable)e);
        }
        return statusDto;
    }

    static final /* synthetic */ StatusDto updateStatus_aroundBody10(StatusServiceImpl ajc$this, StatusDto statusDto, JoinPoint joinPoint) {
        String name = statusDto.getName();
        if (name == null || (name = name.trim()).isEmpty()) {
            throw new IllegalArgumentException("status name can't be null or empty");
        }
        statusDto = ajc$this.statusStorage.updateStatus(statusDto);
        try {
            ajc$this.listenerService.broadcast("exo.project.projectModified", (Object)ajc$this, (Object)statusDto.getProject());
        }
        catch (Exception e) {
            LOG.error((Object)"Error while broadcasting status update event", (Throwable)e);
        }
        return statusDto;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StatusServiceImpl.java", StatusServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createInitialStatuses", "org.exoplatform.task.service.impl.StatusServiceImpl", "org.exoplatform.task.dto.ProjectDto", "proj", "", "void"), 93);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatus", "org.exoplatform.task.service.impl.StatusServiceImpl", "org.exoplatform.task.dto.ProjectDto:java.lang.String", "project:name", "", "org.exoplatform.task.dto.StatusDto"), 116);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createStatus", "org.exoplatform.task.service.impl.StatusServiceImpl", "org.exoplatform.task.dto.ProjectDto:java.lang.String:int", "project:name:rank", "org.exoplatform.task.exception.NotAllowedOperationOnEntityException", "org.exoplatform.task.dto.StatusDto"), 131);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeStatus", "org.exoplatform.task.service.impl.StatusServiceImpl", "long", "statusID", "java.lang.Exception", "void"), 145);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateStatus", "org.exoplatform.task.service.impl.StatusServiceImpl", "long:java.lang.String", "id:name", "org.exoplatform.task.exception.EntityNotFoundException:org.exoplatform.task.exception.NotAllowedOperationOnEntityException", "org.exoplatform.task.dto.StatusDto"), 151);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateStatus", "org.exoplatform.task.service.impl.StatusServiceImpl", "org.exoplatform.task.dto.StatusDto", "statusDto", "org.exoplatform.task.exception.EntityNotFoundException:org.exoplatform.task.exception.NotAllowedOperationOnEntityException", "org.exoplatform.task.dto.StatusDto"), 166);
    }
}

