/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.web.security.authenticator;

import io.meeds.web.security.service.DigestAuthenticatorService;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.UsernameCredential;
import org.exoplatform.services.security.jaas.AbstractLoginModule;
import org.exoplatform.services.security.jaas.RolePrincipal;
import org.exoplatform.services.security.jaas.UserPrincipal;

public class DigestLoginModule
extends AbstractLoginModule {
    protected static final Log LOG = ExoLogger.getLogger(DigestLoginModule.class);
    protected static DigestAuthenticatorService digestAuthenticatorService;
    protected static IdentityRegistry identityRegistry;
    protected Identity identity;

    public boolean login() throws LoginException {
        String username = null;
        try {
            if (this.sharedState.containsKey("exo.security.identity")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Use Identity from previous LoginModule");
                }
                this.identity = (Identity)this.sharedState.get("exo.security.identity");
            } else {
                String password;
                Callback[] callbacks = new Callback[]{new NameCallback("Username"), new PasswordCallback("Password", false), new TextInputCallback("nonce"), new TextInputCallback("nc"), new TextInputCallback("cnonce"), new TextInputCallback("qop"), new TextInputCallback("realmName"), new TextInputCallback("digestA2"), new TextInputCallback("algorithm"), new TextInputCallback("authMethod")};
                this.callbackHandler.handle(callbacks);
                username = ((NameCallback)callbacks[0]).getName();
                char[] passwordArray = ((PasswordCallback)callbacks[1]).getPassword();
                String string = password = passwordArray == null ? null : new String(passwordArray);
                if (StringUtils.isBlank((CharSequence)username) || StringUtils.isBlank((CharSequence)password)) {
                    return false;
                }
                String nonce = ((TextInputCallback)callbacks[2]).getText();
                String nc = ((TextInputCallback)callbacks[3]).getText();
                String cnonce = ((TextInputCallback)callbacks[4]).getText();
                String qop = ((TextInputCallback)callbacks[5]).getText();
                String realmName = ((TextInputCallback)callbacks[6]).getText();
                String digestA2 = ((TextInputCallback)callbacks[7]).getText();
                String algorithm = ((TextInputCallback)callbacks[8]).getText();
                username = this.getDigestAuthenticatorService().validateUser(username, password, nonce, nc, cnonce, qop, realmName, digestA2, algorithm);
                if (StringUtils.isBlank((CharSequence)username)) {
                    return false;
                }
                this.identity = this.getDigestAuthenticatorService().createIdentity(username);
                this.sharedState.put("javax.security.auth.login.name", username);
                this.subject.getPublicCredentials().add(new UsernameCredential(username));
            }
            return username != null;
        }
        catch (Exception e) {
            LOG.warn("Login error for user {}", new Object[]{username});
            return false;
        }
    }

    public boolean commit() throws LoginException {
        if (this.identity == null) {
            return false;
        }
        try {
            this.getIdentityRegistry().register(this.identity);
            Set<Principal> principals = this.subject.getPrincipals();
            for (String role : this.identity.getRoles()) {
                principals.add((Principal)new RolePrincipal(role));
            }
            principals.add((Principal)new UserPrincipal(this.identity.getUserId()));
        }
        catch (Exception e) {
            LOG.debug("Error committing authenticated user identity {}", new Object[]{this.identity.getUserId(), e});
            throw new LoginException(String.format("Error committing authenticated user identity %s. Error: %s", this.identity.getUserId(), e.getMessage()));
        }
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        return true;
    }

    protected Log getLogger() {
        return LOG;
    }

    private DigestAuthenticatorService getDigestAuthenticatorService() {
        if (digestAuthenticatorService == null) {
            digestAuthenticatorService = (DigestAuthenticatorService)this.getContainer().getComponentInstanceOfType(DigestAuthenticatorService.class);
        }
        return digestAuthenticatorService;
    }

    private IdentityRegistry getIdentityRegistry() {
        if (identityRegistry == null) {
            identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        }
        return identityRegistry;
    }
}

