/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.renderer;

import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstancePreferencePlugin;
import io.meeds.layout.plugin.renderer.SidebarLoginPortletInstancePreferencePlugin;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.attachment.model.ObjectAttachmentDetail;
import org.exoplatform.social.attachment.model.ObjectAttachmentList;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

public class CMSPortletInstancePreferencePlugin
implements PortletInstancePreferencePlugin {
    private static final Log LOG = ExoLogger.getLogger(SidebarLoginPortletInstancePreferencePlugin.class);
    private static final String DATA_INIT_PREFERENCE_NAME = "data.init";
    private static final String EXPORT_DATA_INIT_PREFERENCE_NAME = "export.data.init";
    private static final String EXPORT_DATA_ALT_INIT_PREFERENCE_NAME = "export.data.alt.init";
    private static final String EXPORT_DATA_TRANSLATION_INIT_PREFERENCE_NAME = "export.data.translation.init";
    private static final String CMS_SETTING_PREFERENCE_NAME = "name";
    @Autowired
    private AttachmentService attachmentService;
    @Autowired
    private FileService fileService;
    @Autowired
    private TranslationService translationService;
    public static final String OBJECT_TYPE = "cmsPortlet";

    @Override
    public String getPortletName() {
        return "CMSPortlet";
    }

    @Override
    public List<PortletInstancePreference> generatePreferences(Application application, Portlet preferences, PortletInstanceContext portletInstanceContext) {
        String settingName = this.getCmsSettingName(preferences);
        ArrayList<PortletInstancePreference> result = new ArrayList<PortletInstancePreference>();
        preferences.forEach(preference -> {
            if (!preference.getName().equals(CMS_SETTING_PREFERENCE_NAME) && !preference.getName().equals(DATA_INIT_PREFERENCE_NAME)) {
                result.add(new PortletInstancePreference(preference.getName(), preference.getValue()));
            }
        });
        if (!StringUtils.isBlank((CharSequence)settingName)) {
            if (portletInstanceContext.isExport()) {
                result.addAll(this.computePreferencesToExport(settingName));
            } else {
                result.add(new PortletInstancePreference(DATA_INIT_PREFERENCE_NAME, settingName));
            }
        } else if (portletInstanceContext.isExport() && preferences.getPreference(DATA_INIT_PREFERENCE_NAME) != null) {
            settingName = preferences.getPreference(DATA_INIT_PREFERENCE_NAME).getValue();
            result.addAll(this.computePreferencesToExport(settingName));
        }
        return result;
    }

    private String getFileContent(String id) {
        try {
            FileItem file = this.fileService.getFile(Long.parseLong(id));
            if (file == null) {
                return null;
            }
            return Base64.encodeBase64String((byte[])file.getAsByte());
        }
        catch (FileStorageException e) {
            LOG.warn("Unable to read file with id=", new Object[]{id, e});
            return null;
        }
    }

    private String getCmsSettingName(Portlet preferences) {
        if (preferences == null) {
            return null;
        }
        Preference settingNamePreference = preferences.getPreference(CMS_SETTING_PREFERENCE_NAME);
        return settingNamePreference == null ? null : settingNamePreference.getValue();
    }

    private List<PortletInstancePreference> computePreferencesToExport(String settingName) {
        ObjectAttachmentDetail file;
        ArrayList<PortletInstancePreference> preferencesToExport = new ArrayList<PortletInstancePreference>();
        try {
            JSONObject translationsJson = new JSONObject();
            Map translations = this.translationService.getAllTranslationFields(OBJECT_TYPE, settingName);
            translations.entrySet().forEach(entry -> {
                String translationKey = (String)entry.getKey();
                TranslationField translationField = (TranslationField)entry.getValue();
                if (!translationField.getLabels().isEmpty()) {
                    translationsJson.put(translationKey, translationField.getLabels());
                }
            });
            if (!translationsJson.isEmpty()) {
                preferencesToExport.add(new PortletInstancePreference(EXPORT_DATA_TRANSLATION_INIT_PREFERENCE_NAME, translationsJson.toString()));
            }
        }
        catch (ObjectNotFoundException translationsJson) {
            // empty catch block
        }
        ObjectAttachmentList attachmentList = this.attachmentService.getAttachments(OBJECT_TYPE, settingName);
        ObjectAttachmentDetail objectAttachmentDetail = file = attachmentList == null || attachmentList.getAttachments() == null || attachmentList.getAttachments().size() == 0 ? null : (ObjectAttachmentDetail)attachmentList.getAttachments().getFirst();
        if (file != null) {
            String fileContent = this.getFileContent(file.getId());
            preferencesToExport.add(new PortletInstancePreference(EXPORT_DATA_INIT_PREFERENCE_NAME, fileContent));
            if (file.getAltText() != null) {
                preferencesToExport.add(new PortletInstancePreference(EXPORT_DATA_ALT_INIT_PREFERENCE_NAME, file.getAltText()));
            }
        }
        return preferencesToExport;
    }
}

