/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.poll.rest;

import io.meeds.poll.model.Poll;
import io.meeds.poll.model.PollOption;
import io.meeds.poll.model.PollVote;
import io.meeds.poll.rest.model.PollRestEntity;
import io.meeds.poll.service.PollService;
import io.meeds.poll.utils.RestEntityBuilder;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.ws.rs.core.Application;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/polls"})
@Tag(name="/polls", description="Managing poll")
public class PollRest
extends Application {
    private static final Log LOG = ExoLogger.getLogger(PollRest.class);
    @Autowired
    private PollService pollService;

    @PostMapping(consumes={"application/json"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Create a new poll", method="POST", description="Create a new poll")
    @ApiResponses(value={@ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="50", description="Internal server error")})
    public ResponseEntity<PollRestEntity> createPoll(@Parameter(description="space identifier") @RequestParam(value="spaceId") String spaceId, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Poll object to create", required=true) @RequestBody PollRestEntity pollRestEntity) {
        if (pollRestEntity == null) {
            return ResponseEntity.badRequest().build();
        }
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            Poll poll = RestEntityBuilder.toPoll(pollRestEntity);
            List<PollOption> pollOptions = RestEntityBuilder.toPollOptions(pollRestEntity.getOptions());
            poll = this.pollService.createPoll(poll, pollOptions, spaceId, pollRestEntity.getMessage(), currentIdentity, pollRestEntity.getFiles());
            return ResponseEntity.ok((Object)RestEntityBuilder.fromPoll(this.pollService, poll, currentIdentity));
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to create a non authorized poll", new Object[]{currentIdentity.getUserId(), e});
            return ResponseEntity.status((int)401).build();
        }
    }

    @GetMapping(path={"{id}"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Get a poll", method="GET", description="This gets the poll with the given id if the authenticated user is a member of the space.")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Poll not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<PollRestEntity> getPollById(@Parameter(description="Poll id", required=true) @PathVariable(value="id") String pollId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            if (StringUtils.isBlank((CharSequence)pollId)) {
                return ResponseEntity.badRequest().build();
            }
            Poll poll = this.pollService.getPollById(Long.parseLong(pollId), currentIdentity);
            if (poll == null) {
                return ResponseEntity.notFound().build();
            }
            PollRestEntity pollRestEntity = RestEntityBuilder.fromPoll(this.pollService, poll, currentIdentity);
            return ResponseEntity.ok((Object)pollRestEntity);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to get a non authorized poll with id {}", new Object[]{currentIdentity.getUserId(), pollId, e});
            return ResponseEntity.status((int)401).build();
        }
    }

    @PostMapping(path={"/vote/{optionId}"}, consumes={"application/json"}, produces={"application/json"})
    @Secured(value={"users"})
    @Operation(summary="Vote in a poll", method="POST", description="Vote in a poll")
    @ApiResponses(value={@ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Poll option not found"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public ResponseEntity<PollVote> vote(@Parameter(description="Poll option id", required=true) @PathVariable(value="optionId") String optionId) {
        Identity currentIdentity = ConversationState.getCurrent().getIdentity();
        try {
            PollOption pollOption = this.pollService.getPollOptionById(Long.parseLong(optionId), currentIdentity);
            if (pollOption == null) {
                return ResponseEntity.notFound().build();
            }
            Poll poll = this.pollService.getPollById(pollOption.getPollId(), currentIdentity);
            if (poll == null) {
                return ResponseEntity.notFound().build();
            }
            if (this.pollService.didVote(currentIdentity, Long.valueOf(pollOption.getPollId()))) {
                return ResponseEntity.of((ProblemDetail)ProblemDetail.forStatusAndDetail((HttpStatusCode)HttpStatus.FORBIDDEN, (String)"User did already vote an option in this poll")).build();
            }
            PollVote pollVote = this.pollService.vote(optionId, String.valueOf(poll.getSpaceId()), currentIdentity);
            return ResponseEntity.ok((Object)pollVote);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' attempts to vote in a non authorized poll option with id {}", new Object[]{currentIdentity.getUserId(), optionId, e});
            return ResponseEntity.status((int)401).build();
        }
    }
}

