/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.service;

import io.meeds.appcenter.constant.ApplicationType;
import io.meeds.appcenter.model.Application;
import io.meeds.appcenter.model.ApplicationDescriptor;
import io.meeds.appcenter.model.ApplicationDescriptorList;
import io.meeds.appcenter.model.ApplicationForm;
import io.meeds.appcenter.service.ApplicationCenterInjectService$AjcClosure1;
import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.common.ContainerTransactional;
import io.meeds.common.ContainerTransactionalAspect;
import io.meeds.social.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationCenterInjectService {
    private static final Log LOG;
    private static final String APP_CENTER_APPS_VERSION = "6";
    private static final String MERGE_MODE = "merge";
    private static final String APP_CENTER_SYSTEM_APP_KEY = "systemApps";
    @Autowired
    private ConfigurationManager configurationManager;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private ApplicationCenterService applicationCenterService;
    @Autowired
    private SettingService settingService;
    private Map<String, ApplicationDescriptor> defaultApplications = new LinkedHashMap<String, ApplicationDescriptor>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @PostConstruct
    public void init() {
        CompletableFuture.runAsync(this::initTransactional);
    }

    @ContainerTransactional
    public void initTransactional() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ApplicationCenterInjectService$AjcClosure1 applicationCenterInjectService$AjcClosure1 = new ApplicationCenterInjectService$AjcClosure1(objectArray);
        ContainerTransactionalAspect.aspectOf().around(applicationCenterInjectService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void addApplicationPlugin(ApplicationDescriptor applicationPlugin) {
        if (applicationPlugin == null) {
            throw new IllegalArgumentException("'applicationPlugin' is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)applicationPlugin.getName())) {
            throw new IllegalStateException("'applicationPlugin' name is mandatory");
        }
        this.defaultApplications.put(applicationPlugin.getName(), applicationPlugin);
    }

    public void removeApplicationPlugin(String pluginName) {
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            throw new IllegalArgumentException("'pluginName' is mandatory");
        }
        this.defaultApplications.remove(pluginName);
    }

    public boolean isDefaultSystemApplication(Application application) {
        if (application == null) {
            throw new IllegalArgumentException("'application' is mandatory");
        }
        return this.defaultApplications.values().stream().filter(ApplicationDescriptor::isEnabled).anyMatch(app -> StringUtils.equals((CharSequence)app.getApplication().getTitle(), (CharSequence)application.getTitle()) && StringUtils.equals((CharSequence)app.getApplication().getUrl(), (CharSequence)application.getUrl()));
    }

    protected void injectDefaultApplications() {
        try {
            this.readDescriptorsFromFiles();
            this.deleteRemovedSystemApplications();
            this.defaultApplications.values().stream().filter(ApplicationDescriptor::isEnabled).forEach(applicationDescriptor -> {
                try {
                    this.injectDefaultApplication((ApplicationDescriptor)applicationDescriptor);
                }
                catch (Exception e) {
                    LOG.warn("An error occurred while reimporting system application {}", new Object[]{applicationDescriptor.getName(), e});
                }
            });
            this.saveStoredApplicationsVersion();
        }
        catch (Exception e) {
            LOG.warn((Object)"An unknown error occurs while reimporting system applications", (Throwable)e);
        }
    }

    private void readDescriptorsFromFiles() throws IOException {
        Enumeration<URL> descriptorFiles = this.getClass().getClassLoader().getResources("applications.json");
        Collections.list(descriptorFiles).stream().map(this::parseDescriptors).flatMap(Collection::stream).forEach(d -> this.defaultApplications.put(d.getName(), (ApplicationDescriptor)d));
    }

    private List<ApplicationDescriptor> parseDescriptors(URL url) {
        List<ApplicationDescriptor> list;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                ApplicationDescriptorList list2 = (ApplicationDescriptorList)JsonUtils.fromJsonString((String)content, ApplicationDescriptorList.class);
                list = list2.getDescriptors();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn("An unkown error happened while parsing application descriptors from url {}", new Object[]{url, e});
                    return Collections.emptyList();
                }
            }
            inputStream.close();
        }
        return list;
    }

    private void deleteRemovedSystemApplications() {
        List<Application> systemApplications = this.applicationCenterService.getSystemApplications();
        systemApplications.forEach(application -> {
            if (!this.isDefaultSystemApplication((Application)application)) {
                try {
                    LOG.info("Delete application '{}' that was previously injected as system application and that doesn't exist in configuration anymore", new Object[]{application.getTitle()});
                    this.applicationCenterService.deleteApplication(application.getId());
                }
                catch (Exception e) {
                    LOG.warn("An unknown error occurs while deleting not found system application '{}' in store", new Object[]{application.getTitle(), e});
                }
            }
        });
    }

    private void injectDefaultApplication(ApplicationDescriptor applicationDescriptor) {
        Application storedApplication;
        Application application = applicationDescriptor.getApplication();
        String pluginName = applicationDescriptor.getName();
        if (application == null) {
            LOG.warn("An application plugin '{}' holds an empty application", new Object[]{pluginName});
            return;
        }
        String title = application.getTitle();
        if (StringUtils.isBlank((CharSequence)title)) {
            LOG.warn("Plugin '{}' has an application with empty title, it will not be injected", new Object[]{pluginName});
            return;
        }
        String url = application.getUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            LOG.warn("Plugin '{}' has an application with empty url, it will not be injected", new Object[]{pluginName});
            return;
        }
        long storedAppId = this.getStoredApplicationId(pluginName);
        Application application2 = storedApplication = storedAppId == 0L ? null : this.applicationCenterService.getApplication(storedAppId);
        if (storedApplication == null) {
            storedApplication = this.applicationCenterService.findSystemApplicationByUrl(url);
        }
        String version = this.getStoredApplicationsVersion();
        if (storedApplication != null && !applicationDescriptor.isOverride() && StringUtils.equals((CharSequence)APP_CENTER_APPS_VERSION, (CharSequence)version) && storedApplication.isChangedManually() && (MERGE_MODE.equals(applicationDescriptor.getOverrideMode()) || applicationDescriptor.getOverrideMode() == null)) {
            LOG.info("Ignore updating system application '{}', override flag is turned off", new Object[]{application.getTitle()});
            return;
        }
        if (application.getType() == null) {
            application.setType(ApplicationType.LINK);
        }
        ApplicationForm applicationForm = new ApplicationForm(application);
        String imagePath = applicationDescriptor.getImagePath();
        if (StringUtils.isNotBlank((CharSequence)imagePath)) {
            String uploadId = UUID.randomUUID().toString();
            try {
                URL resource = this.configurationManager.getURL(imagePath);
                if (resource == null) {
                    LOG.warn("Application Image with path {} doesn't exist", new Object[]{imagePath});
                } else {
                    File file = this.createTempFile(this.configurationManager.getInputStream(imagePath).readAllBytes());
                    UploadResource uploadResource = new UploadResource(uploadId, file.getName(), "image/png", file.getPath(), 0.0, 0.0, 1);
                    this.uploadService.createUploadResource(uploadResource);
                    applicationForm.setImageUploadId(uploadId);
                }
            }
            catch (Exception e) {
                LOG.warn("Error reading image from file {}. Application will be injected without image", new Object[]{imagePath, e});
            }
        }
        if (storedApplication == null) {
            try {
                LOG.info("Create system application '{}'", new Object[]{applicationForm.getTitle()});
                applicationForm.setSystem(true);
                applicationForm.setChangedManually(false);
                applicationForm.setImageFileId(null);
                storedApplication = this.applicationCenterService.createApplication(applicationForm);
                if (storedApplication != null) {
                    this.saveStoredApplicationId(pluginName, storedApplication.getId());
                }
            }
            catch (Exception e) {
                LOG.error("Error creating application {}", new Object[]{applicationForm, e});
            }
        } else {
            try {
                LOG.info("Update system application '{}'", new Object[]{applicationForm.getTitle()});
                applicationForm.setSystem(true);
                applicationForm.setChangedManually(false);
                applicationForm.setId(storedApplication.getId());
                applicationForm.setImageFileId(storedApplication.getImageFileId());
                this.applicationCenterService.updateApplication(applicationForm);
                this.saveStoredApplicationId(pluginName, storedApplication.getId());
            }
            catch (Exception e) {
                LOG.error("Error updating application {}", new Object[]{applicationForm, e});
            }
        }
    }

    private long getStoredApplicationId(String pluginName) {
        SettingValue settingValue = this.settingService.get(ApplicationCenterService.APP_CENTER_CONTEXT, ApplicationCenterService.APP_CENTER_SCOPE, APP_CENTER_SYSTEM_APP_KEY + pluginName);
        String appId = settingValue == null || settingValue.getValue() == null ? null : settingValue.getValue().toString();
        return StringUtils.isBlank(appId) ? 0L : Long.parseLong(appId);
    }

    private void saveStoredApplicationId(String pluginName, long appId) {
        this.settingService.set(ApplicationCenterService.APP_CENTER_CONTEXT, ApplicationCenterService.APP_CENTER_SCOPE, APP_CENTER_SYSTEM_APP_KEY + pluginName, SettingValue.create((Long)appId));
    }

    private String getStoredApplicationsVersion() {
        SettingValue settingValue = this.settingService.get(ApplicationCenterService.APP_CENTER_CONTEXT, ApplicationCenterService.APP_CENTER_SCOPE, APP_CENTER_SYSTEM_APP_KEY);
        return settingValue == null || settingValue.getValue() == null ? null : settingValue.getValue().toString();
    }

    private void saveStoredApplicationsVersion() {
        this.settingService.set(ApplicationCenterService.APP_CENTER_CONTEXT, ApplicationCenterService.APP_CENTER_SCOPE, APP_CENTER_SYSTEM_APP_KEY, SettingValue.create((String)APP_CENTER_APPS_VERSION));
    }

    private File createTempFile(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Illustration data is null");
        }
        File tempFile = new File(System.getProperty("java.io.tmpdir") + File.separator + "temp.png");
        FileUtils.writeByteArrayToFile((File)tempFile, (byte[])data);
        return tempFile;
    }

    @Generated
    public Map<String, ApplicationDescriptor> getDefaultApplications() {
        return this.defaultApplications;
    }

    static {
        ApplicationCenterInjectService.ajc$preClinit();
        LOG = ExoLogger.getLogger(ApplicationCenterInjectService.class);
    }

    static final /* synthetic */ void initTransactional_aroundBody0(ApplicationCenterInjectService ajc$this, JoinPoint joinPoint) {
        ajc$this.injectDefaultApplications();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ApplicationCenterInjectService.java", ApplicationCenterInjectService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "initTransactional", "io.meeds.appcenter.service.ApplicationCenterInjectService", "", "", "", "void"), 101);
    }
}

