/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.file.resource;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileUtils {
    private static final int BUFFER_SIZE = 65536;
    private static final int MAX_BUFFER_SIZE = 0x100000;
    private static final int MIN_BUFFER_SIZE = 8192;

    private FileUtils() {
    }

    private static byte[] createBuffer(int preferredSize) {
        if (preferredSize < 1) {
            preferredSize = 65536;
        }
        if (preferredSize > 0x100000) {
            preferredSize = 0x100000;
        } else if (preferredSize < 8192) {
            preferredSize = 8192;
        }
        return new byte[preferredSize];
    }

    public static boolean createNewFile(File file) throws IOException {
        return file.createNewFile();
    }

    public static boolean exists(File file) {
        return file.exists();
    }

    public static boolean mkdirs(File file) {
        return file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in) throws IOException {
        byte[] buffer = FileUtils.createBuffer(in.available());
        int w = 0;
        try {
            int len;
            int read = 0;
            do {
                if ((len = buffer.length - (w += read)) > 0) continue;
                byte[] b = new byte[buffer.length + 65536];
                System.arraycopy(buffer, 0, b, 0, w);
                buffer = b;
                len = buffer.length - w;
            } while ((read = in.read(buffer, w, len)) != -1);
        }
        finally {
            in.close();
        }
        if (buffer.length > w) {
            byte[] b = new byte[w];
            System.arraycopy(buffer, 0, b, 0, w);
            buffer = b;
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyToFile(InputStream in, File file) throws IOException {
        try (FileOutputStream out = null;){
            int read;
            out = new FileOutputStream(file);
            byte[] buffer = FileUtils.createBuffer(in.available());
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
        }
    }

    public static void writeFile(File file, byte[] buf) throws IOException {
        FileUtils.writeFile(file, buf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(File file, byte[] buf, boolean append) throws IOException {
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(file, append);
            fos.write(buf);
        }
    }
}

