/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.StateKey;

public final class ConversationRegistry {
    private static final String CACHE_NAME = "portal.ConversationRegistry";
    private static final String STATE_KEYS_NAME = "portal.ConversationRegistryStates";
    private static final Log LOG = ExoLogger.getLogger(ConversationRegistry.class);
    private final ExoCache<StateKey, ConversationState> statesCache;
    private final ExoCache<String, Set<StateKey>> stateKeysCache;
    private final IdentityRegistry identityRegistry;
    private final ListenerService listenerService;

    public ConversationRegistry(IdentityRegistry identityRegistry, ListenerService listenerService, CacheService cacheService) {
        this.statesCache = cacheService.getCacheInstance(CACHE_NAME);
        this.stateKeysCache = cacheService.getCacheInstance(STATE_KEYS_NAME);
        this.identityRegistry = identityRegistry;
        this.listenerService = listenerService;
    }

    public ConversationState getState(StateKey key) {
        return (ConversationState)this.statesCache.get((Serializable)key);
    }

    public void register(StateKey key, ConversationState state) {
        String userId = state.getIdentity().getUserId();
        boolean broadcast = this.statesCache.get((Serializable)key) == null && StringUtils.isNotBlank((CharSequence)userId) && this.getStateKeys(userId).isEmpty();
        this.statesCache.put((Serializable)key, (Object)state);
        this.addStateKey(userId, key);
        if (broadcast) {
            try {
                this.listenerService.broadcast("exo.core.security.ConversationRegistry.register", (Object)this, (Object)state);
            }
            catch (Exception e) {
                LOG.error((Object)"Broadcast message filed ", (Throwable)e);
            }
        }
    }

    public ConversationState unregister(StateKey key) {
        return this.unregister(key, true);
    }

    public ConversationState unregister(StateKey key, boolean unregisterIdentity) {
        ConversationState state = (ConversationState)this.statesCache.remove((Serializable)key);
        if (state != null) {
            String userId = state.getIdentity().getUserId();
            this.removeStateKey(userId, key);
            if (unregisterIdentity && CollectionUtils.isEmpty((Collection)((Collection)this.stateKeysCache.get((Serializable)((Object)userId))))) {
                this.identityRegistry.unregister(userId);
            }
            try {
                this.listenerService.broadcast("exo.core.security.ConversationRegistry.unregister", (Object)this, (Object)state);
            }
            catch (Exception e) {
                LOG.error((Object)"Broadcast message filed ", (Throwable)e);
            }
        }
        return state;
    }

    public List<ConversationState> unregisterByUserId(String userId) {
        ArrayList<ConversationState> states = new ArrayList<ConversationState>();
        HashSet stateKeys = (HashSet)this.stateKeysCache.get((Serializable)((Object)userId));
        if (stateKeys != null) {
            stateKeys = new HashSet(stateKeys);
            for (StateKey key : stateKeys) {
                ConversationState state = this.unregister(key, false);
                if (state == null) continue;
                states.add(state);
            }
        }
        return states;
    }

    public List<StateKey> getStateKeys(String userId) {
        return this.stateKeysCache.get((Serializable)((Object)userId)) == null ? Collections.emptyList() : new ArrayList((Collection)this.stateKeysCache.get((Serializable)((Object)userId)));
    }

    void clear() {
        this.statesCache.clearCache();
        this.stateKeysCache.clearCache();
    }

    private void removeStateKey(String userId, StateKey key) {
        Set stateKeys = (Set)this.stateKeysCache.get((Serializable)((Object)userId));
        if (stateKeys != null) {
            stateKeys.remove(key);
            if (stateKeys.isEmpty()) {
                this.stateKeysCache.remove((Serializable)((Object)userId));
            }
        }
    }

    private void addStateKey(String userId, StateKey key) {
        Set<StateKey> states = (Set<StateKey>)this.stateKeysCache.get((Serializable)((Object)userId));
        if (states == null) {
            states = Collections.synchronizedSet(new HashSet());
        }
        states.add(key);
        this.stateKeysCache.put((Serializable)((Object)userId), states);
    }
}

