/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.rest.impl.activity;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.application.localization.LocalizationFilter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.RealtimeListAccess;
import org.exoplatform.social.core.activity.ActivityFilter;
import org.exoplatform.social.core.activity.ActivityStreamType;
import org.exoplatform.social.core.activity.filter.ActivitySearchFilter;
import org.exoplatform.social.core.activity.model.ActivitySearchResult;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.jpa.search.ActivitySearchConnector;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.rest.entity.ActivityCommentCollectionEntity;
import org.exoplatform.social.rest.entity.ActivityEntity;
import org.exoplatform.social.rest.entity.ActivitySearchResultEntity;
import org.exoplatform.social.rest.entity.CollectionEntity;
import org.exoplatform.social.rest.entity.CommentEntity;
import org.exoplatform.social.rest.entity.DataEntity;
import org.exoplatform.social.rest.entity.MetadataItemEntity;

@Path(value="v1/social/activities")
@Tag(name="v1/social/activities", description="Managing activities together with comments and likes")
public class ActivityRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(ActivityRest.class);
    private static final int MAX_TO_PRELOAD = 10;
    private ActivityManager activityManager;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private ActivitySearchConnector activitySearchConnector;

    public ActivityRest(ActivityManager activityManager, IdentityManager identityManager, SpaceService spaceService, ActivitySearchConnector activitySearchConnector) {
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.spaceService = spaceService;
        this.activitySearchConnector = activitySearchConnector;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets activities of a specific user", description="This returns an activity in the list in the following cases: <br/><ul><li>this is a user activity and the owner of the activity isthe authenticated user or one of his connections</li><li>this is a space activity and the authenticated user is a member of the space</li></ul>", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getActivities(@Context UriInfo uriInfo, @Parameter(description="Space technical identifier", required=false) @QueryParam(value="spaceId") String spaceId, @Parameter(description="Category id used to search associated activities", required=false) @QueryParam(value="categoryId") List<Long> categoryIds, @Parameter(description="Category IDs to exclude from the result", required=false) @QueryParam(value="excludedCategoryId") List<Long> excludedCategoryIds, @Parameter(description="Offset", required=false) @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of activities or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Asking for a full representation of a specific subresource, ex: <em>comments</em> or <em>likes</em>", required=false) @QueryParam(value="expand") String expand, @Parameter(description="Returning the pinned activities sorted in order or not", required=false) @QueryParam(value="showPinned") boolean showPinned, @Parameter(description="Activity stream type. Possible values: ALL_STREAM, USER_STREAM, USER_FAVORITE_STREAM, MANAGE_SPACES_STREAM, FAVORITE_SPACES_STREAM.", required=false) @QueryParam(value="streamType") ActivityStreamType streamType) {
        int preloadLimit;
        RealtimeListAccess listAccess;
        boolean canPost;
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentUser.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUserIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        if (currentUserIdentity == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ActivityFilter activityFilter = new ActivityFilter();
        activityFilter.setShowPinned(showPinned);
        activityFilter.setCategoryIds(categoryIds);
        activityFilter.setExcludedCategoryIds(excludedCategoryIds);
        if (!StringUtils.isBlank((CharSequence)spaceId)) {
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null || !this.spaceService.isMember(space, authenticatedUser) && !this.spaceService.isSuperManager(space, authenticatedUser)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            org.exoplatform.social.core.identity.model.Identity spaceIdentity = this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
            activityFilter.setSpaceIdentityId(spaceIdentity.getIdentityId());
            canPost = this.activityManager.canPostActivityInStream(currentUser, spaceIdentity);
        } else {
            canPost = this.activityManager.canPostActivityInStream(currentUser, currentUserIdentity);
        }
        if (streamType != null) {
            activityFilter.setStreamType(streamType);
        } else if (StringUtils.isNotBlank((CharSequence)spaceId)) {
            activityFilter.setStreamType(ActivityStreamType.ANY_SPACE_ACTIVITY);
        } else {
            activityFilter.setStreamType(ActivityStreamType.ALL_STREAM);
        }
        try {
            listAccess = this.activityManager.getActivitiesByFilterWithListAccess(currentUserIdentity, activityFilter);
        }
        catch (IllegalAccessException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.UNAUTHORIZED);
        }
        catch (ObjectNotFoundException e) {
            throw new WebApplicationException((Throwable)e, Response.Status.NOT_FOUND);
        }
        String entitiesName = null;
        List<DataEntity> activityEntities = null;
        boolean retrieveIds = StringUtils.contains((CharSequence)expand, (CharSequence)"ids");
        List activityIds = null;
        if (retrieveIds) {
            activityIds = listAccess.loadIdsAsList(offset, limit);
            activityEntities = activityIds.stream().map(id -> {
                DataEntity dataEntity = new DataEntity();
                dataEntity.setProperty("id", id);
                return dataEntity;
            }).toList();
            entitiesName = "activityIds";
        } else {
            List activities = listAccess.loadAsList(offset, limit);
            activityEntities = this.convertToEntities(activities, currentUserIdentity, uriInfo, expand);
            entitiesName = "activities";
        }
        CollectionEntity collectionActivity = new CollectionEntity(activityEntities, entitiesName, offset, limit);
        if (returnSize) {
            collectionActivity.setSize(listAccess.getSize());
        }
        collectionActivity.put("canPost", canPost);
        Response.ResponseBuilder responseBuilder = EntityBuilder.getResponseBuilder(collectionActivity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
        if (activityIds != null && !activityIds.isEmpty() && (preloadLimit = limit / 2) > 1) {
            String preloadExpand = expand.replaceFirst(",?ids,?", "");
            this.addPreloadActivityIds(activityIds, preloadLimit, preloadExpand, responseBuilder);
        }
        return responseBuilder.build();
    }

    @POST
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Posts an activity to a specific space", description="This posts the activity if the authenticated user is a member of the space or a spaces super manager.", method="POST")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response postActivity(@Context UriInfo uriInfo, @Parameter(description="Space id", required=true) @QueryParam(value="spaceId") String spaceId, @Parameter(description="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Activity object to be created", required=true) ActivityEntity model) {
        if (model == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentUser.getUserId();
        org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = null;
        if (StringUtils.isNotBlank((CharSequence)spaceId)) {
            Space space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            if (!this.activityManager.canPostActivityInStream(currentUser, spaceIdentity)) {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        } else if (!this.activityManager.canPostActivityInStream(currentUser, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ExoSocialActivityImpl activity = new ExoSocialActivityImpl();
        if (StringUtils.isBlank((CharSequence)model.getTitle())) {
            activity.setTitle("");
        } else {
            activity.setTitle(model.getTitle());
        }
        activity.setBody(model.getBody());
        activity.setType(model.getType());
        activity.setUserId(authenticatedUserIdentity.getId());
        activity.setFiles(model.getFiles());
        EntityBuilder.buildActivityParamsFromEntity((ExoSocialActivity)activity, model.getTemplateParams());
        if (StringUtils.isBlank((CharSequence)spaceId)) {
            this.activityManager.saveActivityNoReturn(authenticatedUserIdentity, (ExoSocialActivity)activity);
        } else {
            this.activityManager.saveActivityNoReturn(spaceIdentity, (ExoSocialActivity)activity);
        }
        ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity((ExoSocialActivity)activity, authenticatedUserIdentity, uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(activityEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{activityId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets a specific activity by id", description="This returns the activity in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user or one of his connections</li><li>this is a space activity and the authenticated user is a member of the space</li><li>the authenticated user is the super user</li></ul>", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getActivityById(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId, @Parameter(description="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand) {
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        long cacheTime = this.computeCacheTime(activity);
        String eTagValue = String.valueOf(Objects.hash(cacheTime, authenticatedUser, expand, LocalizationFilter.getCurrentLocale()));
        EntityTag eTag = new EntityTag(eTagValue, true);
        Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
        if (builder == null) {
            ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), expand);
            builder = Response.ok((Object)activityEntity.getDataEntity(), (String)"application/json");
            builder.tag(eTag);
            Date cacheTimeDate = new Date(this.computeLastUpdated(activity));
            builder.lastModified(cacheTimeDate);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setPrivate(true);
            builder.cacheControl(cacheControl);
        }
        return builder.build();
    }

    @PUT
    @Path(value="{activityId}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates a specific activity by id", description="This updates the activity in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user</li><li>the authenticated user is the super user</li></ul>", method="PUT")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateActivityById(@Context UriInfo uriInfo, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId, @Parameter(description="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Activity object to be updated, ex: <br/>{<br/>\"title\" : \"My activity\"<br/>}", required=true) ActivityEntity model) {
        if (model == null) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (!this.activityManager.isActivityEditable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        EntityBuilder.buildActivityFromEntity(model, activity);
        activity.setFiles(model.getFiles());
        activity.setUpdated(Long.valueOf(System.currentTimeMillis()));
        this.activityManager.updateActivity(activity, true);
        ActivityEntity activityInfo = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), expand);
        return EntityBuilder.getResponse(activityInfo.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @DELETE
    @Path(value="{activityId}")
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a specific activity by id", description="This deletes the activity in the following cases: <br/><ul><li>this is a user activity and the owner of the activity is the authenticated user</li><li>the authenticated user is the super user</li></ul>", method="DELETE")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteActivityById(@Context UriInfo uriInfo, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId, @Parameter(description="Whether to just hide the activity or effectively delete it from database", required=false) @Schema(defaultValue="false") @QueryParam(value="hide") boolean hide, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        ActivityEntity activityEntity;
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityDeletable(activity, ConversationState.getCurrent().getIdentity())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (hide) {
            activity = this.activityManager.hideActivity(activity.getId());
            activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), expand);
        } else {
            activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), expand);
            this.activityManager.deleteActivity(activity);
        }
        return EntityBuilder.getResponse(activityEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="{activityId}/comments")
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets comments of a specific activity", method="GET", description="This returns a list of comments if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getComments(@Context UriInfo uriInfo, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Returning the number of activities or not") @Schema(defaultValue="false") @QueryParam(value="returnSize") boolean returnSize, @Parameter(description="Retrieve comments by last post time or by first post time") @Schema(defaultValue="false") @QueryParam(value="sortDescending") boolean sortDescending, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Identity currentUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, currentUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<DataEntity> commentsEntity = EntityBuilder.buildEntityFromComment(activity, currentUser, uriInfo.getPath(), expand, sortDescending, offset, limit);
        ActivityCommentCollectionEntity collectionComment = new ActivityCommentCollectionEntity(commentsEntity, "comments", offset, limit);
        if (returnSize) {
            boolean expandSubComments = EntityBuilder.expandSubComments(expand);
            RealtimeListAccess listAccess = this.activityManager.getCommentsWithListAccess(activity, expandSubComments);
            collectionComment.setSize(listAccess.getSize());
        }
        if (StringUtils.contains((CharSequence)expand, (CharSequence)"totalCommentsCount")) {
            collectionComment.setTotalCommentsSize(this.activityManager.getNumberOfAllComments(activityId));
        }
        return EntityBuilder.getResponse(collectionComment, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/comments")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Posts a comment on a specific activity", method="POST", description="This posts the comment if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response postComment(@Context UriInfo uriInfo, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Comment object to be posted, ex: <br/>{<br/>\"title\" : \"My comment\"<br/>}", required=true) CommentEntity model) {
        if (model == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Comment entity is mandatory").build();
        }
        if (StringUtils.isNotBlank((CharSequence)model.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"comment identifier is not expected for comment creation").build();
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        ExoSocialActivityImpl comment = new ExoSocialActivityImpl();
        if (StringUtils.isBlank((CharSequence)model.getTitle())) {
            comment.setTitle("");
        } else {
            comment.setTitle(model.getTitle());
        }
        comment.setParentCommentId(model.getParentCommentId());
        comment.setPosterId(currentUser.getId());
        comment.setUserId(currentUser.getId());
        comment.setFiles(model.getFiles());
        EntityBuilder.buildActivityFromEntity(model, (ExoSocialActivity)comment);
        this.activityManager.saveComment(activity, (ExoSocialActivity)comment);
        CommentEntity commentEntity = EntityBuilder.buildEntityFromComment(this.activityManager.getActivity(comment.getId()), currentUser, uriInfo.getPath(), expand, false);
        return EntityBuilder.getResponse(commentEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PUT
    @Path(value="{activityId}/comments")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Updates an existing comment", method="PUT", description="This updates an existing comment if the authenticated user is poster of the comment.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response updateComment(@Context UriInfo uriInfo, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Comment object to be posted, ex: <br/>{<br/>\"title\" : \"My comment\"<br/>}", required=true) CommentEntity model) {
        if (model == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Comment entity is mandatory").build();
        }
        if (StringUtils.isBlank((CharSequence)model.getId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"comment identifier id mandatory").build();
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity comment = this.activityManager.getActivity(model.getId());
        if (comment == null) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        if (!comment.isComment() || StringUtils.isBlank((CharSequence)comment.getParentId())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"activity can't be updated as a comment").build();
        }
        if (!StringUtils.equals((CharSequence)comment.getParentId(), (CharSequence)activityId)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Can't move a comment from an activity to another").build();
        }
        if (!StringUtils.equals((CharSequence)comment.getParentCommentId(), (CharSequence)model.getParentCommentId())) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Can't move a comment reply from a comment to another").build();
        }
        if (!this.activityManager.isActivityEditable(comment, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        EntityBuilder.buildActivityFromEntity(model, comment);
        comment.setFiles(model.getFiles());
        if (StringUtils.isBlank((CharSequence)model.getTitle())) {
            comment.setTitle("");
        } else {
            comment.setTitle(model.getTitle());
        }
        comment.setUpdated(Long.valueOf(System.currentTimeMillis()));
        this.activityManager.updateActivity(comment, true);
        CommentEntity commentEntity = EntityBuilder.buildEntityFromComment(this.activityManager.getActivity(comment.getId()), currentUser, uriInfo.getPath(), expand, false);
        return EntityBuilder.getResponse(commentEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/share")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Shares a specific activity to specific spaces", method="POST", description="This shares the given activity to the target spaces if the authenticated user has permissions to post to the target spaces")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response shareActivity(@Context UriInfo uriInfo, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId, @Parameter(description="Asking for a full representation of a specific subresource, ex: comments or likes", required=false) @QueryParam(value="expand") String expand, @RequestBody(description="Share target spaces", required=true) ActivityEntity model) {
        List sharedActivities;
        if (StringUtils.isBlank((CharSequence)activityId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (model == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List<String> targetSpaces = model.getTargetSpaces();
        if (targetSpaces == null || targetSpaces.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity currentUser = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = currentUser.getUserId();
        org.exoplatform.social.core.identity.model.Identity authenticatedUserIdentity = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivityImpl activityTemplate = new ExoSocialActivityImpl();
        activityTemplate.setTitle(model.getTitle());
        activityTemplate.setBody(model.getBody());
        activityTemplate.setType(model.getType());
        activityTemplate.setUserId(authenticatedUserIdentity.getId());
        activityTemplate.setFiles(model.getFiles());
        EntityBuilder.buildActivityParamsFromEntity((ExoSocialActivity)activityTemplate, model.getTemplateParams());
        try {
            sharedActivities = this.activityManager.shareActivity((ExoSocialActivity)activityTemplate, activityId, targetSpaces, currentUser);
        }
        catch (IllegalAccessException e) {
            LOG.warn("User {} doesn't have access to share activity {}", new Object[]{authenticatedUser, activityId, e});
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)e.getMessage()).build();
        }
        catch (ObjectNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
        }
        List<DataEntity> sharedActivityEntities = this.convertToEntities(sharedActivities, authenticatedUserIdentity, uriInfo, expand);
        CollectionEntity collectionActivity = new CollectionEntity(sharedActivityEntities, "activities", 0, sharedActivityEntities.size());
        return EntityBuilder.getResponse(collectionActivity, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @PUT
    @Path(value="{activityId}/unhide")
    @RolesAllowed(value={"users"})
    @Operation(summary="Unhides an activity to publish it in users stream", method="PUT", description="This unhides the given activity to publish it in users stream if the authenticated user has edit permissions")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized")})
    public Response publishActivity(@Context UriInfo uriInfo, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId) {
        if (StringUtils.isBlank((CharSequence)activityId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (!this.activityManager.isActivityEditable(activity, ConversationState.getCurrent().getIdentity())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        activity.isHidden(false);
        this.activityManager.updateActivity(activity, true);
        return Response.noContent().build();
    }

    @GET
    @Path(value="{activityId}/likes")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets likes of a specific activity", method="GET", description="This returns a list of likes if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response getLikesOfActivity(@Context UriInfo uriInfo, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Asking for a full representation of a specific subresource if any", required=false) @QueryParam(value="expand") String expand) {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        List<DataEntity> likesEntity = EntityBuilder.buildEntityFromLike(activity, uriInfo.getPath(), expand, offset, limit);
        CollectionEntity collectionLike = new CollectionEntity(likesEntity, "likes", offset, limit);
        collectionLike.setSize(activity.getLikeIdentityIds() == null ? 0 : activity.getLikeIdentityIds().length);
        return EntityBuilder.getResponse(collectionLike, uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @POST
    @Path(value="{activityId}/likes")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Adds a like to a specific activity", method="POST", description="This adds the like if the authenticated user has permissions to see the activity.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response addLike(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId) {
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.activityManager.saveLike(activity, currentUser);
        return this.getLikesOfActivity(uriInfo, activityId, 0, 20, null);
    }

    @DELETE
    @Path(value="{activityId}/likes")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Deletes a like of a specific user for a given activity", method="DELETE", description="This deletes the like of authenticated user from an activity")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response deleteLike(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId) {
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        this.activityManager.deleteLike(activity, currentUser);
        return this.getLikesOfActivity(uriInfo, activityId, 0, 20, null);
    }

    @POST
    @Path(value="{activityId}/pins")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Pin a specific activity to space stream", method="POST", description="This pins an activity to space stream if the authenticated user is a manager or a redactor of the space.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Activity not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response pinActivity(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId) {
        if (StringUtils.isBlank((CharSequence)activityId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.activityManager.canPinActivity(activity, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        activity = this.activityManager.pinActivity(activity.getId(), currentUser.getId());
        ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), null);
        return EntityBuilder.getResponse(activityEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @DELETE
    @Path(value="{activityId}/pins")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Unpin a specific activity from space stream", method="DELETE", description="This Unpins an activity from space stream")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Activity not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response unpinActivity(@Context UriInfo uriInfo, @Context Request request, @Parameter(description="Activity id", required=true) @PathParam(value="activityId") String activityId) {
        if (StringUtils.isBlank((CharSequence)activityId)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Identity authenticatedUserIdentity = ConversationState.getCurrent().getIdentity();
        String authenticatedUser = authenticatedUserIdentity.getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUser = this.identityManager.getOrCreateIdentity("organization", authenticatedUser);
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null || !this.activityManager.isActivityViewable(activity, authenticatedUserIdentity)) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!this.activityManager.canPinActivity(activity, currentUser)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        activity = this.activityManager.unpinActivity(activity.getId());
        ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUser, uriInfo.getPath(), null);
        return EntityBuilder.getResponse(activityEntity.getDataEntity(), uriInfo, RestUtils.getJsonMediaType(), Response.Status.OK);
    }

    @GET
    @Path(value="search")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Search activities using a query", method="GET", description="This returns a list of activities found by using search term")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error"), @ApiResponse(responseCode="400", description="Invalid query input")})
    public Response searchActivities(@Context UriInfo uriInfo, @Parameter(description="Term to search", required=true) @QueryParam(value="q") String query, @Parameter(description="Whether to search in favorites only or not", required=false) @QueryParam(value="favorites") boolean isFavorite, @Parameter(description="Category id used to search associated activities", required=false) @QueryParam(value="categoryId") List<Long> categoryIds, @Parameter(description="Tag names used to search activities", required=false) @QueryParam(value="tags") List<String> tagNames, @Parameter(description="Space id used to search activities", required=false) @QueryParam(value="spaceId") List<Long> spaceIds, @Parameter(description="Field to sort by") @QueryParam(value="sortField") String sortField, @Parameter(description="Sort order (asc or desc)") @QueryParam(value="sortDirection") String sortDirection, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit, @Parameter(description="Asking for a full representation of a specific subresource", required=false) @QueryParam(value="expand") String expand) {
        offset = offset > 0 ? offset : RestUtils.getOffset(uriInfo);
        int n = limit = limit > 0 ? limit : RestUtils.getLimit(uriInfo);
        if (StringUtils.isBlank((CharSequence)query) && !isFavorite && CollectionUtils.isEmpty(tagNames)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"'q' parameter is mandatory").build();
        }
        String authenticatedUser = ConversationState.getCurrent().getIdentity().getUserId();
        org.exoplatform.social.core.identity.model.Identity currentUserIdentity = this.identityManager.getOrCreateUserIdentity(authenticatedUser);
        List<Long> spaceIdentityIds = null;
        if (CollectionUtils.isNotEmpty(spaceIds)) {
            List<String> spaceIdsString = spaceIds.stream().map(String::valueOf).toList();
            spaceIdentityIds = SpaceUtils.getSpaceIdentityIds((String)authenticatedUser, spaceIdsString).stream().map(Long::valueOf).toList();
        }
        ActivitySearchFilter filter = new ActivitySearchFilter(query, tagNames, categoryIds, spaceIdentityIds, isFavorite, sortField, sortDirection);
        List searchResults = this.activitySearchConnector.search(currentUserIdentity, filter, (long)offset, (long)limit);
        List<ActivitySearchResultEntity> results = searchResults.stream().map(searchResult -> {
            ExoSocialActivity existingActivity;
            Map<String, List<MetadataItemEntity>> activityMetadatasToPublish;
            ActivitySearchResultEntity entity = EntityBuilder.buildEntityFromActivitySearchResult(searchResult);
            entity.setPoster(EntityBuilder.buildEntityIdentity(searchResult.getPoster(), uriInfo.getPath(), "all"));
            entity.setStreamOwner(EntityBuilder.buildEntityIdentity(searchResult.getStreamOwner(), uriInfo.getPath(), "all"));
            ActivitySearchResult comment = searchResult.getComment();
            if (comment != null) {
                ActivitySearchResultEntity commentEntity = EntityBuilder.buildEntityFromActivitySearchResult(comment);
                commentEntity.setPoster(EntityBuilder.buildEntityIdentity(comment.getPoster(), uriInfo.getPath(), "all"));
                commentEntity.setStreamOwner(EntityBuilder.buildEntityIdentity(comment.getStreamOwner(), uriInfo.getPath(), "all"));
                entity.setComment(commentEntity);
            }
            if (MapUtils.isNotEmpty(activityMetadatasToPublish = EntityBuilder.retrieveMetadataItems(existingActivity = this.activityManager.getActivity(entity.getId()), currentUserIdentity))) {
                entity.setMetadatas(activityMetadatasToPublish);
            }
            DataEntity activityDataEntity = EntityBuilder.buildEntityFromActivity(existingActivity, currentUserIdentity, uriInfo.getPath(), expand).getDataEntity();
            entity.setDataEntity(activityDataEntity);
            return entity;
        }).toList();
        return Response.ok(results).build();
    }

    private List<DataEntity> convertToEntities(List<ExoSocialActivity> activities, org.exoplatform.social.core.identity.model.Identity currentUserIdentity, UriInfo uriInfo, String expand) {
        ArrayList<DataEntity> activityEntities = new ArrayList<DataEntity>();
        for (ExoSocialActivity activity : activities) {
            ActivityEntity activityEntity = EntityBuilder.buildEntityFromActivity(activity, currentUserIdentity, uriInfo.getPath(), expand);
            activityEntities.add(activityEntity.getDataEntity());
        }
        return activityEntities;
    }

    private void addPreloadActivityIds(List<String> activityIds, int preloadLimit, String expand, Response.ResponseBuilder responseBuilder) {
        int offset;
        int n = offset = preloadLimit > 10 ? preloadLimit - 10 : 0;
        if (activityIds.size() < preloadLimit) {
            preloadLimit = activityIds.size();
            offset = offset > 10 ? offset : 0;
        }
        List<String> preloadActivityIds = activityIds.subList(offset, preloadLimit);
        for (String activityId : preloadActivityIds) {
            String activityLoadingURL = "/portal/rest/v1/social/activities/" + activityId + "?expand=" + expand;
            responseBuilder.header("Link", (Object)("<" + activityLoadingURL + ">; rel=preload; as=fetch; crossorigin=use-credentials"));
        }
    }

    private long computeCacheTime(ExoSocialActivity activity) {
        long cacheTime = activity.getCacheTime();
        String prettyId = activity.getActivityStream().getPrettyId();
        org.exoplatform.social.core.identity.model.Identity streamOwnerIdentity = activity.getActivityStream().getType() == ActivityStream.Type.SPACE ? this.identityManager.getOrCreateSpaceIdentity(prettyId) : this.identityManager.getOrCreateUserIdentity(prettyId);
        cacheTime = streamOwnerIdentity == null ? System.currentTimeMillis() : streamOwnerIdentity.getCacheTime() + cacheTime * 32L;
        org.exoplatform.social.core.identity.model.Identity posterIdentity = this.identityManager.getIdentity(activity.getPosterId());
        cacheTime = posterIdentity == null ? System.currentTimeMillis() : posterIdentity.getCacheTime() + cacheTime * 32L;
        return cacheTime;
    }

    private long computeLastUpdated(ExoSocialActivity activity) {
        org.exoplatform.social.core.identity.model.Identity posterIdentity;
        long lastUpdate = activity.getCacheTime();
        String prettyId = activity.getActivityStream().getPrettyId();
        org.exoplatform.social.core.identity.model.Identity streamOwnerIdentity = activity.getActivityStream().getType() == ActivityStream.Type.SPACE ? this.identityManager.getOrCreateSpaceIdentity(prettyId) : this.identityManager.getOrCreateUserIdentity(prettyId);
        if (streamOwnerIdentity != null) {
            long l = lastUpdate = streamOwnerIdentity.getCacheTime() > lastUpdate ? streamOwnerIdentity.getCacheTime() : lastUpdate;
        }
        if ((posterIdentity = this.identityManager.getIdentity(activity.getPosterId())) != null) {
            lastUpdate = posterIdentity.getCacheTime() > lastUpdate ? posterIdentity.getCacheTime() : lastUpdate;
        }
        return lastUpdate;
    }
}

