/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedDerivedRootJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedRootJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmCteJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.spi.NavigablePath;

public class SqmCorrelatedCteJoin<T>
extends SqmCteJoin<T>
implements SqmCorrelation<T, T> {
    private final SqmCorrelatedRootJoin<T> correlatedRootJoin;
    private final SqmCteJoin<T> correlationParent;

    public SqmCorrelatedCteJoin(SqmCteJoin<T> correlationParent) {
        super(correlationParent.getCte(), correlationParent.getExplicitAlias(), correlationParent.getSqmJoinType(), correlationParent.getRoot());
        this.correlatedRootJoin = SqmCorrelatedDerivedRootJoin.create(correlationParent, this);
        this.correlationParent = correlationParent;
    }

    private SqmCorrelatedCteJoin(NavigablePath navigablePath, SqmCteStatement<T> cte, SqmPathSource<T> pathSource, String alias, SqmJoinType joinType, SqmRoot<T> sqmRoot, SqmCorrelatedRootJoin<T> correlatedRootJoin, SqmCteJoin<T> correlationParent) {
        super(navigablePath, cte, pathSource, alias, joinType, sqmRoot);
        this.correlatedRootJoin = correlatedRootJoin;
        this.correlationParent = correlationParent;
    }

    @Override
    public SqmCorrelatedCteJoin<T> copy(SqmCopyContext context) {
        SqmCorrelatedCteJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmCorrelatedCteJoin path = context.registerCopy(this, new SqmCorrelatedCteJoin(this.getNavigablePath(), this.getCte().copy(context), this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), this.findRoot().copy(context), this.correlatedRootJoin.copy(context), this.correlationParent.copy(context)));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmCteJoin<T> getCorrelationParent() {
        return this.correlationParent;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.correlationParent;
    }

    @Override
    public boolean isCorrelated() {
        return true;
    }

    @Override
    public SqmRoot<T> getCorrelatedRoot() {
        return this.correlatedRootJoin;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCorrelatedCteJoin(this);
    }
}

