/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.net.MalformedURLException;
import java.net.URL;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassJavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;

public class UrlJavaType
extends AbstractClassJavaType<URL> {
    public static final UrlJavaType INSTANCE = new UrlJavaType();

    public UrlJavaType() {
        super(URL.class);
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getJdbcType(12);
    }

    @Override
    public boolean useObjectEqualsHashCode() {
        return true;
    }

    @Override
    public String toString(URL value) {
        return value.toExternalForm();
    }

    @Override
    public URL fromString(CharSequence string) {
        try {
            return new URL(string.toString());
        }
        catch (MalformedURLException e) {
            throw new HibernateException("Unable to convert string [" + String.valueOf(string) + "] to URL : " + String.valueOf(e));
        }
    }

    @Override
    public <X> X unwrap(URL value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (URL.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> URL wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (value instanceof URL) {
            return (URL)value;
        }
        if (value instanceof CharSequence) {
            return this.fromString((CharSequence)value);
        }
        throw this.unknownWrap(value.getClass());
    }
}

