/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.appcenter.plugin;

import io.meeds.appcenter.service.ApplicationCenterService;
import io.meeds.social.translation.plugin.TranslationPlugin;
import io.meeds.social.translation.service.TranslationService;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApplicationTranslationPlugin
extends TranslationPlugin {
    public static final String APPLICATION_OBJECT_TYPE = "appCenter";
    @Autowired
    private TranslationService translationService;
    @Autowired
    private ApplicationCenterService applicationCenterService;

    @PostConstruct
    public void init() {
        this.translationService.addPlugin((TranslationPlugin)this);
    }

    public String getObjectType() {
        return APPLICATION_OBJECT_TYPE;
    }

    public boolean hasAccessPermission(String applicationId, String username) {
        return true;
    }

    public boolean hasEditPermission(String applicationId, String username) {
        return this.applicationCenterService.canEdit(username);
    }

    public long getAudienceId(String applicationId) {
        return 0L;
    }

    public long getSpaceId(String applicationId) {
        return 0L;
    }
}

