/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.ide.rest;

import io.meeds.ide.model.Widget;
import io.meeds.ide.service.StaticResourceService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.security.access.annotation.Secured;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/static/resources"})
@Tag(name="/ide/rest/static/resources", description="Managing Static Resource Applications")
public class StaticResourceRest {
    @Autowired
    private StaticResourceService staticResourceApplicationService;

    @GetMapping
    @Secured(value={"administrators"})
    @Operation(summary="Retrieve a static resource applications", method="GET", description="Retrieve a static resource applications")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="404", description="Widget not found")})
    public List<Widget> getStaticResources(HttpServletRequest request, @RequestParam(value="siteName") String siteName) {
        try {
            return this.staticResourceApplicationService.getStaticResources(siteName, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }

    @PostMapping
    @Secured(value={"administrators"})
    @Operation(summary="Create a Static Resource", method="POST", description="Create a Static Resource")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="403", description="Forbidden")})
    public Widget createStaticResource(HttpServletRequest request, @RequestBody Widget widget) {
        try {
            return this.staticResourceApplicationService.createStaticResource(widget, request.getRemoteUser());
        }
        catch (IllegalAccessException e) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, e.getMessage());
        }
    }
}

