/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support.value;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.lang.Nullable;

public class ElasticsearchCollectionValueToStringConverter
implements GenericConverter {
    private static final String DELIMITER = ",";
    private final ConversionService conversionService;

    public ElasticsearchCollectionValueToStringConverter(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Collection.class, String.class));
    }

    @Nullable
    public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return "[]";
        }
        Collection sourceCollection = (Collection)source;
        if (sourceCollection.isEmpty()) {
            return "[]";
        }
        StringJoiner sb = new StringJoiner(DELIMITER, "[", "]");
        for (Object sourceElement : sourceCollection) {
            if (Objects.isNull(sourceElement)) continue;
            Object targetElement = this.conversionService.convert(sourceElement, sourceType.elementTypeDescriptor(sourceElement), targetType);
            if (sourceElement instanceof String) {
                sb.add("\"" + String.valueOf(targetElement) + "\"");
                continue;
            }
            sb.add(String.valueOf(targetElement));
        }
        return sb.toString();
    }
}

